/*     */ package org.jboss.kernel.plugins.bootstrap.basic;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.Properties;
/*     */ import org.jboss.kernel.plugins.bootstrap.AbstractBootstrap;
/*     */ import org.jboss.kernel.plugins.config.property.PropertyKernelConfig;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ 
/*     */ public class BasicBootstrap extends AbstractBootstrap
/*     */ {
/*     */   public static void main(String[] args)
/*     */     throws Exception
/*     */   {
/*  49 */     BasicBootstrap bootstrap = new BasicBootstrap();
/*  50 */     bootstrap.run();
/*     */   }
/*     */ 
/*     */   public BasicBootstrap()
/*     */   {
/*  59 */     Properties props = getConfigProperties();
/*  60 */     if (props == null)
/*  61 */       props = getSystemProperties();
/*  62 */     PropertyKernelConfig config = new PropertyKernelConfig(props);
/*  63 */     PrivilegedAction action = new PrivilegedAction(config)
/*     */     {
/*     */       public Object run()
/*     */       {
/*  67 */         BasicBootstrap.this.setConfig(this.val$config);
/*  68 */         return null;
/*     */       }
/*     */     };
/*  71 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   public BasicBootstrap(KernelConfig config)
/*     */     throws Exception
/*     */   {
/*  82 */     PrivilegedAction action = new PrivilegedAction(config)
/*     */     {
/*     */       public Object run()
/*     */       {
/*  86 */         BasicBootstrap.this.setConfig(this.val$config);
/*  87 */         return null;
/*     */       }
/*     */     };
/*  90 */     AccessController.doPrivileged(action);
/*     */   }
/*     */ 
/*     */   protected Properties getConfigProperties()
/*     */   {
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   private Properties getSystemProperties()
/*     */   {
/* 105 */     if (System.getSecurityManager() == null) {
/* 106 */       return System.getProperties();
/*     */     }
/*     */ 
/* 109 */     return (Properties)AccessController.doPrivileged(GetSystemProperties.instance);
/*     */   }
/*     */ 
/*     */   private static class GetSystemProperties
/*     */     implements PrivilegedAction<Properties>
/*     */   {
/* 115 */     private static GetSystemProperties instance = new GetSystemProperties();
/*     */ 
/*     */     public Properties run()
/*     */     {
/* 119 */       return System.getProperties();
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.bootstrap.basic.BasicBootstrap
 * JD-Core Version:    0.6.0
 */