/*     */ package org.jboss.kernel.plugins.bootstrap;
/*     */ 
/*     */ import org.jboss.kernel.Kernel;
/*     */ import org.jboss.kernel.KernelFactory;
/*     */ import org.jboss.kernel.plugins.AbstractKernelObject;
/*     */ import org.jboss.kernel.spi.config.KernelConfig;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public abstract class AbstractBootstrap extends AbstractKernelObject
/*     */   implements Runnable
/*     */ {
/*     */   protected KernelConfig config;
/*     */   protected Kernel kernel;
/*     */ 
/*     */   public KernelConfig getConfig()
/*     */   {
/*  61 */     Kernel.checkAccess();
/*  62 */     return this.config;
/*     */   }
/*     */ 
/*     */   public void setConfig(KernelConfig config)
/*     */   {
/*  72 */     Kernel.checkConfigure();
/*  73 */     this.config = config;
/*     */   }
/*     */ 
/*     */   public Kernel getKernel()
/*     */   {
/*  82 */     return this.kernel;
/*     */   }
/*     */ 
/*     */   public void run()
/*     */   {
/*     */     try
/*     */     {
/*  89 */       bootstrap();
/*     */     }
/*     */     catch (RuntimeException e)
/*     */     {
/*  93 */       this.log.trace("RuntimeException during JBoss Kernel Bootstrap.", e);
/*  94 */       throw e;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  98 */       this.log.trace("Exception during JBoss Kernel Bootstrap.", e);
/*  99 */       throw new RuntimeException("Exception during Bootstrap", e);
/*     */     }
/*     */     catch (Error e)
/*     */     {
/* 103 */       this.log.trace("Error during JBoss Kernel Bootstrap.", e);
/* 104 */       throw e;
/*     */     }
/*     */     catch (Throwable t)
/*     */     {
/* 108 */       this.log.trace("Error during JBoss Kernel Bootstrap.", t);
/* 109 */       throw new RuntimeException("Error during Bootstrap", t);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void bootstrap()
/*     */     throws Throwable
/*     */   {
/* 120 */     this.kernel = KernelFactory.newInstance(this.config);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.bootstrap.AbstractBootstrap
 * JD-Core Version:    0.6.0
 */