/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import org.jboss.beans.metadata.api.annotations.Inject;
/*     */ import org.jboss.beans.metadata.api.annotations.JavaBeanValue;
/*     */ import org.jboss.beans.metadata.api.annotations.NullValue;
/*     */ import org.jboss.beans.metadata.api.annotations.Parameter;
/*     */ import org.jboss.beans.metadata.api.annotations.StringValue;
/*     */ import org.jboss.beans.metadata.api.annotations.ThisValue;
/*     */ import org.jboss.beans.metadata.api.annotations.Value;
/*     */ import org.jboss.beans.metadata.api.annotations.ValueFactory;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ 
/*     */ final class ValueUtil
/*     */ {
/*     */   private static void checkValueMetaData(ValueMetaData value)
/*     */   {
/*  48 */     if (value != null)
/*  49 */       throw new IllegalArgumentException("@Value/@Parameter annotation has too many values set!");
/*     */   }
/*     */ 
/*     */   static boolean isAttributePresent(String value)
/*     */   {
/*  60 */     return (value != null) && (value.length() > 0);
/*     */   }
/*     */ 
/*     */   static ValueMetaData createValueMetaData(Value value)
/*     */   {
/*  71 */     ValueMetaData vmd = null;
/*     */ 
/*  73 */     StringValue string = value.string();
/*  74 */     if (isAttributePresent(string.value()))
/*     */     {
/*  76 */       vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
/*     */     }
/*     */ 
/*  79 */     Inject inject = value.inject();
/*  80 */     if (inject.valid())
/*     */     {
/*  82 */       checkValueMetaData(vmd);
/*  83 */       vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
/*     */     }
/*     */ 
/*  86 */     ValueFactory vf = value.valueFactory();
/*  87 */     if (isAttributePresent(vf.bean()))
/*     */     {
/*  89 */       checkValueMetaData(vmd);
/*  90 */       vmd = ValueFactoryAnnotationPlugin.INSTANCE.createValueMetaData(vf);
/*     */     }
/*     */ 
/*  93 */     ThisValue thisValue = value.thisValue();
/*  94 */     if (thisValue.valid())
/*     */     {
/*  96 */       checkValueMetaData(vmd);
/*  97 */       vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
/*     */     }
/*     */ 
/* 100 */     NullValue nullValue = value.nullValue();
/* 101 */     if (nullValue.valid())
/*     */     {
/* 103 */       checkValueMetaData(vmd);
/* 104 */       vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
/*     */     }
/*     */ 
/* 107 */     JavaBeanValue javabean = value.javabean();
/* 108 */     if (isAttributePresent(javabean.value()))
/*     */     {
/* 110 */       checkValueMetaData(vmd);
/* 111 */       vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
/*     */     }
/*     */ 
/* 114 */     if (vmd == null) {
/* 115 */       throw new IllegalArgumentException("No value set on @Value annotation!");
/*     */     }
/* 117 */     return vmd;
/*     */   }
/*     */ 
/*     */   static ValueMetaData createValueMetaData(Parameter parameter)
/*     */   {
/* 128 */     ValueMetaData vmd = null;
/*     */ 
/* 130 */     StringValue string = parameter.string();
/* 131 */     if (isAttributePresent(string.value()))
/*     */     {
/* 133 */       vmd = StringValueAnnotationPlugin.INSTANCE.createValueMetaData(string);
/*     */     }
/*     */ 
/* 136 */     Inject inject = parameter.inject();
/* 137 */     if (inject.valid())
/*     */     {
/* 139 */       checkValueMetaData(vmd);
/* 140 */       vmd = InjectAnnotationPlugin.INSTANCE.createValueMetaData(inject);
/*     */     }
/*     */ 
/* 143 */     ThisValue thisValue = parameter.thisValue();
/* 144 */     if (thisValue.valid())
/*     */     {
/* 146 */       checkValueMetaData(vmd);
/* 147 */       vmd = ThisValueAnnotationPlugin.INSTANCE.createValueMetaData(thisValue);
/*     */     }
/*     */ 
/* 150 */     NullValue nullValue = parameter.nullValue();
/* 151 */     if (nullValue.valid())
/*     */     {
/* 153 */       checkValueMetaData(vmd);
/* 154 */       vmd = NullValueAnnotationPlugin.INSTANCE.createValueMetaData(nullValue);
/*     */     }
/*     */ 
/* 157 */     JavaBeanValue javabean = parameter.javabean();
/* 158 */     if (isAttributePresent(javabean.value()))
/*     */     {
/* 160 */       checkValueMetaData(vmd);
/* 161 */       vmd = JavaBeanValueAnnotationPlugin.INSTANCE.createValueMetaData(javabean);
/*     */     }
/*     */ 
/* 164 */     if (vmd == null) {
/* 165 */       throw new IllegalArgumentException("No value set on @Value annotation!");
/*     */     }
/* 167 */     return vmd;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ValueUtil
 * JD-Core Version:    0.6.0
 */