/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.util.ArrayList;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.UninstallMethod;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*    */ import org.jboss.dependency.spi.ControllerState;
/*    */ import org.jboss.reflect.spi.MethodInfo;
/*    */ 
/*    */ public class UninstallMethodParameterAnnotationPlugin extends InstallationParameterAnnotationPlugin<UninstallMethod>
/*    */ {
/*    */   protected UninstallMethodParameterAnnotationPlugin(Annotation2ValueMetaDataAdapter[] adapters)
/*    */   {
/* 44 */     super(UninstallMethod.class, adapters);
/*    */   }
/*    */ 
/*    */   protected List<InstallMetaData> getInstalls(BeanMetaData beanMetaData)
/*    */   {
/* 49 */     return beanMetaData.getUninstalls();
/*    */   }
/*    */ 
/*    */   protected AbstractInstallMetaData createParametrizedMetaData(MethodInfo info, UninstallMethod annotation)
/*    */   {
/* 54 */     AbstractInstallMetaData uninstall = new AbstractInstallMetaData();
/* 55 */     uninstall.setMethodName(info.getName());
/* 56 */     if (isAttributePresent(annotation.dependantState()))
/* 57 */       uninstall.setDependentState(new ControllerState(annotation.dependantState()));
/* 58 */     return uninstall;
/*    */   }
/*    */ 
/*    */   protected void setParameterizedMetaData(AbstractInstallMetaData parameterizedMetaData, BeanMetaData beanMetaData)
/*    */   {
/* 63 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/* 64 */     List uninstalls = beanMetaData.getUninstalls();
/* 65 */     if (uninstalls == null)
/*    */     {
/* 67 */       uninstalls = new ArrayList();
/* 68 */       abmd.setUninstalls(uninstalls);
/*    */     }
/* 70 */     uninstalls.add(parameterizedMetaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.UninstallMethodParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */