/*     */ package org.jboss.kernel.plugins.annotations;
/*     */ 
/*     */ import java.lang.annotation.Annotation;
/*     */ import java.util.ArrayList;
/*     */ import java.util.List;
/*     */ import org.jboss.beans.metadata.api.annotations.ExternalInstall;
/*     */ import org.jboss.beans.metadata.api.annotations.Value;
/*     */ import org.jboss.beans.metadata.plugins.AbstractInstallMetaData;
/*     */ import org.jboss.beans.metadata.plugins.AbstractParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*     */ import org.jboss.beans.metadata.spi.InstallMetaData;
/*     */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*     */ import org.jboss.beans.metadata.spi.ParameterMetaData;
/*     */ import org.jboss.beans.metadata.spi.ValueMetaData;
/*     */ import org.jboss.dependency.spi.ControllerState;
/*     */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*     */ import org.jboss.reflect.spi.ClassInfo;
/*     */ 
/*     */ public abstract class ExternalInstallationAnnotationPlugin<C extends Annotation> extends ClassAnnotationPlugin<C>
/*     */ {
/*     */   protected ExternalInstallationAnnotationPlugin(Class<C> annotation)
/*     */   {
/*  51 */     super(annotation);
/*     */   }
/*     */ 
/*     */   protected abstract List<InstallMetaData> getExistingInstallMetaData(BeanMetaData paramBeanMetaData);
/*     */ 
/*     */   protected abstract ExternalInstall[] getExternalInstalls(C paramC);
/*     */ 
/*     */   protected List<InstallMetaData> getInstallMetaData(C annotation)
/*     */   {
/*  78 */     List installs = new ArrayList();
/*  79 */     for (ExternalInstall install : getExternalInstalls(annotation))
/*     */     {
/*  81 */       installs.add(createInstallMetaData(install));
/*     */     }
/*  83 */     return installs;
/*     */   }
/*     */ 
/*     */   protected InstallMetaData createInstallMetaData(ExternalInstall install)
/*     */   {
/*  94 */     AbstractInstallMetaData installMetaData = new AbstractInstallMetaData();
/*  95 */     installMetaData.setBean(install.bean());
/*  96 */     installMetaData.setMethodName(install.method());
/*  97 */     if (isAttributePresent(install.dependantState()))
/*  98 */       installMetaData.setDependentState(new ControllerState(install.dependantState()));
/*  99 */     for (Value value : install.parameters())
/*     */     {
/* 101 */       List parameters = installMetaData.getParameters();
/* 102 */       if (parameters == null)
/*     */       {
/* 104 */         parameters = new ArrayList();
/* 105 */         installMetaData.setParameters(parameters);
/*     */       }
/* 107 */       AbstractParameterMetaData parameter = new AbstractParameterMetaData(ValueUtil.createValueMetaData(value));
/* 108 */       if (isAttributePresent(value.type()))
/* 109 */         parameter.setType(value.type());
/* 110 */       parameters.add(parameter);
/*     */     }
/* 112 */     return installMetaData;
/*     */   }
/*     */ 
/*     */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, C annotation, KernelControllerContext context) throws Throwable
/*     */   {
/* 117 */     BeanMetaData beanMetaData = context.getBeanMetaData();
/* 118 */     List existing = getExistingInstallMetaData(beanMetaData);
/* 119 */     if (existing == null) {
/* 120 */       throw new IllegalArgumentException("Must set empty Set to installs/uninstalls!");
/*     */     }
/* 122 */     List installs = getInstallMetaData(annotation);
/* 123 */     if ((installs != null) && (!installs.isEmpty()))
/*     */     {
/* 125 */       List nodes = new ArrayList();
/* 126 */       for (InstallMetaData install : installs)
/*     */       {
/* 128 */         boolean doAdd = true;
/* 129 */         for (InstallMetaData existingInstall : existing)
/*     */         {
/* 131 */           if (!isDifferent(install, existingInstall))
/*     */           {
/* 133 */             doAdd = false;
/* 134 */             break;
/*     */           }
/*     */         }
/* 137 */         if (doAdd)
/*     */         {
/* 139 */           existing.add(install);
/* 140 */           nodes.add(install);
/*     */         }
/*     */       }
/* 143 */       return nodes;
/*     */     }
/* 145 */     return null;
/*     */   }
/*     */ 
/*     */   protected static boolean isDifferent(InstallMetaData first, InstallMetaData second)
/*     */   {
/* 157 */     if (notEqual(first.getBean(), second.getBean())) {
/* 158 */       return true;
/*     */     }
/* 160 */     if (notEqual(first.getMethodName(), second.getMethodName())) {
/* 161 */       return true;
/*     */     }
/* 163 */     List fstParameters = first.getParameters();
/* 164 */     List sndParameters = second.getParameters();
/* 165 */     int fstSize = fstParameters != null ? fstParameters.size() : 0;
/* 166 */     int sndSize = sndParameters != null ? sndParameters.size() : 0;
/* 167 */     if (fstSize != sndSize) {
/* 168 */       return true;
/*     */     }
/* 170 */     for (int i = 0; i < fstSize; i++)
/*     */     {
/* 172 */       ParameterMetaData fstParameter = (ParameterMetaData)fstParameters.get(i);
/* 173 */       ParameterMetaData sndParameter = (ParameterMetaData)sndParameters.get(i);
/*     */ 
/* 175 */       if (notEqual(fstParameter.getType(), sndParameter.getType())) {
/* 176 */         return true;
/*     */       }
/* 178 */       ValueMetaData fstValue = fstParameter.getValue();
/* 179 */       ValueMetaData sndValue = sndParameter.getValue();
/* 180 */       Class fstClass = fstValue != null ? fstValue.getClass() : null;
/* 181 */       Class sndClass = sndValue != null ? sndValue.getClass() : null;
/*     */ 
/* 183 */       if (notEqual(fstClass, sndClass)) {
/* 184 */         return true;
/*     */       }
/* 186 */       Object fstObject = fstValue != null ? fstValue.getUnderlyingValue() : null;
/* 187 */       Object sndObject = sndValue != null ? sndValue.getUnderlyingValue() : null;
/*     */ 
/* 192 */       if ((fstObject != null) && (sndObject != null) && (notEqual(fstObject, sndObject))) {
/* 193 */         return true;
/*     */       }
/*     */     }
/* 196 */     return false;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ExternalInstallationAnnotationPlugin
 * JD-Core Version:    0.6.0
 */