/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import java.util.Collections;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.reflect.spi.ClassInfo;
/*    */ 
/*    */ public abstract class ConstructorValueAnnotationPlugin<C extends Annotation> extends ClassAnnotationPlugin<C>
/*    */   implements Annotation2ValueMetaDataAdapter<C>
/*    */ {
/*    */   protected ConstructorValueAnnotationPlugin(Class<C> annotation)
/*    */   {
/* 45 */     super(annotation);
/*    */   }
/*    */ 
/*    */   protected boolean isMetaDataAlreadyPresent(ClassInfo info, C annotation, BeanMetaData beanMetaData)
/*    */   {
/* 50 */     return beanMetaData.getConstructor() != null;
/*    */   }
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(ClassInfo info, C annotation, KernelControllerContext context) throws Throwable
/*    */   {
/* 55 */     AbstractBeanMetaData beanMetaData = (AbstractBeanMetaData)context.getBeanMetaData();
/* 56 */     AbstractConstructorMetaData constructor = new AbstractConstructorMetaData();
/* 57 */     constructor.setValue(createValueMetaData(annotation));
/* 58 */     beanMetaData.setConstructor(constructor);
/*    */ 
/* 60 */     beanMetaData.setBean(null);
/* 61 */     context.setBeanInfo(null);
/* 62 */     return Collections.singletonList(constructor);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ConstructorValueAnnotationPlugin
 * JD-Core Version:    0.6.0
 */