/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.lang.annotation.ElementType;
/*    */ import java.util.List;
/*    */ import org.jboss.beans.metadata.api.annotations.Constructor;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
/*    */ import org.jboss.beans.metadata.spi.BeanMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.reflect.spi.ConstructorInfo;
/*    */ import org.jboss.reflect.spi.ParameterInfo;
/*    */ 
/*    */ public class ConstructorParameterAnnotationPlugin extends AbstractParameterAnnotationPlugin<ConstructorInfo, Constructor, AbstractConstructorMetaData>
/*    */ {
/*    */   protected ConstructorParameterAnnotationPlugin(Annotation2ValueMetaDataAdapter[] adapters)
/*    */   {
/* 44 */     super(Constructor.class, adapters);
/*    */   }
/*    */ 
/*    */   protected boolean checkAnnotatedInfo(ElementType type)
/*    */   {
/* 49 */     return ElementType.CONSTRUCTOR == type;
/*    */   }
/*    */ 
/*    */   protected boolean isMetaDataAlreadyPresent(ConstructorInfo info, Constructor annotation, BeanMetaData beanMetaData)
/*    */   {
/* 54 */     return beanMetaData.getConstructor() != null;
/*    */   }
/*    */ 
/*    */   protected ParameterInfo[] getParameters(ConstructorInfo info)
/*    */   {
/* 59 */     return info.getParameters();
/*    */   }
/*    */ 
/*    */   protected List<MetaDataVisitorNode> handleParameterlessInfo(ConstructorInfo info, Constructor annotation, BeanMetaData beanMetaData)
/*    */   {
/* 65 */     return null;
/*    */   }
/*    */ 
/*    */   protected AbstractConstructorMetaData createParametrizedMetaData(ConstructorInfo info)
/*    */   {
/* 70 */     return new AbstractConstructorMetaData();
/*    */   }
/*    */ 
/*    */   protected void setParameterizedMetaData(AbstractConstructorMetaData parameterizedMetaData, BeanMetaData beanMetaData)
/*    */   {
/* 75 */     AbstractBeanMetaData abmd = (AbstractBeanMetaData)beanMetaData;
/* 76 */     abmd.setConstructor(parameterizedMetaData);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.ConstructorParameterAnnotationPlugin
 * JD-Core Version:    0.6.0
 */