/*    */ package org.jboss.kernel.plugins.annotations;
/*    */ 
/*    */ import java.lang.annotation.Annotation;
/*    */ import java.lang.annotation.ElementType;
/*    */ import java.util.Collections;
/*    */ import java.util.List;
/*    */ import java.util.Set;
/*    */ import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
/*    */ import org.jboss.beans.metadata.plugins.AbstractCallbackMetaData;
/*    */ import org.jboss.beans.metadata.spi.CallbackMetaData;
/*    */ import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
/*    */ import org.jboss.dependency.spi.CallbackItem;
/*    */ import org.jboss.dependency.spi.DependencyInfo;
/*    */ import org.jboss.kernel.spi.dependency.KernelControllerContext;
/*    */ import org.jboss.reflect.spi.AnnotatedInfo;
/*    */ 
/*    */ public abstract class CallbackAnnotationPlugin<T extends AnnotatedInfo, C extends Annotation> extends AbstractAnnotationPlugin<T, C>
/*    */ {
/*    */   protected CallbackAnnotationPlugin(Class<C> annotation)
/*    */   {
/* 50 */     super(annotation);
/*    */   }
/*    */ 
/*    */   protected boolean isElementTypeSupported(ElementType type)
/*    */   {
/* 55 */     return ElementType.METHOD == type;
/*    */   }
/*    */ 
/*    */   protected boolean isMetaDataAlreadyPresent(T info, C annotation, KernelControllerContext context)
/*    */   {
/* 60 */     DependencyInfo dependency = context.getDependencyInfo();
/* 61 */     Set callbacks = getCallbacks(dependency);
/* 62 */     if ((callbacks != null) && (!callbacks.isEmpty()))
/*    */     {
/* 64 */       for (CallbackItem ci : callbacks)
/*    */       {
/* 66 */         if (isEqual(info, ci))
/* 67 */           return true;
/*    */       }
/*    */     }
/* 70 */     return false;
/*    */   }
/*    */ 
/*    */   protected abstract boolean isEqual(T paramT, CallbackItem<?> paramCallbackItem);
/*    */ 
/*    */   protected abstract Set<CallbackItem<?>> getCallbacks(DependencyInfo paramDependencyInfo);
/*    */ 
/*    */   protected List<? extends MetaDataVisitorNode> internalApplyAnnotation(T info, C annotation, KernelControllerContext context)
/*    */   {
/* 92 */     AbstractBeanMetaData beanMetaData = (AbstractBeanMetaData)context.getBeanMetaData();
/* 93 */     List callbacks = getCallbacks(beanMetaData);
/* 94 */     AbstractCallbackMetaData callback = createCallback(info, annotation);
/* 95 */     callbacks.add(callback);
/* 96 */     return Collections.singletonList(callback);
/*    */   }
/*    */ 
/*    */   protected abstract AbstractCallbackMetaData createCallback(T paramT, C paramC);
/*    */ 
/*    */   protected abstract void applyInfo(AbstractCallbackMetaData paramAbstractCallbackMetaData, T paramT);
/*    */ 
/*    */   protected abstract List<CallbackMetaData> getCallbacks(AbstractBeanMetaData paramAbstractBeanMetaData);
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.plugins.annotations.CallbackAnnotationPlugin
 * JD-Core Version:    0.6.0
 */