/*     */ package org.jboss.kernel;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.security.BasicPermission;
/*     */ import java.security.Permission;
/*     */ import java.security.PermissionCollection;
/*     */ import java.util.Enumeration;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ 
/*     */ public class KernelPermission extends BasicPermission
/*     */ {
/*     */   private static final long serialVersionUID = 5661980843569388590L;
/*     */   private transient boolean allNames;
/*     */ 
/*     */   public KernelPermission(String name)
/*     */   {
/*  63 */     this(name, null);
/*     */   }
/*     */ 
/*     */   public KernelPermission(String name, String actions)
/*     */   {
/*  76 */     super(name, actions);
/*  77 */     init(name, actions);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  85 */     StringBuffer buffer = new StringBuffer(100);
/*  86 */     buffer.append(getClass().getName()).append(":");
/*  87 */     buffer.append(" name=").append(getName());
/*  88 */     buffer.append(" actions=").append(getActions());
/*  89 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public boolean implies(Permission p)
/*     */   {
/* 105 */     if (!(p instanceof KernelPermission)) {
/* 106 */       return false;
/*     */     }
/* 108 */     boolean implies = this.allNames == true;
/* 109 */     if (!implies)
/*     */     {
/* 111 */       String n0 = getName();
/* 112 */       String n1 = p.getName();
/* 113 */       implies = n0.equals(n1);
/* 114 */       if (!implies)
/*     */       {
/* 117 */         implies = (n0.equals("configure")) && (n1.equals("access"));
/*     */       }
/*     */     }
/* 120 */     return implies;
/*     */   }
/*     */ 
/*     */   public PermissionCollection newPermissionCollection()
/*     */   {
/* 130 */     return new KernelPermissionCollection();
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException
/*     */   {
/* 135 */     ois.defaultReadObject();
/* 136 */     init(getName(), getActions());
/*     */   }
/*     */ 
/*     */   private void init(String name, String actions)
/*     */   {
/* 151 */     if (name == null) {
/* 152 */       throw new NullPointerException("name cannot be null");
/*     */     }
/* 154 */     if ((actions != null) && (actions.length() > 0)) {
/* 155 */       throw new IllegalArgumentException("actions must be null or empty");
/*     */     }
/* 157 */     if ((!name.equals("*")) && (!name.equals("access")) && (!name.equals("configure")))
/*     */     {
/* 160 */       throw new IllegalArgumentException("Unknown name: " + name);
/* 161 */     }this.allNames = name.equals("*");
/*     */   }
/*     */ 
/*     */   class KernelPermissionCollection extends PermissionCollection
/*     */   {
/*     */     private static final long serialVersionUID = 3256442516797665329L;
/* 173 */     private HashSet<Permission> permissions = new HashSet();
/*     */     private boolean hasAll;
/*     */ 
/*     */     KernelPermissionCollection()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void add(Permission p)
/*     */     {
/* 180 */       if (isReadOnly())
/* 181 */         throw new SecurityException("Collection is read-only");
/* 182 */       if ((p instanceof KernelPermission))
/* 183 */         this.permissions.add(p);
/* 184 */       if (p.getName().equals("configure"))
/* 185 */         this.permissions.add(new KernelPermission("access"));
/* 186 */       else if (p.getName().equals("*"))
/* 187 */         this.hasAll = true;
/*     */     }
/*     */ 
/*     */     public boolean implies(Permission p)
/*     */     {
/* 192 */       boolean implies = false;
/* 193 */       if ((p instanceof KernelPermission))
/*     */       {
/* 195 */         implies = this.hasAll;
/* 196 */         if (!implies)
/* 197 */           implies = this.permissions.contains(p);
/*     */       }
/* 199 */       return implies;
/*     */     }
/*     */ 
/*     */     public Enumeration<Permission> elements()
/*     */     {
/* 204 */       Iterator iter = this.permissions.iterator();
/* 205 */       return new Enumeration(iter)
/*     */       {
/*     */         public boolean hasMoreElements()
/*     */         {
/* 209 */           return this.val$iter.hasNext();
/*     */         }
/*     */ 
/*     */         public Permission nextElement()
/*     */         {
/* 214 */           return (Permission)this.val$iter.next();
/*     */         }
/*     */       };
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.kernel.KernelPermission
 * JD-Core Version:    0.6.0
 */