/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import org.jboss.remoting.loading.ObjectInputStreamWithClassLoader;
/*    */ 
/*    */ public class SerializedPacket extends PacketSupport
/*    */ {
/*    */   private Object payload;
/*    */ 
/*    */   public SerializedPacket()
/*    */   {
/*    */   }
/*    */ 
/*    */   public SerializedPacket(Object payload)
/*    */   {
/* 59 */     super(1);
/* 60 */     this.payload = payload;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is)
/*    */     throws Exception
/*    */   {
/* 69 */     ObjectInputStream ois = new ObjectInputStreamWithClassLoader(is, Thread.currentThread().getContextClassLoader());
/*    */ 
/* 72 */     this.payload = ois.readObject();
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 77 */     super.write(os);
/*    */ 
/* 79 */     ObjectOutputStream oos = new ObjectOutputStream(os);
/* 80 */     oos.writeObject(this.payload);
/* 81 */     os.flush();
/*    */   }
/*    */ 
/*    */   public Object getPayload()
/*    */   {
/* 88 */     return this.payload;
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 95 */     return "SerializedPacket[" + this.payload + "]";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.SerializedPacket
 * JD-Core Version:    0.6.0
 */