/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
/*    */ import java.util.Map;
/*    */ import org.jboss.jms.server.endpoint.advised.AdvisedSupport;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class Dispatcher
/*    */ {
/* 42 */   private static final Logger log = Logger.getLogger(Dispatcher.class);
/*    */ 
/* 44 */   public static Dispatcher instance = new Dispatcher();
/*    */   private Map targets;
/*    */ 
/*    */   private Dispatcher()
/*    */   {
/* 50 */     this.targets = new ConcurrentReaderHashMap();
/*    */   }
/*    */ 
/*    */   public Object getTarget(String id)
/*    */   {
/* 55 */     return this.targets.get(id);
/*    */   }
/*    */ 
/*    */   public void registerTarget(String id, AdvisedSupport obj)
/*    */   {
/* 60 */     this.targets.put(id, obj);
/*    */   }
/*    */ 
/*    */   public boolean unregisterTarget(String id, Object endpoint)
/*    */   {
/* 74 */     AdvisedSupport advised = (AdvisedSupport)(AdvisedSupport)this.targets.get(id);
/*    */ 
/* 76 */     if (advised == null)
/*    */     {
/* 79 */       log.warn("Cannot find object with id " + id + " to register");
/* 80 */       return false;
/*    */     }
/*    */ 
/* 83 */     if (advised.getEndpoint() != endpoint)
/*    */     {
/* 85 */       log.warn("The object you are trying to deregister is not the same as the one you registered!");
/* 86 */       return false;
/*    */     }
/*    */ 
/* 90 */     return this.targets.remove(id) != null;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.Dispatcher
 * JD-Core Version:    0.6.0
 */