/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*    */ 
/*    */ public class ConnectionSetClientIDRequest extends RequestSupport
/*    */ {
/*    */   private String clientID;
/*    */ 
/*    */   public ConnectionSetClientIDRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConnectionSetClientIDRequest(String objectId, byte version, String clientID)
/*    */   {
/* 51 */     super(objectId, 203, version);
/*    */ 
/* 53 */     this.clientID = clientID;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 58 */     super.read(is);
/*    */ 
/* 60 */     this.clientID = is.readUTF();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 65 */     ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 68 */     if (endpoint == null)
/*    */     {
/* 70 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/*    */ 
/* 73 */     endpoint.setClientID(this.clientID);
/*    */ 
/* 75 */     return null;
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 80 */     super.write(os);
/*    */ 
/* 82 */     os.writeUTF(this.clientID);
/*    */ 
/* 84 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionSetClientIDRequest
 * JD-Core Version:    0.6.0
 */