/*    */ package org.jboss.jms.wireformat;
/*    */ 
/*    */ import java.io.DataInputStream;
/*    */ import java.io.DataOutputStream;
/*    */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*    */ 
/*    */ public class ConnectionGetIDBlockRequest extends RequestSupport
/*    */ {
/*    */   private int size;
/*    */ 
/*    */   public ConnectionGetIDBlockRequest()
/*    */   {
/*    */   }
/*    */ 
/*    */   public ConnectionGetIDBlockRequest(String objectId, byte version, int size)
/*    */   {
/* 41 */     super(objectId, 101, version);
/*    */ 
/* 43 */     this.size = size;
/*    */   }
/*    */ 
/*    */   public void read(DataInputStream is) throws Exception
/*    */   {
/* 48 */     super.read(is);
/*    */ 
/* 50 */     this.size = is.readInt();
/*    */   }
/*    */ 
/*    */   public ResponseSupport serverInvoke() throws Exception
/*    */   {
/* 55 */     ConnectionEndpoint endpoint = (ConnectionEndpoint)Dispatcher.instance.getTarget(this.objectId);
/*    */ 
/* 58 */     if (endpoint == null)
/*    */     {
/* 60 */       throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
/*    */     }
/* 62 */     return new ConnectionGetIDBlockResponse(endpoint.getIdBlock(this.size));
/*    */   }
/*    */ 
/*    */   public void write(DataOutputStream os) throws Exception
/*    */   {
/* 67 */     super.write(os);
/*    */ 
/* 69 */     os.writeInt(this.size);
/*    */ 
/* 71 */     os.flush();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.wireformat.ConnectionGetIDBlockRequest
 * JD-Core Version:    0.6.0
 */