/*     */ package org.jboss.jms.server.selector;
/*     */ 
/*     */ import java.util.Collection;
/*     */ import java.util.HashMap;
/*     */ import java.util.Iterator;
/*     */ import javax.jms.InvalidSelectorException;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Filter;
/*     */ 
/*     */ public class Selector
/*     */   implements Filter
/*     */ {
/*  49 */   static Logger cat = Logger.getLogger(Selector.class);
/*     */ 
/*  52 */   private static Class parserClass = SelectorParser.class;
/*     */ 
/*  54 */   private static final Logger log = Logger.getLogger(Selector.class);
/*     */   public String selector;
/*     */   public HashMap identifiers;
/*     */   public Object result;
/*     */   private Class resultType;
/*     */ 
/*     */   public String getFilterString()
/*     */   {
/*  69 */     return this.selector;
/*     */   }
/*     */ 
/*     */   public static Class getSelectorParserClass()
/*     */   {
/*  78 */     return parserClass;
/*     */   }
/*     */ 
/*     */   public static void setSelectorParserClass(Class parserClass)
/*     */   {
/*  90 */     parserClass = parserClass;
/*     */   }
/*     */ 
/*     */   public Selector(String sel) throws InvalidSelectorException
/*     */   {
/*  95 */     this.selector = sel;
/*  96 */     this.identifiers = new HashMap();
/*     */     try
/*     */     {
/* 100 */       ISelectorParser bob = (ISelectorParser)parserClass.newInstance();
/* 101 */       this.result = bob.parse(sel, this.identifiers);
/* 102 */       this.resultType = this.result.getClass();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 106 */       if (log.isTraceEnabled()) log.trace("Invalid selector:" + sel);
/* 107 */       throw new InvalidSelectorException("The selector is invalid: " + sel);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String getExpression()
/*     */   {
/* 113 */     return this.selector;
/*     */   }
/*     */ 
/*     */   public synchronized boolean accept(org.jboss.messaging.core.contract.Message message)
/*     */   {
/*     */     try
/*     */     {
/* 121 */       if (!(message instanceof javax.jms.Message))
/*     */       {
/* 123 */         return false;
/*     */       }
/*     */ 
/* 126 */       javax.jms.Message mess = (javax.jms.Message)message;
/*     */ 
/* 129 */       Iterator i = this.identifiers.values().iterator();
/*     */ 
/* 131 */       while (i.hasNext())
/*     */       {
/* 133 */         Identifier id = (Identifier)i.next();
/*     */ 
/* 135 */         Object find = mess.getObjectProperty(id.name);
/*     */ 
/* 137 */         if (find == null) {
/* 138 */           find = getHeaderFieldReferences(mess, id.name);
/*     */         }
/* 140 */         if (find == null) {
/* 141 */           id.value = null;
/*     */         }
/*     */         else {
/* 144 */           Class type = find.getClass();
/* 145 */           if ((type.equals(Boolean.class)) || (type.equals(String.class)) || (type.equals(Double.class)) || (type.equals(Float.class)) || (type.equals(Integer.class)) || (type.equals(Long.class)) || (type.equals(Short.class)) || (type.equals(Byte.class)))
/*     */           {
/* 153 */             id.value = find;
/*     */           }
/* 155 */           else throw new Exception("Bad property '" + id.name + "' type: " + type);
/*     */         }
/*     */       }
/*     */       Object res;
/*     */       Object res;
/* 162 */       if (this.resultType.equals(Identifier.class)) {
/* 163 */         res = ((Identifier)this.result).value;
/*     */       }
/*     */       else
/*     */       {
/*     */         Object res;
/* 164 */         if (this.resultType.equals(Operator.class))
/*     */         {
/* 166 */           Operator op = (Operator)this.result;
/* 167 */           res = op.apply();
/*     */         }
/*     */         else {
/* 170 */           res = this.result;
/*     */         }
/*     */       }
/* 172 */       if (res == null) {
/* 173 */         return false;
/*     */       }
/* 175 */       if (!res.getClass().equals(Boolean.class)) {
/* 176 */         throw new Exception("Bad object type: " + res);
/*     */       }
/* 178 */       return ((Boolean)res).booleanValue();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 182 */       cat.warn("Invalid selector: " + this.selector, e);
/* 183 */     }return false;
/*     */   }
/*     */ 
/*     */   private Object getHeaderFieldReferences(javax.jms.Message mess, String idName)
/*     */     throws JMSException
/*     */   {
/* 196 */     if (idName.equals("JMSDeliveryMode"))
/*     */     {
/* 198 */       return mess.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON_PERSISTENT";
/*     */     }
/* 200 */     if (idName.equals("JMSPriority"))
/* 201 */       return new Integer(mess.getJMSPriority());
/* 202 */     if (idName.equals("JMSMessageID"))
/* 203 */       return mess.getJMSMessageID();
/* 204 */     if (idName.equals("JMSTimestamp"))
/* 205 */       return new Long(mess.getJMSTimestamp());
/* 206 */     if (idName.equals("JMSCorrelationID"))
/* 207 */       return mess.getJMSCorrelationID();
/* 208 */     if (idName.equals("JMSType")) {
/* 209 */       return mess.getJMSType();
/*     */     }
/* 211 */     return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.selector.Selector
 * JD-Core Version:    0.6.0
 */