/*     */ package org.jboss.jms.server.selector;
/*     */ 
/*     */ import java.util.regex.Matcher;
/*     */ import java.util.regex.Pattern;
/*     */ 
/*     */ public class RegExp
/*     */ {
/*     */   protected Pattern re;
/*     */ 
/*     */   public RegExp(String pattern, Character escapeChar)
/*     */     throws Exception
/*     */   {
/*  45 */     String pat = adjustPattern(pattern, escapeChar);
/*  46 */     this.re = Pattern.compile(pat);
/*     */   }
/*     */ 
/*     */   public boolean isMatch(Object target)
/*     */   {
/*  51 */     String str = target != null ? target.toString() : "";
/*  52 */     return this.re.matcher(str).matches();
/*     */   }
/*     */ 
/*     */   protected String adjustPattern(String pattern, Character escapeChar)
/*     */     throws Exception
/*     */   {
/*  60 */     int patternLen = pattern.length();
/*  61 */     StringBuffer REpattern = new StringBuffer(patternLen + 10);
/*  62 */     boolean useEscape = escapeChar != null;
/*  63 */     char escape = '\000';
/*  64 */     if (useEscape) {
/*  65 */       escape = escapeChar.charValue();
/*     */     }
/*     */ 
/*  68 */     REpattern.append('^');
/*     */ 
/*  70 */     for (int i = 0; i < patternLen; i++) {
/*  71 */       boolean escaped = false;
/*  72 */       char c = pattern.charAt(i);
/*     */ 
/*  74 */       if ((useEscape) && (escape == c)) {
/*  75 */         i++;
/*  76 */         if (i < patternLen) {
/*  77 */           escaped = true;
/*  78 */           c = pattern.charAt(i);
/*     */         } else {
/*  80 */           throw new Exception("LIKE ESCAPE: Bad use of escape character");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*  86 */       switch (c) {
/*     */       case '_':
/*  88 */         if (escaped)
/*  89 */           REpattern.append(c);
/*     */         else {
/*  91 */           REpattern.append('.');
/*     */         }
/*  93 */         break;
/*     */       case '%':
/*  95 */         if (escaped)
/*  96 */           REpattern.append(c);
/*     */         else {
/*  98 */           REpattern.append(".*");
/*     */         }
/* 100 */         break;
/*     */       case '$':
/*     */       case '(':
/*     */       case ')':
/*     */       case '*':
/*     */       case '+':
/*     */       case '.':
/*     */       case '?':
/*     */       case '[':
/*     */       case '\\':
/*     */       case ']':
/*     */       case '^':
/*     */       case '{':
/*     */       case '|':
/*     */       case '}':
/* 115 */         REpattern.append("\\");
/* 116 */         REpattern.append(c);
/* 117 */         break;
/*     */       default:
/* 119 */         REpattern.append(c);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 124 */     REpattern.append('$');
/* 125 */     return REpattern.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.selector.RegExp
 * JD-Core Version:    0.6.0
 */