/*    */ package org.jboss.jms.server.plugin;
/*    */ 
/*    */ import javax.transaction.TransactionManager;
/*    */ import org.jboss.jms.server.plugin.contract.JMSUserManager;
/*    */ import org.jboss.messaging.core.contract.MessagingComponent;
/*    */ import org.jboss.messaging.core.jmx.JDBCServiceSupport;
/*    */ import org.jboss.messaging.util.ExceptionUtil;
/*    */ 
/*    */ public class JDBCJMSUserManagerService extends JDBCServiceSupport
/*    */ {
/*    */   private JMSUserManager userManager;
/*    */   private boolean started;
/*    */ 
/*    */   public MessagingComponent getInstance()
/*    */   {
/* 58 */     return this.userManager;
/*    */   }
/*    */ 
/*    */   protected synchronized void startService()
/*    */     throws Exception
/*    */   {
/* 65 */     if (this.started)
/*    */     {
/* 67 */       throw new IllegalStateException("Service is already started");
/*    */     }
/*    */ 
/* 70 */     super.startService();
/*    */     try
/*    */     {
/* 74 */       TransactionManager tm = getTransactionManagerReference();
/*    */ 
/* 76 */       this.userManager = new JDBCJMSUserManager(this.ds, tm, this.sqlProperties, this.createTablesOnStartup);
/*    */ 
/* 78 */       this.userManager.start();
/*    */ 
/* 80 */       this.started = true;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 84 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void stopService() throws Exception
/*    */   {
/* 90 */     if (!this.started)
/*    */     {
/* 92 */       throw new IllegalStateException("Service is not started");
/*    */     }
/*    */ 
/* 95 */     super.stopService();
/*    */     try
/*    */     {
/* 99 */       this.userManager.stop();
/*    */ 
/* 101 */       this.started = false;
/*    */     }
/*    */     catch (Throwable t)
/*    */     {
/* 105 */       throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.plugin.JDBCJMSUserManagerService
 * JD-Core Version:    0.6.0
 */