/*     */ package org.jboss.jms.server.plugin;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.LinkedHashMap;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Properties;
/*     */ import java.util.Set;
/*     */ import javax.sql.DataSource;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.jms.server.plugin.contract.JMSUserManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.impl.JDBCSupport;
/*     */ import org.jboss.messaging.core.impl.JDBCSupport.TransactionWrapper;
/*     */ 
/*     */ public class JDBCJMSUserManager extends JDBCSupport
/*     */   implements JMSUserManager
/*     */ {
/*  57 */   private static final Logger log = Logger.getLogger(JDBCJMSUserManager.class);
/*     */ 
/*     */   public JDBCJMSUserManager(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup)
/*     */   {
/*  64 */     super(ds, tm, sqlProperties, createTablesOnStartup);
/*     */   }
/*     */ 
/*     */   protected Map getDefaultDMLStatements()
/*     */   {
/*  71 */     Map map = new LinkedHashMap();
/*  72 */     map.put("SELECT_PRECONF_CLIENTID", "SELECT CLIENTID FROM JBM_USER WHERE USER_ID=?");
/*  73 */     return map;
/*     */   }
/*     */ 
/*     */   protected Map getDefaultDDLStatements()
/*     */   {
/*  78 */     Map map = new LinkedHashMap();
/*  79 */     map.put("CREATE_USER_TABLE", "CREATE TABLE JBM_USER (USER_ID VARCHAR(32) NOT NULL, PASSWD VARCHAR(32) NOT NULL, CLIENTID VARCHAR(128), PRIMARY KEY(USER_ID))");
/*     */ 
/*  82 */     map.put("CREATE_ROLE_TABLE", "CREATE TABLE JBM_ROLE (ROLE_ID VARCHAR(32) NOT NULL, USER_ID VARCHAR(32) NOT NULL, PRIMARY KEY(USER_ID, ROLE_ID))");
/*     */ 
/*  85 */     return map;
/*     */   }
/*     */ 
/*     */   protected boolean ignoreVerificationOnStartup(String statementName)
/*     */   {
/*  91 */     return statementName.startsWith("POPULATE.TABLES.");
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*  98 */     super.start();
/*     */ 
/* 100 */     insertUserRoleData();
/*     */   }
/*     */ 
/*     */   public void stop() throws Exception
/*     */   {
/* 105 */     super.stop();
/*     */   }
/*     */ 
/*     */   public String getPreConfiguredClientID(String username)
/*     */     throws Exception
/*     */   {
/* 112 */     Connection conn = null;
/* 113 */     PreparedStatement ps = null;
/* 114 */     ResultSet rs = null;
/* 115 */     JDBCSupport.TransactionWrapper wrap = new JDBCSupport.TransactionWrapper(this);
/*     */     try
/*     */     {
/* 119 */       conn = this.ds.getConnection();
/*     */ 
/* 121 */       ps = conn.prepareStatement(getSQLStatement("SELECT_PRECONF_CLIENTID"));
/*     */ 
/* 123 */       ps.setString(1, username);
/*     */ 
/* 125 */       rs = ps.executeQuery();
/*     */ 
/* 127 */       String clientID = null;
/*     */ 
/* 129 */       if (rs.next())
/*     */       {
/* 131 */         clientID = rs.getString(1);
/*     */       }
/*     */ 
/* 134 */       String str1 = clientID;
/*     */       return str1;
/*     */     }
/*     */     catch (SQLException e)
/*     */     {
/* 138 */       wrap.exceptionOccurred();
/* 139 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 143 */       closeResultSet(rs);
/* 144 */       closeStatement(ps);
/* 145 */       closeConnection(conn);
/* 146 */       wrap.end();
/* 147 */     }throw localObject;
/*     */   }
/*     */ 
/*     */   private void insertUserRoleData()
/*     */     throws Exception
/*     */   {
/* 154 */     List populateTables = new ArrayList();
/* 155 */     for (Iterator i = this.sqlProperties.entrySet().iterator(); i.hasNext(); )
/*     */     {
/* 157 */       Map.Entry entry = (Map.Entry)i.next();
/* 158 */       String key = (String)entry.getKey();
/* 159 */       if (key.startsWith("POPULATE.TABLES."))
/*     */       {
/* 161 */         populateTables.add(entry.getValue());
/*     */       }
/*     */     }
/*     */ 
/* 165 */     if (!populateTables.isEmpty())
/*     */     {
/* 168 */       Iterator iter = populateTables.iterator();
/*     */ 
/* 170 */       while (iter.hasNext())
/*     */       {
/* 172 */         String statement = (String)iter.next();
/*     */ 
/* 174 */         Statement st = null;
/*     */ 
/* 176 */         Connection conn = null;
/*     */ 
/* 178 */         JDBCSupport.TransactionWrapper tx = null;
/*     */         try
/*     */         {
/* 182 */           if (log.isTraceEnabled()) log.trace("Executing: " + statement);
/*     */ 
/* 184 */           tx = new JDBCSupport.TransactionWrapper(this);
/*     */ 
/* 186 */           conn = this.ds.getConnection();
/*     */ 
/* 188 */           st = conn.createStatement();
/*     */ 
/* 190 */           st.executeUpdate(statement);
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 194 */           log.debug("Failed to execute " + statement, e);
/*     */ 
/* 196 */           tx.exceptionOccurred();
/*     */         }
/*     */         finally
/*     */         {
/* 200 */           closeStatement(st);
/* 201 */           closeConnection(conn);
/* 202 */           tx.end();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.plugin.JDBCJMSUserManager
 * JD-Core Version:    0.6.0
 */