/*     */ package org.jboss.jms.server.messagecounter;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.text.DateFormat;
/*     */ import java.util.Date;
/*     */ 
/*     */ public class MessageStatistics
/*     */   implements Serializable
/*     */ {
/*     */   static final long serialVersionUID = 8056884098781414022L;
/*     */   private boolean topic;
/*     */   private boolean durable;
/*     */   private String name;
/*     */   private String subscriptionID;
/*     */   private int count;
/*     */   private int countDelta;
/*     */   private int depth;
/*     */   private int depthDelta;
/*     */   private long timeLastUpdate;
/*     */ 
/*     */   public int getCount()
/*     */   {
/*  90 */     return this.count;
/*     */   }
/*     */ 
/*     */   public void setCount(int count)
/*     */   {
/* 100 */     this.count = count;
/*     */   }
/*     */ 
/*     */   public int getCountDelta()
/*     */   {
/* 110 */     return this.countDelta;
/*     */   }
/*     */ 
/*     */   public void setCountDelta(int countDelta)
/*     */   {
/* 120 */     this.countDelta = countDelta;
/*     */   }
/*     */ 
/*     */   public int getDepth()
/*     */   {
/* 130 */     return this.depth;
/*     */   }
/*     */ 
/*     */   public void setDepth(int depth)
/*     */   {
/* 140 */     this.depth = depth;
/*     */   }
/*     */ 
/*     */   public int getDepthDelta()
/*     */   {
/* 150 */     return this.depthDelta;
/*     */   }
/*     */ 
/*     */   public void setDepthDelta(int depthDelta)
/*     */   {
/* 160 */     this.depthDelta = depthDelta;
/*     */   }
/*     */ 
/*     */   public boolean isDurable()
/*     */   {
/* 170 */     return this.durable;
/*     */   }
/*     */ 
/*     */   public void setDurable(boolean durable)
/*     */   {
/* 180 */     this.durable = durable;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 190 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 200 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getSubscriptionID()
/*     */   {
/* 210 */     return this.subscriptionID;
/*     */   }
/*     */ 
/*     */   public void setSubscriptionID(String subscriptionID)
/*     */   {
/* 220 */     this.subscriptionID = subscriptionID;
/*     */   }
/*     */ 
/*     */   public long getTimeLastUpdate()
/*     */   {
/* 230 */     return this.timeLastUpdate;
/*     */   }
/*     */ 
/*     */   public void setTimeLastUpdate(long timeLastUpdate)
/*     */   {
/* 240 */     this.timeLastUpdate = timeLastUpdate;
/*     */   }
/*     */ 
/*     */   public boolean isTopic()
/*     */   {
/* 250 */     return this.topic;
/*     */   }
/*     */ 
/*     */   public void setTopic(boolean topic)
/*     */   {
/* 260 */     this.topic = topic;
/*     */   }
/*     */ 
/*     */   public String getAsString()
/*     */   {
/* 273 */     StringBuffer buffer = new StringBuffer(50);
/*     */ 
/* 276 */     if (this.topic)
/* 277 */       buffer.append("Topic,");
/*     */     else {
/* 279 */       buffer.append("Queue,");
/*     */     }
/*     */ 
/* 282 */     buffer.append(this.name).append(',');
/*     */ 
/* 285 */     if (this.subscriptionID != null)
/* 286 */       buffer.append(this.subscriptionID).append(',');
/*     */     else {
/* 288 */       buffer.append("-,");
/*     */     }
/*     */ 
/* 291 */     if (this.topic)
/*     */     {
/* 294 */       if (this.durable)
/* 295 */         buffer.append("DURABLE,");
/*     */       else {
/* 297 */         buffer.append("NONDURABLE,");
/*     */       }
/*     */     }
/*     */     else {
/* 301 */       buffer.append("-,");
/*     */     }
/*     */ 
/* 305 */     buffer.append(this.count).append(',').append(this.countDelta).append(',').append(this.depth).append(',').append(this.depthDelta).append(',');
/*     */ 
/* 309 */     if (this.timeLastUpdate > 0L)
/*     */     {
/* 311 */       DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
/*     */ 
/* 313 */       buffer.append(dateFormat.format(new Date(this.timeLastUpdate)));
/*     */     }
/*     */     else
/*     */     {
/* 317 */       buffer.append('-');
/*     */     }
/*     */ 
/* 320 */     return buffer.toString();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 327 */     return getAsString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.messagecounter.MessageStatistics
 * JD-Core Version:    0.6.0
 */