/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.List;
/*     */ import javax.management.ObjectName;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.messagecounter.MessageStatistics;
/*     */ import org.jboss.managed.api.ManagedOperation.Impact;
/*     */ import org.jboss.managed.api.annotation.ManagementComponent;
/*     */ import org.jboss.managed.api.annotation.ManagementObject;
/*     */ import org.jboss.managed.api.annotation.ManagementOperation;
/*     */ import org.jboss.managed.api.annotation.ManagementProperties;
/*     */ import org.jboss.managed.api.annotation.ManagementProperty;
/*     */ import org.w3c.dom.Element;
/*     */ 
/*     */ @ManagementObject(componentType=@ManagementComponent(type="JMSDestination", subtype="Queue"), properties=ManagementProperties.EXPLICIT)
/*     */ public class QueueServiceMO
/*     */   implements Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 8483702123881698540L;
/*     */ 
/*     */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME}, description="The destination name")
/*     */   public String getName()
/*     */   {
/*  59 */     return null; } 
/*  62 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The destination's JNDI name")
/*     */   public String getJNDIName() { return null; } 
/*     */   public void setJNDIName(String arg0) throws Exception {  }
/*     */ 
/*  66 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The ObjectName of the server peer this destination was deployed on")
/*     */   public ObjectName getServerPeer() { return null; } 
/*     */   public void setServerPeer(ObjectName arg0) {  }
/*     */ 
/*  70 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The DLQ for this queue, overrides the default DLQ on the server peer")
/*     */   public ObjectName getDLQ() { return null; } 
/*     */   public void setDLQ(ObjectName arg0) {  }
/*     */ 
/*  74 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The expiry queue for this queue, overrides the default expiry queue on the server peer")
/*     */   public ObjectName getExpiryQueue() { return null; } 
/*     */   public void setExpiryQueue(ObjectName arg0) {  }
/*     */ 
/*  78 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The delay before redelivering")
/*     */   public long getRedeliveryDelay() { return 0L; } 
/*     */   public void setRedeliveryDelay(long arg0) {  }
/*     */ 
/*  82 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The destination's security configuration")
/*     */   public Element getSecurityConfig() { return null; } 
/*     */   public void setSecurityConfig(Element arg0) {  }
/*     */ 
/*  86 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.RUNTIME}, description="True if this destination was created programmatically")
/*     */   public boolean isCreatedProgrammatically() { return false; } 
/*  89 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="The number of messages in the queue")
/*     */   public int getMessageCount() { return 0; } 
/*  92 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="The number of messages currently being delivered")
/*     */   public int getDeliveringCount() { return 0; } 
/*  95 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="The number of scheduled messages in the queue")
/*     */   public int getScheduledMessageCount() { return 0; } 
/*  98 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The maximum number of messages this queue can hold before they are dropped")
/*     */   public int getMaxSize() { return 0; } 
/*     */   public void setMaxSize(int arg0) {  }
/*     */ 
/* 102 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The in-memory message limit, can only be set when queue is stopped")
/*     */   public int getFullSize() { return 0; } 
/*     */   public void setFullSize(int arg0) {  }
/*     */ 
/* 106 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The paging size, can only be set when queue is stopped")
/*     */   public int getPageSize() { return 0; } 
/*     */   public void setPageSize(int arg0) {  }
/*     */ 
/* 110 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The write-cache size, can only be set when queue is stopped")
/*     */   public int getDownCacheSize() { return 0; } 
/*     */   public void setDownCacheSize(int arg0) {  }
/*     */ 
/* 114 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="Is this a clustered destination?")
/*     */   public boolean isClustered() { return false; } 
/*     */   public void setClustered(boolean arg0) {  }
/*     */ 
/* 118 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="Get the message counter for the queue")
/*     */   public MessageCounter getMessageCounter() { return null; } 
/* 121 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="Get the message statistics for the queue")
/*     */   public MessageStatistics getMessageStatistics() { return null; } 
/* 124 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The day limit for the message counter")
/*     */   public int getMessageCounterHistoryDayLimit() { return 0; } 
/*     */   public void setMessageCounterHistoryDayLimit(int arg0) {  }
/*     */ 
/* 128 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.CONFIGURATION}, description="The maximum delivery attempts to the queue")
/*     */   public int getMaxDeliveryAttempts() { return 0; } 
/*     */   public void setMaxDeliveryAttempts(int arg0) {  }
/*     */ 
/* 132 */   @ManagementProperty(use={org.jboss.managed.api.annotation.ViewUse.STATISTIC}, description="The number of consumers on the queue")
/*     */   public int getConsumerCount() { return 0; } 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void create() throws Exception {
/*     */   }
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void start() throws Exception {
/*     */   }
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void stop() {  }
/*     */ 
/*     */   @ManagementOperation(description="Service lifecycle operation", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void destroy() {  }
/*     */ 
/*     */   @ManagementOperation(description="Remove all messages in the queue", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void removeAllMessages() throws Exception {  }
/*     */ 
/* 152 */   @ManagementOperation(description="List all messages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listAllMessages() throws Exception { return null; } 
/* 155 */   @ManagementOperation(description="List all messages with selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listAllMessages(String selector) throws Exception { return null; } 
/* 158 */   @ManagementOperation(description="List all durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listDurableMessages() throws Exception { return null; } 
/* 161 */   @ManagementOperation(description="List all durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listDurableMessages(String selector) throws Exception { return null; } 
/* 164 */   @ManagementOperation(description="List all non durable mesages", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listNonDurableMessages() throws Exception { return null; } 
/* 167 */   @ManagementOperation(description="List all non durable mesages using a selector", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public List listNonDurableMessages(String selector) throws Exception { return null; } 
/*     */   @ManagementOperation(description="Reset the message counter", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void resetMessageCounter() throws Exception {  }
/*     */ 
/*     */   @ManagementOperation(description="Reset the message counter history", impact=ManagedOperation.Impact.WriteOnly)
/*     */   public void resetMessageCounterHistory() throws Exception {  }
/*     */ 
/* 176 */   @ManagementOperation(description="Get the message counter as HTML", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public String listMessageCounterAsHTML() throws Exception { return null; } 
/* 179 */   @ManagementOperation(description="Get the message counter history as HTML", impact=ManagedOperation.Impact.ReadOnly)
/*     */   public String listMessageCounterHistoryAsHTML() throws Exception { return null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.QueueServiceMO
 * JD-Core Version:    0.6.0
 */