/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collection;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.server.JMSCondition;
/*     */ import org.jboss.jms.server.ServerPeer;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounterManager;
/*     */ import org.jboss.jms.server.selector.Selector;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Binding;
/*     */ import org.jboss.messaging.core.contract.Filter;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.PostOffice;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ import org.jboss.messaging.util.MessageQueueNameHelper;
/*     */ 
/*     */ public class ManagedTopic extends ManagedDestination
/*     */ {
/*  51 */   private static final Logger log = Logger.getLogger(ManagedTopic.class);
/*     */ 
/*     */   public ManagedTopic()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ManagedTopic(String name, int fullSize, int pageSize, int downCacheSize, boolean clustered)
/*     */   {
/*  59 */     super(name, fullSize, pageSize, downCacheSize, clustered);
/*     */   }
/*     */ 
/*     */   public void removeAllMessages() throws Throwable
/*     */   {
/*  64 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/*  67 */     Iterator iter = queues.iterator();
/*  68 */     while (iter.hasNext())
/*     */     {
/*  70 */       Queue queue = (Queue)iter.next();
/*  71 */       queue.removeAllReferences();
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getAllMessageCount() throws Exception
/*     */   {
/*  77 */     return getMessageCount(0);
/*     */   }
/*     */ 
/*     */   public int getDurableMessageCount() throws Exception
/*     */   {
/*  82 */     return getMessageCount(1);
/*     */   }
/*     */ 
/*     */   public int getNonDurableMessageCount() throws Exception
/*     */   {
/*  87 */     return getMessageCount(2);
/*     */   }
/*     */ 
/*     */   public int getAllSubscriptionsCount() throws Exception
/*     */   {
/*  92 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/*  94 */     return queues.size();
/*     */   }
/*     */ 
/*     */   public int getDurableSubscriptionsCount() throws Exception
/*     */   {
/*  99 */     return getSubscriptionsCount(true);
/*     */   }
/*     */ 
/*     */   public int getNonDurableSubscriptionsCount() throws Exception
/*     */   {
/* 104 */     return getSubscriptionsCount(false);
/*     */   }
/*     */ 
/*     */   public List listAllSubscriptions() throws Exception
/*     */   {
/* 109 */     return listSubscriptions(0);
/*     */   }
/*     */ 
/*     */   public List listDurableSubscriptions() throws Exception
/*     */   {
/* 114 */     return listSubscriptions(1);
/*     */   }
/*     */ 
/*     */   public List listNonDurableSubscriptions() throws Exception
/*     */   {
/* 119 */     return listSubscriptions(2);
/*     */   }
/*     */ 
/*     */   public String listAllSubscriptionsAsHTML()
/*     */     throws Exception
/*     */   {
/* 125 */     return listSubscriptionsAsHTML(0);
/*     */   }
/*     */ 
/*     */   public String listDurableSubscriptionsAsHTML() throws Exception
/*     */   {
/* 130 */     return listSubscriptionsAsHTML(1);
/*     */   }
/*     */ 
/*     */   public String listNonDurableSubscriptionsAsHTML() throws Exception
/*     */   {
/* 135 */     return listSubscriptionsAsHTML(2);
/*     */   }
/*     */ 
/*     */   public List listAllMessages(String subId, String selector)
/*     */     throws Exception
/*     */   {
/* 141 */     return listMessages(0, subId, selector);
/*     */   }
/*     */ 
/*     */   public List listDurableMessages(String subId, String selector) throws Exception
/*     */   {
/* 146 */     return listMessages(1, subId, selector);
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages(String subId, String selector) throws Exception
/*     */   {
/* 151 */     return listMessages(2, subId, selector);
/*     */   }
/*     */ 
/*     */   public List getMessageCounters() throws Exception
/*     */   {
/* 156 */     List counters = new ArrayList();
/*     */ 
/* 159 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/* 161 */     Iterator iter = queues.iterator();
/*     */ 
/* 163 */     while (iter.hasNext())
/*     */     {
/* 165 */       Queue queue = (Queue)iter.next();
/*     */ 
/* 167 */       String counterName = "Subscription." + queue.getName();
/*     */ 
/* 169 */       MessageCounter counter = this.serverPeer.getMessageCounterManager().getMessageCounter(counterName);
/*     */ 
/* 171 */       if (counter == null)
/*     */       {
/* 173 */         throw new IllegalStateException("Cannot find counter with name " + counterName);
/*     */       }
/*     */ 
/* 176 */       counters.add(counter);
/*     */     }
/*     */ 
/* 179 */     return counters;
/*     */   }
/*     */ 
/*     */   public boolean isQueue()
/*     */   {
/* 184 */     return false;
/*     */   }
/*     */ 
/*     */   public void setMessageCounterHistoryDayLimit(int limit) throws Exception
/*     */   {
/* 189 */     super.setMessageCounterHistoryDayLimit(limit);
/*     */ 
/* 191 */     List counters = getMessageCounters();
/*     */ 
/* 193 */     Iterator iter = counters.iterator();
/*     */ 
/* 195 */     while (iter.hasNext())
/*     */     {
/* 197 */       MessageCounter counter = (MessageCounter)iter.next();
/*     */ 
/* 199 */       counter.setHistoryLimit(limit);
/*     */     }
/*     */   }
/*     */ 
/*     */   private List listMessages(int type, String subId, String selector)
/*     */     throws Exception
/*     */   {
/* 207 */     List msgs = new ArrayList();
/*     */ 
/* 209 */     if ((subId == null) || ("".equals(subId.trim())))
/*     */     {
/* 211 */       return msgs;
/*     */     }
/*     */ 
/* 214 */     Binding binding = this.serverPeer.getPostOfficeInstance().getBindingForQueueName(subId);
/*     */ 
/* 216 */     if ((binding == null) || (!binding.queue.isActive()))
/*     */     {
/* 218 */       throw new IllegalArgumentException("Cannot find subscription with id " + subId);
/*     */     }
/*     */ 
/* 221 */     Selector sel = null;
/*     */ 
/* 223 */     if ((selector != null) && ("".equals(selector.trim())))
/*     */     {
/* 225 */       selector = null;
/*     */     }
/*     */ 
/* 228 */     if (selector != null)
/*     */     {
/* 230 */       sel = new Selector(selector);
/*     */     }
/*     */ 
/* 233 */     List allMsgs = binding.queue.browse(sel);
/*     */ 
/* 235 */     Iterator iter = allMsgs.iterator();
/*     */ 
/* 237 */     while (iter.hasNext())
/*     */     {
/* 239 */       Message msg = (Message)iter.next();
/*     */ 
/* 241 */       if ((type == 0) || ((type == 1) && (msg.isReliable())) || ((type == 2) && (!msg.isReliable())))
/*     */       {
/* 243 */         msgs.add(msg);
/*     */       }
/*     */     }
/*     */ 
/* 247 */     return msgs;
/*     */   }
/*     */ 
/*     */   private List listSubscriptions(int type) throws Exception
/*     */   {
/* 252 */     List subs = new ArrayList();
/*     */ 
/* 254 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/* 256 */     Iterator iter = queues.iterator();
/*     */ 
/* 258 */     while (iter.hasNext())
/*     */     {
/* 260 */       Queue queue = (Queue)iter.next();
/*     */ 
/* 262 */       if ((type == 0) || ((type == 1) && (queue.isRecoverable())) || ((type == 2) && (!queue.isRecoverable())))
/*     */       {
/* 264 */         String subName = null;
/* 265 */         String clientID = null;
/*     */ 
/* 267 */         if (queue.isRecoverable())
/*     */         {
/* 269 */           MessageQueueNameHelper helper = MessageQueueNameHelper.createHelper(queue.getName());
/* 270 */           subName = helper.getSubName();
/* 271 */           clientID = helper.getClientId();
/*     */         }
/*     */ 
/* 274 */         SubscriptionInfo info = new SubscriptionInfo(queue.getName(), queue.isRecoverable(), subName, clientID, queue.getFilter() == null ? null : queue.getFilter().getFilterString(), queue.getMessageCount(), queue.getMaxSize());
/*     */ 
/* 277 */         subs.add(info);
/*     */       }
/*     */     }
/*     */ 
/* 281 */     return subs;
/*     */   }
/*     */ 
/*     */   private int getMessageCount(int type) throws Exception
/*     */   {
/* 286 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/* 288 */     Iterator iter = queues.iterator();
/*     */ 
/* 290 */     int count = 0;
/*     */ 
/* 292 */     while (iter.hasNext())
/*     */     {
/* 294 */       Queue queue = (Queue)iter.next();
/*     */ 
/* 296 */       if ((type == 0) || ((type == 1) && (queue.isRecoverable())) || ((type == 2) && (!queue.isRecoverable())))
/*     */       {
/* 299 */         count += queue.getMessageCount();
/*     */       }
/*     */     }
/*     */ 
/* 303 */     return count;
/*     */   }
/*     */ 
/*     */   private int getSubscriptionsCount(boolean durable) throws Exception
/*     */   {
/* 308 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/* 310 */     Iterator iter = queues.iterator();
/*     */ 
/* 312 */     int count = 0;
/*     */ 
/* 314 */     while (iter.hasNext())
/*     */     {
/* 316 */       Queue queue = (Queue)iter.next();
/*     */ 
/* 318 */       if (((queue.isRecoverable()) && (durable)) || ((!queue.isRecoverable()) && (!durable)))
/*     */       {
/* 320 */         count++;
/*     */       }
/*     */     }
/*     */ 
/* 324 */     return count;
/*     */   }
/*     */ 
/*     */   private String listSubscriptionsAsHTML(int type)
/*     */     throws Exception
/*     */   {
/* 330 */     Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, this.name), true);
/*     */ 
/* 332 */     StringBuffer sb = new StringBuffer();
/*     */ 
/* 334 */     sb.append("<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Id</th><th>Durable</th><th>Subscription Name</th><th>Client ID</th><th>Selector</th><th>Message Count</th><th>Max Size</th></tr>");
/*     */ 
/* 345 */     Iterator iter = queues.iterator();
/* 346 */     while (iter.hasNext())
/*     */     {
/* 348 */       Queue queue = (Queue)iter.next();
/*     */ 
/* 350 */       if ((type == 0) || ((type == 1) && (queue.isRecoverable())) || ((type == 2) && (!queue.isRecoverable())))
/*     */       {
/* 354 */         String filterString = queue.getFilter() != null ? queue.getFilter().getFilterString() : null;
/*     */ 
/* 356 */         String subName = null;
/* 357 */         String clientID = null;
/*     */ 
/* 359 */         if (queue.isRecoverable())
/*     */         {
/* 361 */           MessageQueueNameHelper helper = MessageQueueNameHelper.createHelper(queue.getName());
/* 362 */           subName = helper.getSubName();
/* 363 */           clientID = helper.getClientId();
/*     */         }
/*     */ 
/* 366 */         sb.append("<tr><td>").append(queue.getName()).append("</td>");
/* 367 */         sb.append("<td>").append(queue.isRecoverable() ? "Durable" : "Non Durable").append("</td>");
/* 368 */         sb.append("<td>").append(subName != null ? subName : "").append("</td>");
/* 369 */         sb.append("<td>").append(clientID != null ? clientID : "").append("</td>");
/* 370 */         sb.append("<td>").append(filterString != null ? filterString : "").append("</td>");
/* 371 */         sb.append("<td>").append(queue.getMessageCount()).append("</td>");
/* 372 */         sb.append("<td>").append(queue.getMaxSize()).append("</td>");
/* 373 */         sb.append("</tr>");
/*     */       }
/*     */     }
/* 376 */     sb.append("</table>");
/*     */ 
/* 378 */     return sb.toString();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.ManagedTopic
 * JD-Core Version:    0.6.0
 */