/*     */ package org.jboss.jms.server.destination;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import org.jboss.jms.server.messagecounter.MessageCounter;
/*     */ import org.jboss.jms.server.selector.Selector;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.Distributor;
/*     */ import org.jboss.messaging.core.contract.Message;
/*     */ import org.jboss.messaging.core.contract.Queue;
/*     */ 
/*     */ public class ManagedQueue extends ManagedDestination
/*     */ {
/*  49 */   private static final Logger log = Logger.getLogger(ManagedQueue.class);
/*     */ 
/*  53 */   private static boolean trace = log.isTraceEnabled();
/*     */   private MessageCounter messageCounter;
/*     */   private Queue queue;
/*     */ 
/*     */   public ManagedQueue()
/*     */   {
/*     */   }
/*     */ 
/*     */   public ManagedQueue(String name, int fullSize, int pageSize, int downCacheSize, boolean clustered)
/*     */   {
/*  69 */     super(name, fullSize, pageSize, downCacheSize, clustered);
/*     */   }
/*     */ 
/*     */   public boolean isQueue()
/*     */   {
/*  76 */     return true;
/*     */   }
/*     */ 
/*     */   public void setMessageCounterHistoryDayLimit(int limit) throws Exception
/*     */   {
/*  81 */     super.setMessageCounterHistoryDayLimit(limit);
/*     */ 
/*  83 */     if (this.messageCounter != null)
/*     */     {
/*  85 */       this.messageCounter.setHistoryLimit(limit);
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getMessageCount()
/*     */     throws Exception
/*     */   {
/*  93 */     int count = this.queue.getMessageCount();
/*     */ 
/*  95 */     if (trace) log.trace(this + " returning MessageCount = " + count);
/*     */ 
/*  97 */     return count;
/*     */   }
/*     */ 
/*     */   public int getDeliveringCount() throws Exception
/*     */   {
/* 102 */     int count = this.queue.getDeliveringCount();
/*     */ 
/* 104 */     if (trace) log.trace(this + " returning DeliveringCount = " + count);
/*     */ 
/* 106 */     return count;
/*     */   }
/*     */ 
/*     */   public int getScheduledMessageCount() throws Exception
/*     */   {
/* 111 */     int count = this.queue.getScheduledCount();
/*     */ 
/* 113 */     if (trace) log.trace(this + " returning ScheduledMessageCount = " + count);
/*     */ 
/* 115 */     return count;
/*     */   }
/*     */ 
/*     */   public int getConsumersCount() throws Exception
/*     */   {
/* 120 */     int count = this.queue.getLocalDistributor().getNumberOfReceivers();
/*     */ 
/* 122 */     if (trace) log.trace(this + " returning ConsumersCount = " + count);
/*     */ 
/* 124 */     return count;
/*     */   }
/*     */ 
/*     */   public void removeAllMessages() throws Throwable
/*     */   {
/* 129 */     this.queue.removeAllReferences();
/*     */   }
/*     */ 
/*     */   public List listAllMessages(String selector) throws Exception
/*     */   {
/* 134 */     return listMessages(0, selector);
/*     */   }
/*     */ 
/*     */   public List listDurableMessages(String selector) throws Exception
/*     */   {
/* 139 */     return listMessages(1, selector);
/*     */   }
/*     */ 
/*     */   public List listNonDurableMessages(String selector) throws Exception
/*     */   {
/* 144 */     return listMessages(2, selector);
/*     */   }
/*     */ 
/*     */   private List listMessages(int type, String selector) throws Exception
/*     */   {
/* 149 */     Selector sel = null;
/*     */ 
/* 151 */     if ((selector != null) && ("".equals(selector.trim())))
/*     */     {
/* 153 */       selector = null;
/*     */     }
/*     */ 
/* 156 */     if (selector != null)
/*     */     {
/* 158 */       sel = new Selector(selector);
/*     */     }
/*     */ 
/* 161 */     List msgs = new ArrayList();
/*     */ 
/* 163 */     List allMsgs = this.queue.browse(sel);
/*     */ 
/* 165 */     Iterator iter = allMsgs.iterator();
/*     */ 
/* 167 */     while (iter.hasNext())
/*     */     {
/* 169 */       Message msg = (Message)iter.next();
/*     */ 
/* 171 */       if ((type == 0) || ((type == 1) && (msg.isReliable())) || ((type == 2) && (!msg.isReliable())))
/*     */       {
/* 173 */         msgs.add(msg);
/*     */       }
/*     */     }
/*     */ 
/* 177 */     return msgs;
/*     */   }
/*     */ 
/*     */   public MessageCounter getMessageCounter()
/*     */   {
/* 182 */     return this.messageCounter;
/*     */   }
/*     */ 
/*     */   public void setMessageCounter(MessageCounter counter)
/*     */   {
/* 187 */     this.messageCounter = counter;
/*     */   }
/*     */ 
/*     */   public void setQueue(Queue queue)
/*     */   {
/* 192 */     this.queue = queue;
/*     */   }
/*     */ 
/*     */   public Queue getQueue()
/*     */   {
/* 197 */     return this.queue;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 202 */     return "ManagedQueue[" + this.name + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.destination.ManagedQueue
 * JD-Core Version:    0.6.0
 */