/*     */ package org.jboss.jms.server.connectionmanager;
/*     */ 
/*     */ import java.util.ArrayList;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.List;
/*     */ import java.util.Map;
/*     */ import java.util.Map.Entry;
/*     */ import java.util.Set;
/*     */ import java.util.concurrent.ConcurrentHashMap;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.jms.delegate.ConnectionEndpoint;
/*     */ import org.jboss.jms.server.ConnectionManager;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.core.contract.ClusterNotification;
/*     */ import org.jboss.messaging.core.contract.ClusterNotificationListener;
/*     */ import org.jboss.messaging.core.contract.Replicator;
/*     */ import org.jboss.messaging.util.ConcurrentHashSet;
/*     */ import org.jboss.messaging.util.Util;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.ClientDisconnectedException;
/*     */ import org.jboss.remoting.ConnectionListener;
/*     */ import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
/*     */ 
/*     */ public class SimpleConnectionManager
/*     */   implements ConnectionManager, ConnectionListener, ClusterNotificationListener
/*     */ {
/*  60 */   private static final Logger log = Logger.getLogger(SimpleConnectionManager.class);
/*     */ 
/*  64 */   private static boolean trace = log.isTraceEnabled();
/*     */   private Map<String, Map<String, ConnectionEndpoint>> jmsClients;
/*     */   private Map<String, String> remotingSessions;
/*     */   private Set<ConnectionEndpoint> activeConnectionEndpoints;
/*     */   private Map<String, ConnectionFactoryCallbackInformation> cfCallbackInfo;
/*     */   private Replicator replicator;
/*     */ 
/*     */   public SimpleConnectionManager()
/*     */   {
/*  84 */     this.jmsClients = new HashMap();
/*  85 */     this.remotingSessions = new HashMap();
/*  86 */     this.activeConnectionEndpoints = new HashSet();
/*  87 */     this.cfCallbackInfo = new ConcurrentHashMap();
/*     */   }
/*     */ 
/*     */   public synchronized void registerConnection(String jmsClientVMID, String remotingClientSessionID, ConnectionEndpoint endpoint)
/*     */   {
/*  98 */     Map endpoints = (Map)this.jmsClients.get(jmsClientVMID);
/*     */ 
/* 100 */     if (endpoints == null)
/*     */     {
/* 102 */       endpoints = new HashMap();
/*     */ 
/* 104 */       this.jmsClients.put(jmsClientVMID, endpoints);
/*     */     }
/*     */ 
/* 107 */     endpoints.put(remotingClientSessionID, endpoint);
/*     */ 
/* 109 */     this.remotingSessions.put(remotingClientSessionID, jmsClientVMID);
/*     */ 
/* 111 */     this.activeConnectionEndpoints.add(endpoint);
/*     */ 
/* 113 */     log.debug("registered connection " + endpoint + " as " + Util.guidToString(remotingClientSessionID));
/*     */   }
/*     */ 
/*     */   public synchronized ConnectionEndpoint unregisterConnection(String jmsClientVMId, String remotingClientSessionID)
/*     */   {
/* 120 */     Map endpoints = (Map)this.jmsClients.get(jmsClientVMId);
/*     */ 
/* 122 */     if (endpoints != null)
/*     */     {
/* 124 */       ConnectionEndpoint e = (ConnectionEndpoint)endpoints.remove(remotingClientSessionID);
/*     */ 
/* 126 */       if (e != null)
/*     */       {
/* 128 */         endpoints.remove(e);
/* 129 */         this.activeConnectionEndpoints.remove(e);
/*     */       }
/*     */ 
/* 132 */       log.debug("unregistered connection " + e + " with remoting session ID " + Util.guidToString(remotingClientSessionID));
/*     */ 
/* 135 */       if (endpoints.isEmpty())
/*     */       {
/* 137 */         this.jmsClients.remove(jmsClientVMId);
/*     */       }
/*     */ 
/* 140 */       this.remotingSessions.remove(remotingClientSessionID);
/*     */ 
/* 142 */       return e;
/*     */     }
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   public synchronized List getActiveConnections()
/*     */   {
/* 150 */     List list = new ArrayList();
/* 151 */     list.addAll(this.activeConnectionEndpoints);
/* 152 */     return list;
/*     */   }
/*     */ 
/*     */   public synchronized void handleClientFailure(String remotingSessionID, boolean clientToServer)
/*     */   {
/* 157 */     String jmsClientID = (String)this.remotingSessions.get(remotingSessionID);
/*     */ 
/* 159 */     if (jmsClientID == null)
/*     */     {
/* 161 */       log.warn(this + " cannot look up remoting session ID " + remotingSessionID);
/*     */     }
/*     */ 
/* 164 */     log.warn("A problem has been detected " + (clientToServer ? "with the connection to remote client " : "trying to send a message to remote client ") + remotingSessionID + ", jmsClientID=" + jmsClientID + ". It is possible the client has exited without closing " + "its connection(s) or the network has failed. All connection resources " + "corresponding to that client process will now be removed.");
/*     */ 
/* 172 */     closeConsumersForClientVMID(jmsClientID);
/*     */   }
/*     */ 
/*     */   public void handleConnectionException(Throwable t, Client client)
/*     */   {
/* 184 */     if ((t instanceof ClientDisconnectedException))
/*     */     {
/* 187 */       if (trace) log.trace(this + " notified that client " + client + " has disconnected");
/* 188 */       return;
/*     */     }
/*     */ 
/* 192 */     if (trace) log.trace(this + " detected failure on client " + client, t);
/*     */ 
/* 195 */     String remotingSessionID = client.getSessionId();
/*     */ 
/* 197 */     if (remotingSessionID != null)
/*     */     {
/* 199 */       handleClientFailure(remotingSessionID, true);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void addConnectionFactoryCallback(String uniqueName, String JVMID, String remotingSessionID, ServerInvokerCallbackHandler handler)
/*     */   {
/* 206 */     this.remotingSessions.put(remotingSessionID, JVMID);
/* 207 */     getCFInfo(uniqueName).addClient(JVMID, handler);
/*     */   }
/*     */ 
/*     */   public synchronized void removeConnectionFactoryCallback(String uniqueName, String JVMID, ServerInvokerCallbackHandler handler)
/*     */   {
/* 213 */     getCFInfo(uniqueName).removeHandler(JVMID, handler);
/*     */   }
/*     */ 
/*     */   public synchronized ServerInvokerCallbackHandler[] getConnectionFactoryCallback(String uniqueName)
/*     */   {
/* 219 */     return getCFInfo(uniqueName).getAllHandlers();
/*     */   }
/*     */ 
/*     */   public void notify(ClusterNotification notification)
/*     */   {
/* 231 */     if (notification.type == 5)
/*     */     {
/* 234 */       log.trace("SimpleConnectionManager was notified about node leaving from node " + notification.nodeID);
/*     */       try
/*     */       {
/* 246 */         Map ids = this.replicator.get("JVMID");
/*     */ 
/* 248 */         if (ids == null)
/*     */         {
/* 250 */           log.trace("Cannot find jvmid map");
/* 251 */           throw new IllegalStateException("Cannot find jvmid map");
/*     */         }
/*     */ 
/* 254 */         int failedNodeID = notification.nodeID;
/*     */ 
/* 256 */         String clientVMID = (String)ids.get(new Integer(failedNodeID));
/*     */ 
/* 258 */         if (clientVMID == null)
/*     */         {
/* 260 */           log.error("Cannot find ClientVMID for failed node " + failedNodeID);
/* 261 */           throw new IllegalStateException("Cannot find clientVMID for failed node " + failedNodeID);
/*     */         }
/*     */ 
/* 266 */         log.trace("Closing consumers for clientVMID=" + clientVMID);
/*     */ 
/* 268 */         closeConsumersForClientVMID(clientVMID);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 272 */         log.error("Failed to process failover start", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */     throws Exception
/*     */   {
/*     */   }
/*     */ 
/*     */   public synchronized boolean containsRemotingSession(String remotingClientSessionID)
/*     */   {
/* 296 */     return this.remotingSessions.containsKey(remotingClientSessionID);
/*     */   }
/*     */ 
/*     */   public synchronized Map getClients()
/*     */   {
/* 304 */     return Collections.unmodifiableMap(this.jmsClients);
/*     */   }
/*     */ 
/*     */   public void injectReplicator(Replicator replicator)
/*     */   {
/* 309 */     this.replicator = replicator;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 315 */     return "ConnectionManager[" + Integer.toHexString(hashCode()) + "]";
/*     */   }
/*     */ 
/*     */   private ConnectionFactoryCallbackInformation getCFInfo(String uniqueName)
/*     */   {
/* 326 */     ConnectionFactoryCallbackInformation callback = (ConnectionFactoryCallbackInformation)this.cfCallbackInfo.get(uniqueName);
/* 327 */     if (callback == null)
/*     */     {
/* 329 */       callback = new ConnectionFactoryCallbackInformation(uniqueName);
/* 330 */       this.cfCallbackInfo.put(uniqueName, callback);
/* 331 */       callback = (ConnectionFactoryCallbackInformation)this.cfCallbackInfo.get(uniqueName);
/*     */     }
/* 333 */     return callback;
/*     */   }
/*     */ 
/*     */   private synchronized void closeConsumersForClientVMID(String jmsClientID)
/*     */   {
/* 339 */     if (jmsClientID == null)
/*     */     {
/* 341 */       return;
/*     */     }
/*     */ 
/* 346 */     Map endpoints = (Map)this.jmsClients.get(jmsClientID);
/*     */ 
/* 348 */     if (endpoints != null)
/*     */     {
/* 350 */       List sces = new ArrayList();
/*     */ 
/* 352 */       for (Map.Entry entry : endpoints.entrySet())
/*     */       {
/* 354 */         ConnectionEndpoint sce = (ConnectionEndpoint)entry.getValue();
/* 355 */         sces.add(sce);
/*     */       }
/*     */ 
/* 362 */       for (ConnectionEndpoint sce : sces)
/*     */       {
/*     */         try
/*     */         {
/* 366 */           log.debug("clPearing up state for connection " + sce);
/* 367 */           sce.closing(-1L);
/* 368 */           sce.close();
/* 369 */           log.debug("cleared up state for connection " + sce);
/*     */         }
/*     */         catch (JMSException e)
/*     */         {
/* 373 */           log.error("Failed to close connection", e);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 378 */     for (ConnectionFactoryCallbackInformation cfInfo : this.cfCallbackInfo.values())
/*     */     {
/* 380 */       ServerInvokerCallbackHandler[] handlers = cfInfo.getAllHandlers(jmsClientID);
/* 381 */       for (ServerInvokerCallbackHandler handler : handlers)
/*     */       {
/*     */         try
/*     */         {
/* 385 */           handler.getCallbackClient().disconnect();
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 389 */           log.warn(e, e);
/*     */         }
/*     */ 
/*     */         try
/*     */         {
/* 394 */           handler.destroy();
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/* 398 */           log.warn(e, e);
/*     */         }
/*     */ 
/* 401 */         cfInfo.removeHandler(jmsClientID, handler);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private void dump()
/*     */   {
/* 469 */     log.debug("***********Dumping conn map");
/* 470 */     for (Iterator iter = this.jmsClients.entrySet().iterator(); iter.hasNext(); )
/*     */     {
/* 472 */       Map.Entry entry = (Map.Entry)iter.next();
/*     */ 
/* 474 */       String jmsClientVMID = (String)entry.getKey();
/*     */ 
/* 476 */       Map endpoints = (Map)entry.getValue();
/*     */ 
/* 478 */       log.debug(jmsClientVMID + "----->");
/*     */ 
/* 480 */       for (iter2 = endpoints.entrySet().iterator(); iter2.hasNext(); )
/*     */       {
/* 482 */         Map.Entry entry2 = (Map.Entry)iter2.next();
/*     */ 
/* 484 */         String sessionID = (String)entry2.getKey();
/*     */ 
/* 486 */         ConnectionEndpoint endpoint = (ConnectionEndpoint)entry2.getValue();
/*     */ 
/* 488 */         log.debug("            " + sessionID + "------>" + System.identityHashCode(endpoint));
/*     */       }
/*     */     }
/*     */     Iterator iter2;
/* 491 */     log.debug("*** Dumped conn map");
/*     */   }
/*     */ 
/*     */   static class ConnectionFactoryCallbackInformation
/*     */   {
/*     */     String uniqueName;
/*     */     Map<String, ConcurrentHashSet<ServerInvokerCallbackHandler>> clientHandlersByVM;
/*     */     ConcurrentHashSet<ServerInvokerCallbackHandler> clientHandlers;
/*     */ 
/*     */     public ConnectionFactoryCallbackInformation(String uniqueName)
/*     */     {
/* 423 */       this.uniqueName = uniqueName;
/* 424 */       this.clientHandlersByVM = new ConcurrentHashMap();
/* 425 */       this.clientHandlers = new ConcurrentHashSet();
/*     */     }
/*     */ 
/*     */     public void addClient(String vmID, ServerInvokerCallbackHandler handler)
/*     */     {
/* 430 */       this.clientHandlers.add(handler);
/* 431 */       getHandlersList(vmID).add(handler);
/*     */     }
/*     */ 
/*     */     public ServerInvokerCallbackHandler[] getAllHandlers(String vmID)
/*     */     {
/* 436 */       Set list = getHandlersList(vmID);
/* 437 */       ServerInvokerCallbackHandler[] array = new ServerInvokerCallbackHandler[list.size()];
/* 438 */       return (ServerInvokerCallbackHandler[])(ServerInvokerCallbackHandler[])list.toArray(array);
/*     */     }
/*     */ 
/*     */     public ServerInvokerCallbackHandler[] getAllHandlers()
/*     */     {
/* 443 */       ServerInvokerCallbackHandler[] array = new ServerInvokerCallbackHandler[this.clientHandlers.size()];
/* 444 */       return (ServerInvokerCallbackHandler[])(ServerInvokerCallbackHandler[])this.clientHandlers.toArray(array);
/*     */     }
/*     */ 
/*     */     public void removeHandler(String vmID, ServerInvokerCallbackHandler handler)
/*     */     {
/* 449 */       this.clientHandlers.remove(handler);
/* 450 */       getHandlersList(vmID).remove(handler);
/*     */     }
/*     */ 
/*     */     private ConcurrentHashSet<ServerInvokerCallbackHandler> getHandlersList(String vmID)
/*     */     {
/* 455 */       ConcurrentHashSet perVMList = (ConcurrentHashSet)this.clientHandlersByVM.get(vmID);
/* 456 */       if (perVMList == null)
/*     */       {
/* 458 */         perVMList = new ConcurrentHashSet();
/* 459 */         this.clientHandlersByVM.put(vmID, perVMList);
/* 460 */         perVMList = (ConcurrentHashSet)this.clientHandlersByVM.get(vmID);
/*     */       }
/* 462 */       return perVMList;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.server.connectionmanager.SimpleConnectionManager
 * JD-Core Version:    0.6.0
 */