/*    */ package org.jboss.jms.referenceable;
/*    */ 
/*    */ import java.io.ByteArrayInputStream;
/*    */ import java.io.ByteArrayOutputStream;
/*    */ import java.io.IOException;
/*    */ import java.io.ObjectInputStream;
/*    */ import java.io.ObjectOutputStream;
/*    */ import javax.naming.NamingException;
/*    */ import javax.naming.RefAddr;
/*    */ 
/*    */ public class SerializableObjectRefAddr extends RefAddr
/*    */ {
/*    */   private static final long serialVersionUID = 9158134548376171898L;
/*    */   private byte[] bytes;
/*    */ 
/*    */   public SerializableObjectRefAddr(String type, Object content)
/*    */     throws NamingException
/*    */   {
/* 54 */     super(type);
/*    */     try
/*    */     {
/* 59 */       ByteArrayOutputStream bos = new ByteArrayOutputStream();
/*    */ 
/* 61 */       ObjectOutputStream oos = new ObjectOutputStream(bos);
/*    */ 
/* 63 */       oos.writeObject(content);
/*    */ 
/* 65 */       oos.flush();
/*    */ 
/* 67 */       this.bytes = bos.toByteArray();
/*    */     }
/*    */     catch (IOException e)
/*    */     {
/* 71 */       throw new NamingException("Failed to serialize object:" + content + ", " + e.getMessage());
/*    */     }
/*    */   }
/*    */ 
/*    */   public Object getContent()
/*    */   {
/* 77 */     return this.bytes;
/*    */   }
/*    */ 
/*    */   public static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException
/*    */   {
/* 82 */     ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
/*    */ 
/* 84 */     ObjectInputStream ois = new ObjectInputStream(bis);
/*    */ 
/* 86 */     return ois.readObject();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.referenceable.SerializableObjectRefAddr
 * JD-Core Version:    0.6.0
 */