/*    */ package org.jboss.jms.message;
/*    */ 
/*    */ import javax.jms.JMSException;
/*    */ import javax.jms.MessageNotWriteableException;
/*    */ import javax.jms.TextMessage;
/*    */ 
/*    */ public class TextMessageProxy extends MessageProxy
/*    */   implements TextMessage
/*    */ {
/*    */   private static final long serialVersionUID = -3530143417050205123L;
/*    */ 
/*    */   public TextMessageProxy(long deliveryId, JBossTextMessage message, int deliveryCount)
/*    */   {
/* 41 */     super(deliveryId, message, deliveryCount);
/*    */   }
/*    */ 
/*    */   public TextMessageProxy(JBossTextMessage message)
/*    */   {
/* 46 */     super(message);
/*    */   }
/*    */ 
/*    */   public void setText(String string) throws JMSException
/*    */   {
/* 51 */     if (this.bodyReadOnly)
/* 52 */       throw new MessageNotWriteableException("Cannot set the content; message is read-only");
/* 53 */     bodyChange();
/* 54 */     ((TextMessage)this.message).setText(string);
/*    */   }
/*    */ 
/*    */   public String getText() throws JMSException
/*    */   {
/* 59 */     return ((TextMessage)this.message).getText();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.TextMessageProxy
 * JD-Core Version:    0.6.0
 */