/*     */ package org.jboss.jms.message;
/*     */ 
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import javax.jms.JMSException;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class MessageIdGeneratorFactory
/*     */ {
/*  44 */   private static final Logger log = Logger.getLogger(MessageIdGeneratorFactory.class);
/*     */ 
/*  46 */   public static MessageIdGeneratorFactory instance = new MessageIdGeneratorFactory();
/*     */   private static final int BLOCK_SIZE = 512;
/*     */   private Map holders;
/*     */ 
/*     */   private MessageIdGeneratorFactory()
/*     */   {
/*  61 */     this.holders = new HashMap();
/*     */   }
/*     */ 
/*     */   public synchronized boolean containsMessageIdGenerator(int serverId)
/*     */   {
/*  68 */     return this.holders.containsKey(new Integer(serverId));
/*     */   }
/*     */ 
/*     */   public synchronized MessageIdGenerator checkOutGenerator(int serverId)
/*     */     throws JMSException
/*     */   {
/*  74 */     Integer in = new Integer(serverId);
/*     */ 
/*  76 */     Holder h = (Holder)this.holders.get(in);
/*     */ 
/*  78 */     if (h == null)
/*     */     {
/*  80 */       h = new Holder(new MessageIdGenerator(512), null);
/*  81 */       this.holders.put(in, h);
/*     */     }
/*     */     else
/*     */     {
/*  85 */       h.refCount += 1;
/*     */     }
/*     */ 
/*  88 */     log.trace("checked out MessageIdGenerator for " + serverId + ", reference count is " + h.refCount);
/*     */ 
/*  91 */     return h.generator;
/*     */   }
/*     */ 
/*     */   public synchronized void checkInGenerator(int serverId)
/*     */   {
/*  96 */     Integer in = new Integer(serverId);
/*     */ 
/*  98 */     Holder h = (Holder)this.holders.get(in);
/*     */ 
/* 100 */     if (h == null)
/*     */     {
/* 102 */       throw new IllegalArgumentException("Cannot find generator for serverid:" + serverId);
/*     */     }
/*     */ 
/* 105 */     h.refCount -= 1;
/*     */ 
/* 107 */     if (h.refCount == 0)
/*     */     {
/* 109 */       this.holders.remove(in);
/* 110 */       log.trace("checked in and removed MessageIdGenerator for " + serverId);
/*     */     }
/*     */     else
/*     */     {
/* 114 */       log.trace("checked in MessageIdGenerator for " + serverId + ", reference count is " + h.refCount);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void clear()
/*     */   {
/* 121 */     this.holders.clear();
/* 122 */     log.trace("cleared MessageIdGeneratorFactory");
/*     */   }
/*     */ 
/*     */   private class Holder
/*     */   {
/*     */     MessageIdGenerator generator;
/* 142 */     int refCount = 1;
/*     */ 
/*     */     private Holder(MessageIdGenerator gen)
/*     */     {
/* 137 */       this.generator = gen;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.message.MessageIdGeneratorFactory
 * JD-Core Version:    0.6.0
 */