/*     */ package org.jboss.jms.jndi;
/*     */ 
/*     */ import java.util.Properties;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.naming.NameParser;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.deployment.DeploymentException;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ 
/*     */ public class JMSProviderLoader extends ServiceMBeanSupport
/*     */   implements JMSProviderLoaderMBean
/*     */ {
/*     */   protected JMSProviderAdapter providerAdapter;
/*     */   protected Properties properties;
/*     */   protected String providerName;
/*     */   protected String providerAdapterClass;
/*     */   protected String factoryRef;
/*     */   protected String queueFactoryRef;
/*     */   protected String topicFactoryRef;
/*     */   protected String jndiName;
/*     */ 
/*     */   public void setProviderName(String name)
/*     */   {
/*  71 */     this.providerName = name;
/*     */   }
/*     */ 
/*     */   public String getProviderName()
/*     */   {
/*  76 */     return this.providerName;
/*     */   }
/*     */ 
/*     */   public void setProviderAdapterClass(String clazz)
/*     */   {
/*  81 */     this.providerAdapterClass = clazz;
/*     */   }
/*     */ 
/*     */   public String getProviderAdapterClass()
/*     */   {
/*  86 */     return this.providerAdapterClass;
/*     */   }
/*     */ 
/*     */   public void setProperties(Properties properties)
/*     */   {
/*  91 */     this.properties = properties;
/*     */   }
/*     */ 
/*     */   public Properties getProperties()
/*     */   {
/*  96 */     return this.properties;
/*     */   }
/*     */ 
/*     */   public void setAdapterJNDIName(String name)
/*     */   {
/* 101 */     this.jndiName = name;
/*     */   }
/*     */ 
/*     */   public String getAdapterJNDIName()
/*     */   {
/* 106 */     return this.jndiName;
/*     */   }
/*     */ 
/*     */   public void setFactoryRef(String newFactoryRef)
/*     */   {
/* 111 */     this.factoryRef = newFactoryRef;
/*     */   }
/*     */ 
/*     */   public void setQueueFactoryRef(String newQueueFactoryRef)
/*     */   {
/* 116 */     this.queueFactoryRef = newQueueFactoryRef;
/*     */   }
/*     */ 
/*     */   public void setTopicFactoryRef(String newTopicFactoryRef)
/*     */   {
/* 121 */     this.topicFactoryRef = newTopicFactoryRef;
/*     */   }
/*     */ 
/*     */   public String getFactoryRef()
/*     */   {
/* 126 */     return this.factoryRef;
/*     */   }
/*     */ 
/*     */   public String getQueueFactoryRef()
/*     */   {
/* 131 */     return this.queueFactoryRef;
/*     */   }
/*     */ 
/*     */   public String getTopicFactoryRef()
/*     */   {
/* 136 */     return this.topicFactoryRef;
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 141 */     return this.providerName;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 147 */     if (this.queueFactoryRef == null) {
/* 148 */       throw new DeploymentException("missing required attribute: QueueFactoryRef");
/*     */     }
/* 150 */     if (this.topicFactoryRef == null) {
/* 151 */       throw new DeploymentException("missing required attribute: TopicFactoryRef");
/*     */     }
/* 153 */     Class cls = Thread.currentThread().getContextClassLoader().loadClass(this.providerAdapterClass);
/* 154 */     this.providerAdapter = ((JMSProviderAdapter)cls.newInstance());
/* 155 */     this.providerAdapter.setName(this.providerName);
/* 156 */     this.providerAdapter.setProperties(this.properties);
/* 157 */     this.providerAdapter.setFactoryRef(this.factoryRef);
/* 158 */     this.providerAdapter.setQueueFactoryRef(this.queueFactoryRef);
/* 159 */     this.providerAdapter.setTopicFactoryRef(this.topicFactoryRef);
/*     */ 
/* 161 */     InitialContext context = new InitialContext();
/*     */     try
/*     */     {
/* 165 */       if (this.jndiName == null)
/*     */       {
/* 167 */         String name = this.providerAdapter.getName();
/* 168 */         this.jndiName = ("java:/" + name);
/*     */       }
/* 170 */       bind(context, this.jndiName, this.providerAdapter);
/* 171 */       this.log.debug("Bound adapter to " + this.jndiName);
/*     */     }
/*     */     finally
/*     */     {
/* 175 */       context.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void stopService() throws Exception
/*     */   {
/* 181 */     InitialContext context = new InitialContext();
/*     */     try
/*     */     {
/* 186 */       String name = this.providerAdapter.getName();
/* 187 */       String jndiname = "java:/" + name;
/* 188 */       context.unbind(jndiname);
/* 189 */       this.log.debug("unbound adapter " + name + " from " + jndiname);
/*     */     }
/*     */     finally
/*     */     {
/* 193 */       context.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   private void bind(Context ctx, String name, Object val) throws NamingException
/*     */   {
/* 199 */     this.log.debug("attempting to bind " + val + " to " + name);
/*     */ 
/* 203 */     Name n = ctx.getNameParser("").parse(name);
/* 204 */     while (n.size() > 1)
/*     */     {
/* 206 */       String ctxName = n.get(0);
/*     */       try
/*     */       {
/* 209 */         ctx = (Context)ctx.lookup(ctxName);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 213 */         ctx = ctx.createSubcontext(ctxName);
/*     */       }
/* 215 */       n = n.getSuffix(1);
/*     */     }
/*     */ 
/* 218 */     ctx.bind(n.get(0), val);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.jndi.JMSProviderLoader
 * JD-Core Version:    0.6.0
 */