package org.jboss.jms.delegate;

import java.util.List;
import javax.jms.JMSException;
import org.jboss.jms.client.Closeable;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.destination.JBossQueue;
import org.jboss.jms.destination.JBossTopic;
import org.jboss.jms.message.JBossMessage;

public abstract interface SessionEndpoint extends Closeable
{
  public abstract ConsumerDelegate createConsumerDelegate(JBossDestination paramJBossDestination, String paramString1, boolean paramBoolean1, String paramString2, boolean paramBoolean2, boolean paramBoolean3)
    throws JMSException;

  public abstract BrowserDelegate createBrowserDelegate(JBossDestination paramJBossDestination, String paramString)
    throws JMSException;

  public abstract JBossQueue createQueue(String paramString)
    throws JMSException;

  public abstract JBossTopic createTopic(String paramString)
    throws JMSException;

  public abstract void acknowledgeDeliveries(List paramList)
    throws JMSException;

  public abstract boolean acknowledgeDelivery(Ack paramAck)
    throws JMSException;

  public abstract void cancelDeliveries(List paramList)
    throws JMSException;

  public abstract void cancelDelivery(Cancel paramCancel)
    throws JMSException;

  public abstract void addTemporaryDestination(JBossDestination paramJBossDestination)
    throws JMSException;

  public abstract void deleteTemporaryDestination(JBossDestination paramJBossDestination)
    throws JMSException;

  public abstract void unsubscribe(String paramString)
    throws JMSException;

  public abstract void send(JBossMessage paramJBossMessage, boolean paramBoolean)
    throws JMSException;

  public abstract void recoverDeliveries(List paramList, String paramString)
    throws JMSException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.delegate.SessionEndpoint
 * JD-Core Version:    0.6.0
 */