package org.jboss.jms.delegate;

import java.io.Serializable;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.transaction.xa.XAResource;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.BytesMessageProxy;
import org.jboss.jms.message.MapMessageProxy;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.message.ObjectMessageProxy;
import org.jboss.jms.message.StreamMessageProxy;
import org.jboss.jms.message.TextMessageProxy;

public abstract interface SessionDelegate extends SessionEndpoint
{
  public abstract MessageProxy createMessage()
    throws JMSException;

  public abstract BytesMessageProxy createBytesMessage()
    throws JMSException;

  public abstract MapMessageProxy createMapMessage()
    throws JMSException;

  public abstract ObjectMessageProxy createObjectMessage()
    throws JMSException;

  public abstract ObjectMessageProxy createObjectMessage(Serializable paramSerializable)
    throws JMSException;

  public abstract StreamMessageProxy createStreamMessage()
    throws JMSException;

  public abstract TextMessageProxy createTextMessage()
    throws JMSException;

  public abstract TextMessageProxy createTextMessage(String paramString)
    throws JMSException;

  public abstract void preDeliver(DeliveryInfo paramDeliveryInfo)
    throws JMSException;

  public abstract boolean postDeliver()
    throws JMSException;

  public abstract MessageListener getMessageListener()
    throws JMSException;

  public abstract void setMessageListener(MessageListener paramMessageListener)
    throws JMSException;

  public abstract void run();

  public abstract XAResource getXAResource();

  public abstract void addAsfMessage(MessageProxy paramMessageProxy, String paramString1, String paramString2, int paramInt, SessionDelegate paramSessionDelegate, boolean paramBoolean);

  public abstract boolean getTransacted();

  public abstract int getAcknowledgeMode();

  public abstract void commit()
    throws JMSException;

  public abstract void rollback()
    throws JMSException;

  public abstract void recover()
    throws JMSException;

  public abstract void redeliver(List paramList)
    throws JMSException;

  public abstract ProducerDelegate createProducerDelegate(JBossDestination paramJBossDestination)
    throws JMSException;

  public abstract void acknowledgeAll()
    throws JMSException;
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.delegate.SessionDelegate
 * JD-Core Version:    0.6.0
 */