/*     */ package org.jboss.jms.delegate;
/*     */ 
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import org.jboss.messaging.util.Streamable;
/*     */ 
/*     */ public class DeliveryRecovery
/*     */   implements Streamable
/*     */ {
/*     */   private long deliveryID;
/*     */   private long messageID;
/*     */   private String queueName;
/*     */ 
/*     */   public DeliveryRecovery()
/*     */   {
/*     */   }
/*     */ 
/*     */   public DeliveryRecovery(long deliveryID, long messageID, String queueName)
/*     */   {
/*  61 */     this.deliveryID = deliveryID;
/*  62 */     this.messageID = messageID;
/*  63 */     this.queueName = queueName;
/*     */   }
/*     */ 
/*     */   public void read(DataInputStream in)
/*     */     throws Exception
/*     */   {
/*  70 */     this.deliveryID = in.readLong();
/*  71 */     this.messageID = in.readLong();
/*  72 */     this.queueName = in.readUTF();
/*     */   }
/*     */ 
/*     */   public void write(DataOutputStream out) throws Exception
/*     */   {
/*  77 */     out.writeLong(this.deliveryID);
/*  78 */     out.writeLong(this.messageID);
/*  79 */     out.writeUTF(this.queueName);
/*     */   }
/*     */ 
/*     */   public long getDeliveryID()
/*     */   {
/*  86 */     return this.deliveryID;
/*     */   }
/*     */ 
/*     */   public long getMessageID()
/*     */   {
/*  91 */     return this.messageID;
/*     */   }
/*     */ 
/*     */   public String getQueueName()
/*     */   {
/*  96 */     return this.queueName;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 101 */     return "DeliveryRecovery[ID=" + this.deliveryID + ", MID=" + this.messageID + ", Queue name=" + this.queueName + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.delegate.DeliveryRecovery
 * JD-Core Version:    0.6.0
 */