/*     */ package org.jboss.jms.client.remoting;
/*     */ 
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedExceptionAction;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import org.jboss.jms.wireformat.JMSWireFormat;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.messaging.util.GUIDGenerator;
/*     */ import org.jboss.remoting.Client;
/*     */ import org.jboss.remoting.ConnectionListener;
/*     */ import org.jboss.remoting.InvokerLocator;
/*     */ import org.jboss.remoting.callback.InvokerCallbackHandler;
/*     */ import org.jboss.util.id.GUID;
/*     */ 
/*     */ public class JMSRemotingConnection
/*     */ {
/*     */   public static final String CALLBACK_POLL_PERIOD_DEFAULT = "100";
/*  62 */   private static final Logger log = Logger.getLogger(JMSRemotingConnection.class);
/*     */   private Client client;
/*     */   private boolean clientPing;
/*     */   private InvokerLocator serverLocator;
/*     */   private CallbackManager callbackManager;
/*     */   private boolean strictTck;
/* 255 */   protected boolean failed = false;
/*     */   private ConsolidatedRemotingConnectionListener remotingConnectionListener;
/*     */ 
/*     */   private static String getPropertySafely(String propName)
/*     */   {
/*  68 */     String prop = null;
/*     */     try
/*     */     {
/*  72 */       prop = System.getProperty(propName);
/*     */     }
/*     */     catch (Exception ignore)
/*     */     {
/*     */     }
/*     */ 
/*  80 */     return prop;
/*     */   }
/*     */ 
/*     */   public static Map createCallbackMetadata(boolean doPushCallbacks, Map metadata, InvokerLocator serverLocator)
/*     */   {
/*  97 */     if (metadata == null)
/*     */     {
/*  99 */       metadata = new HashMap();
/*     */     }
/*     */ 
/* 105 */     metadata.put("onewayThreadPool", "org.jboss.jms.server.remoting.DirectThreadPool");
/*     */ 
/* 108 */     if (doPushCallbacks)
/*     */     {
/* 110 */       metadata.put("clientSocketClass", "org.jboss.jms.client.remoting.ClientSocketWrapper");
/*     */ 
/* 112 */       metadata.put("serverSocketClass", "org.jboss.jms.server.remoting.ServerSocketWrapper");
/*     */ 
/* 115 */       String bindAddress = getPropertySafely("jboss.messaging.callback.bind.address");
/*     */ 
/* 117 */       if (bindAddress != null)
/*     */       {
/* 119 */         metadata.put("callbackServerHost", bindAddress);
/*     */       }
/*     */ 
/* 122 */       String propertyPort = getPropertySafely("jboss.messaging.callback.bind.port");
/*     */ 
/* 124 */       if (propertyPort != null)
/*     */       {
/* 126 */         metadata.put("callbackServerPort", propertyPort);
/*     */       }
/*     */ 
/* 129 */       Map params = serverLocator.getParameters();
/* 130 */       int maxPoolSize = 50;
/* 131 */       if (params != null)
/*     */       {
/* 133 */         String val = (String)params.get("clientMaxPoolSize");
/* 134 */         maxPoolSize = Integer.valueOf(val).intValue();
/*     */       }
/*     */ 
/* 138 */       metadata.put("clientMaxPoolSize", String.valueOf(maxPoolSize));
/*     */ 
/* 140 */       String protocol = serverLocator.getProtocol();
/* 141 */       if (("bisocket".equals(protocol)) || ("sslbisocket".equals(protocol)))
/*     */       {
/* 143 */         metadata.put("isCallbackServer", "true");
/*     */ 
/* 148 */         if (propertyPort == null)
/*     */         {
/* 150 */           String guid = new GUID().toString();
/* 151 */           int hash = guid.hashCode();
/*     */ 
/* 155 */           while (hash <= 0)
/*     */           {
/* 157 */             if (hash == 0)
/*     */             {
/* 159 */               guid = GUIDGenerator.generateGUID();
/* 160 */               hash = guid.hashCode();
/*     */             }
/* 162 */             if (hash >= 0)
/*     */               continue;
/* 164 */             if (hash == -2147483648)
/*     */             {
/* 166 */               hash = 2147483647;
/* 167 */               continue;
/*     */             }
/*     */ 
/* 170 */             hash = -hash;
/*     */           }
/*     */ 
/* 175 */           metadata.put("callbackServerPort", Integer.toString(hash));
/* 176 */           metadata.put("guid", guid);
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/* 184 */       String callbackPollPeriod = getPropertySafely("jboss.messaging.callback.pollPeriod");
/*     */ 
/* 186 */       if (callbackPollPeriod == null)
/*     */       {
/* 189 */         callbackPollPeriod = (String)serverLocator.getParameters().get("callbackPollPeriod");
/* 190 */         if (callbackPollPeriod == null)
/*     */         {
/* 193 */           callbackPollPeriod = "100";
/*     */         }
/*     */       }
/*     */ 
/* 197 */       metadata.put("callbackPollPeriod", callbackPollPeriod);
/*     */ 
/* 199 */       String reportPollingStatistics = getPropertySafely("jboss.messaging.callback.reportPollingStatistics");
/*     */ 
/* 202 */       if (reportPollingStatistics != null)
/*     */       {
/* 204 */         metadata.put("reportStatistics", reportPollingStatistics);
/*     */       }
/*     */     }
/*     */ 
/* 208 */     return metadata;
/*     */   }
/*     */ 
/*     */   public static void addInvokerCallbackHandler(Object configurer, Client client, Map initialMetadata, InvokerLocator serverLocator, InvokerCallbackHandler invokerCallbackHandler)
/*     */     throws Throwable
/*     */   {
/* 228 */     String protocol = serverLocator.getProtocol();
/* 229 */     boolean isBisocket = ("bisocket".equals(protocol)) || ("sslbisocket".equals(protocol));
/* 230 */     boolean isSocket = ("socket".equals(protocol)) || ("sslsocket".equals(protocol));
/* 231 */     boolean doPushCallbacks = (isBisocket) || (isSocket);
/* 232 */     Map metadata = createCallbackMetadata(doPushCallbacks, initialMetadata, serverLocator);
/*     */ 
/* 234 */     if (doPushCallbacks)
/*     */     {
/* 236 */       log.trace(configurer + " is doing push callbacks");
/* 237 */       client.addListener(invokerCallbackHandler, metadata, null, true);
/*     */     }
/*     */     else
/*     */     {
/* 241 */       log.trace(configurer + " is simulating push callbacks");
/* 242 */       client.addListener(invokerCallbackHandler, metadata);
/*     */     }
/*     */   }
/*     */ 
/*     */   public JMSRemotingConnection(String serverLocatorURI, boolean clientPing, boolean strictTck)
/*     */     throws Exception
/*     */   {
/* 265 */     this.serverLocator = new InvokerLocator(serverLocatorURI);
/* 266 */     this.clientPing = clientPing;
/* 267 */     this.strictTck = strictTck;
/*     */ 
/* 269 */     log.trace(this + " created");
/*     */   }
/*     */ 
/*     */   public void start()
/*     */     throws Throwable
/*     */   {
/* 278 */     Map config = new HashMap();
/*     */ 
/* 280 */     config.put("enableLease", String.valueOf(this.clientPing));
/*     */ 
/* 282 */     this.client = new Client(this.serverLocator, config);
/*     */ 
/* 284 */     this.client.setSubsystem("JMS");
/*     */ 
/* 286 */     if (log.isTraceEnabled()) log.trace(this + " created client");
/*     */ 
/* 288 */     this.callbackManager = new CallbackManager();
/*     */ 
/* 291 */     AccessController.doPrivileged(new PrivilegedExceptionAction()
/*     */     {
/*     */       public Object run() throws Exception
/*     */       {
/* 295 */         JMSRemotingConnection.this.client.connect();
/* 296 */         return null;
/*     */       }
/*     */     });
/* 305 */     this.client.setMarshaller(new JMSWireFormat());
/* 306 */     this.client.setUnMarshaller(new JMSWireFormat());
/*     */ 
/* 308 */     Map metadata = new HashMap();
/*     */ 
/* 310 */     metadata.put("datatype", "jms");
/*     */ 
/* 312 */     addInvokerCallbackHandler(this, this.client, metadata, this.serverLocator, this.callbackManager);
/*     */ 
/* 314 */     log.trace(this + " started");
/*     */   }
/*     */ 
/*     */   public void stop()
/*     */   {
/* 319 */     log.trace(this + " stop");
/*     */     try
/*     */     {
/* 326 */       this.client.removeListener(this.callbackManager);
/*     */     }
/*     */     catch (Throwable ignore)
/*     */     {
/* 337 */       log.trace(this + " failed to cleanly remove callback manager from the client", ignore);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 342 */       this.client.disconnect();
/*     */     }
/*     */     catch (Throwable ignore)
/*     */     {
/* 346 */       log.trace(this + " failed to disconnect the client", ignore);
/*     */     }
/*     */ 
/* 349 */     this.client = null;
/*     */ 
/* 351 */     log.trace(this + " closed");
/*     */   }
/*     */ 
/*     */   public Client getRemotingClient()
/*     */   {
/* 356 */     return this.client;
/*     */   }
/*     */ 
/*     */   public CallbackManager getCallbackManager()
/*     */   {
/* 361 */     return this.callbackManager;
/*     */   }
/*     */ 
/*     */   public boolean isStrictTck()
/*     */   {
/* 367 */     return this.strictTck;
/*     */   }
/*     */ 
/*     */   public synchronized boolean isFailed()
/*     */   {
/* 372 */     return this.failed;
/*     */   }
/*     */ 
/*     */   public synchronized void setFailed()
/*     */   {
/* 381 */     this.failed = true;
/*     */     try
/*     */     {
/* 390 */       this.client.setDisconnectTimeout(0);
/*     */     }
/*     */     catch (Throwable ignore)
/*     */     {
/* 394 */       log.trace(this + " failed to set disconnect timeout", ignore);
/*     */     }
/*     */ 
/* 397 */     stop();
/*     */   }
/*     */ 
/*     */   public synchronized boolean addConnectionListener(ConsolidatedRemotingConnectionListener listener)
/*     */   {
/* 406 */     if (this.remotingConnectionListener != null)
/*     */     {
/* 408 */       return false;
/*     */     }
/*     */ 
/* 411 */     this.client.addConnectionListener(listener);
/* 412 */     this.remotingConnectionListener = listener;
/*     */ 
/* 414 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized void addPlainConnectionListener(ConnectionListener listener)
/*     */   {
/* 419 */     this.client.addConnectionListener(listener);
/*     */   }
/*     */ 
/*     */   public synchronized void removePlainConnectionListener(ConnectionListener listener)
/*     */   {
/* 424 */     this.client.removeConnectionListener(listener);
/*     */   }
/*     */ 
/*     */   public synchronized ConsolidatedRemotingConnectionListener getConnectionListener()
/*     */   {
/* 429 */     return this.remotingConnectionListener;
/*     */   }
/*     */ 
/*     */   public synchronized ConsolidatedRemotingConnectionListener removeConnectionListener()
/*     */   {
/* 437 */     if (this.remotingConnectionListener == null)
/*     */     {
/* 439 */       return null;
/*     */     }
/*     */ 
/* 442 */     this.client.removeConnectionListener(this.remotingConnectionListener);
/*     */ 
/* 444 */     log.trace(this + " removed consolidated connection listener from " + this.client);
/* 445 */     ConsolidatedRemotingConnectionListener toReturn = this.remotingConnectionListener;
/* 446 */     this.remotingConnectionListener = null;
/* 447 */     return toReturn;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 452 */     return "JMSRemotingConnection[" + this.serverLocator.getLocatorURI() + "]";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.remoting.JMSRemotingConnection
 * JD-Core Version:    0.6.0
 */