/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.net.URL;
/*     */ import javax.xml.parsers.DocumentBuilder;
/*     */ import javax.xml.parsers.DocumentBuilderFactory;
/*     */ import org.jboss.aop.AspectManager;
/*     */ import org.jboss.aop.AspectXmlLoader;
/*     */ import org.w3c.dom.Document;
/*     */ import org.xml.sax.EntityResolver;
/*     */ import org.xml.sax.InputSource;
/*     */ import org.xml.sax.SAXException;
/*     */ 
/*     */ public class JmsClientAspectXMLLoader extends AspectXmlLoader
/*     */ {
/*     */   public JmsClientAspectXMLLoader()
/*     */   {
/*  56 */     setManager(AspectManager.instance());
/*     */   }
/*     */ 
/*     */   public void deployXML(byte[] config)
/*     */     throws Exception
/*     */   {
/*  67 */     synchronized (AspectManager.instance())
/*     */     {
/*  69 */       InputStream is = null;
/*     */       try
/*     */       {
/*  73 */         is = new ByteArrayInputStream(config);
/*     */ 
/*  75 */         DocumentBuilderFactory docBuilderFactory = null;
/*     */ 
/*  77 */         docBuilderFactory = DocumentBuilderFactory.newInstance();
/*     */ 
/*  79 */         docBuilderFactory.setValidating(false);
/*     */ 
/*  81 */         InputSource source = new InputSource(is);
/*     */ 
/*  83 */         URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
/*     */ 
/*  85 */         source.setSystemId(url.toString());
/*     */ 
/*  87 */         DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
/*     */ 
/*  89 */         docBuilder.setEntityResolver(new Resolver(null));
/*     */ 
/*  91 */         Document doc = docBuilder.parse(source);
/*     */ 
/*  93 */         deployXML(doc, null, getClass().getClassLoader());
/*     */       }
/*     */       finally
/*     */       {
/*  97 */         if (is != null)
/*     */         {
/*  99 */           is.close();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static class Resolver
/*     */     implements EntityResolver
/*     */   {
/*     */     public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException
/*     */     {
/* 110 */       if (systemId.endsWith("jboss-aop_1_0.dtd"))
/*     */       {
/*     */         try
/*     */         {
/* 114 */           URL url = AspectXmlLoader.class.getResource("/jboss-aop_1_0.dtd");
/* 115 */           InputStream is = url.openStream();
/* 116 */           return new InputSource(is);
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 120 */           e.printStackTrace();
/* 121 */           return null;
/*     */         }
/*     */       }
/* 124 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.JmsClientAspectXMLLoader
 * JD-Core Version:    0.6.0
 */