/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.HashSet;
/*     */ import java.util.Iterator;
/*     */ import java.util.Set;
/*     */ import javax.jms.IllegalStateException;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.jms.client.Closeable;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.state.HierarchicalState;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClosedInterceptor
/*     */   implements Interceptor
/*     */ {
/*  55 */   private static final Logger log = Logger.getLogger(ClosedInterceptor.class);
/*     */   private static final int NOT_CLOSED = 0;
/*     */   private static final int IN_CLOSING = 1;
/*     */   private static final int CLOSING = 2;
/*     */   private static final int IN_CLOSE = 3;
/*     */   private static final int CLOSED = -1;
/*  65 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*  68 */   private int state = 0;
/*     */   private int inUseCount;
/*     */   private DelegateIdentity id;
/*     */ 
/*     */   public static String stateToString(int state)
/*     */   {
/*  80 */     return state == -1 ? "CLOSED" : state == 3 ? "IN_CLOSE" : state == 2 ? "CLOSING" : state == 1 ? "IN_CLOSING" : state == 0 ? "NOT_CLOSED" : "UNKNOWN";
/*     */   }
/*     */ 
/*     */   public ClosedInterceptor()
/*     */   {
/*  91 */     this.state = 0;
/*  92 */     this.inUseCount = 0;
/*  93 */     this.id = null;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 100 */     StringBuffer sb = new StringBuffer("ClosedInterceptor.");
/* 101 */     if (this.id == null)
/*     */     {
/* 103 */       sb.append("UNINITIALIZED");
/*     */     }
/*     */     else
/*     */     {
/* 107 */       sb.append(this.id.getType()).append("[").append(this.id.getID()).append("]");
/*     */     }
/* 109 */     return sb.toString();
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 116 */     return "ClosedInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Throwable
/*     */   {
/* 123 */     if (this.id == null)
/*     */     {
/* 125 */       this.id = DelegateIdentity.getIdentity(invocation);
/*     */     }
/*     */ 
/* 128 */     String methodName = ((MethodInvocation)invocation).getMethod().getName();
/*     */ 
/* 130 */     boolean isClosing = methodName.equals("closing");
/* 131 */     boolean isClose = methodName.equals("close");
/*     */ 
/* 133 */     if (isClosing)
/*     */     {
/* 135 */       if (checkClosingAlreadyDone())
/*     */       {
/* 137 */         return new Long(-1L);
/*     */       }
/*     */     }
/* 140 */     else if (isClose)
/*     */     {
/* 142 */       if (checkCloseAlreadyDone())
/*     */       {
/* 144 */         return null;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 149 */       synchronized (this)
/*     */       {
/* 152 */         if ((this.state == 3) || (this.state == -1))
/*     */         {
/* 154 */           log.error(this + ": method " + methodName + "() did not go through, " + "the interceptor is " + stateToString(this.state));
/*     */ 
/* 157 */           throw new IllegalStateException("The object is closed");
/*     */         }
/* 159 */         this.inUseCount += 1;
/*     */       }
/*     */     }
/*     */ 
/* 163 */     if (isClosing)
/*     */     {
/* 165 */       maintainRelatives(invocation);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 170 */       ??? = invocation.invokeNext();
/*     */       return ???;
/*     */     }
/*     */     catch (Exception t)
/*     */     {
/* 174 */       if ((isClosing) || (isClose))
/*     */       {
/* 179 */         Long localLong = new Long(-1L);
/*     */         return localLong;
/*     */       }
/* 181 */       throw t;
/*     */     }
/*     */     finally
/*     */     {
/* 185 */       if (isClosing)
/*     */       {
/* 191 */         removeSelf(invocation);
/*     */ 
/* 193 */         closing();
/*     */       }
/* 195 */       else if (isClose)
/*     */       {
/* 197 */         closed();
/*     */       }
/*     */       else
/*     */       {
/* 201 */         done();
/*     */       }
/*     */     }
/* 203 */     throw localObject2;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean checkClosingAlreadyDone()
/*     */     throws Throwable
/*     */   {
/* 215 */     if (this.state != 0)
/*     */     {
/* 217 */       return true;
/*     */     }
/* 219 */     this.state = 1;
/* 220 */     return false;
/*     */   }
/*     */ 
/*     */   protected synchronized void closing()
/*     */     throws Throwable
/*     */   {
/* 228 */     this.state = 2;
/*     */   }
/*     */ 
/*     */   protected synchronized boolean checkCloseAlreadyDone()
/*     */     throws Throwable
/*     */   {
/* 239 */     if (this.state != 2)
/*     */     {
/* 241 */       return true;
/*     */     }
/* 243 */     while (this.inUseCount > 0)
/*     */     {
/* 245 */       wait();
/*     */     }
/* 247 */     this.state = 3;
/* 248 */     return false;
/*     */   }
/*     */ 
/*     */   protected synchronized void closed()
/*     */     throws Throwable
/*     */   {
/* 256 */     this.state = -1;
/* 257 */     log.trace(this + " closed");
/*     */   }
/*     */ 
/*     */   protected synchronized void done()
/*     */     throws Throwable
/*     */   {
/* 265 */     if (--this.inUseCount == 0)
/*     */     {
/* 267 */       notifyAll();
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void maintainRelatives(Invocation invocation)
/*     */   {
/* 278 */     HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
/*     */ 
/* 285 */     Set children = state.getChildren();
/*     */ 
/* 287 */     if (children == null)
/*     */     {
/* 289 */       if (this.trace) log.trace(this + " has no children");
/* 290 */       return;
/*     */     }
/*     */     Set clone;
/* 293 */     synchronized (children)
/*     */     {
/* 295 */       clone = new HashSet(children);
/*     */     }
/*     */ 
/* 299 */     for (Iterator i = clone.iterator(); i.hasNext(); )
/*     */     {
/* 301 */       HierarchicalState child = (HierarchicalState)i.next();
/* 302 */       Closeable del = (Closeable)child.getDelegate();
/*     */       try
/*     */       {
/* 305 */         del.closing(-1L);
/* 306 */         del.close();
/*     */       }
/*     */       catch (Throwable t)
/*     */       {
/* 312 */         if (this.trace)
/*     */         {
/* 314 */           log.trace("Failed to close", t);
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void removeSelf(Invocation invocation)
/*     */   {
/* 327 */     HierarchicalState state = ((DelegateSupport)invocation.getTargetObject()).getState();
/*     */ 
/* 329 */     HierarchicalState parent = state.getParent();
/* 330 */     if (parent != null)
/*     */     {
/* 332 */       parent.getChildren().remove(state);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ClosedInterceptor
 * JD-Core Version:    0.6.0
 */