/*     */ package org.jboss.jms.client.container;
/*     */ 
/*     */ import java.lang.reflect.Method;
/*     */ import org.jboss.aop.advice.Interceptor;
/*     */ import org.jboss.aop.joinpoint.Invocation;
/*     */ import org.jboss.aop.joinpoint.MethodInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class ClientLogInterceptor
/*     */   implements Interceptor
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(ClientLogInterceptor.class);
/*     */ 
/*  48 */   private boolean trace = log.isTraceEnabled();
/*     */ 
/*     */   public String getName()
/*     */   {
/*  58 */     return "ClientLogInterceptor";
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation) throws Throwable
/*     */   {
/*  63 */     Method method = null;
/*  64 */     String methodName = null;
/*  65 */     Object target = null;
/*  66 */     if (this.trace)
/*     */     {
/*  68 */       target = invocation.getTargetObject();
/*     */ 
/*  70 */       if (!(invocation instanceof MethodInvocation))
/*     */       {
/*  72 */         log.trace("invoking non-method invocation: " + invocation);
/*     */       }
/*     */       else
/*     */       {
/*  76 */         MethodInvocation mi = (MethodInvocation)invocation;
/*  77 */         method = mi.getMethod();
/*  78 */         methodName = method.getName();
/*  79 */         StringBuffer sb = new StringBuffer();
/*  80 */         sb.append("invoking ").append(target).append('.').append(methodName).append('(');
/*  81 */         Object[] args = mi.getArguments();
/*  82 */         if (args != null)
/*     */         {
/*  84 */           for (int i = 0; i < args.length; i++)
/*     */           {
/*  87 */             if (("createConnectionDelegate".equals(methodName)) && (i == 1))
/*     */             {
/*  89 */               sb.append("*****");
/*     */             }
/*     */             else
/*     */             {
/*  93 */               sb.append(args[i]);
/*     */             }
/*  95 */             if (i >= args.length - 1)
/*     */               continue;
/*  97 */             sb.append(", ");
/*     */           }
/*     */         }
/*     */ 
/* 101 */         sb.append(')');
/*     */ 
/* 103 */         log.trace(sb.toString());
/*     */       }
/*     */     }
/*     */ 
/* 107 */     Object res = invocation.invokeNext();
/*     */ 
/* 109 */     if (this.trace)
/*     */     {
/* 111 */       if (method == null)
/*     */       {
/* 113 */         log.trace(invocation + " successfully invoked on " + target);
/*     */       }
/* 117 */       else if (method.getReturnType() != Void.TYPE)
/*     */       {
/* 119 */         log.trace(target + "." + methodName + "() returned " + res);
/*     */       }
/*     */       else
/*     */       {
/* 123 */         log.trace(target + "." + methodName + "() OK");
/*     */       }
/*     */     }
/*     */ 
/* 127 */     return res;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.container.ClientLogInterceptor
 * JD-Core Version:    0.6.0
 */