/*     */ package org.jboss.jms.client;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import javax.jms.Connection;
/*     */ import javax.jms.ConnectionConsumer;
/*     */ import javax.jms.ConnectionMetaData;
/*     */ import javax.jms.Destination;
/*     */ import javax.jms.ExceptionListener;
/*     */ import javax.jms.IllegalStateException;
/*     */ import javax.jms.JMSException;
/*     */ import javax.jms.Queue;
/*     */ import javax.jms.QueueConnection;
/*     */ import javax.jms.QueueSession;
/*     */ import javax.jms.ServerSessionPool;
/*     */ import javax.jms.Session;
/*     */ import javax.jms.Topic;
/*     */ import javax.jms.TopicConnection;
/*     */ import javax.jms.TopicSession;
/*     */ import javax.jms.XAConnection;
/*     */ import javax.jms.XAQueueConnection;
/*     */ import javax.jms.XAQueueSession;
/*     */ import javax.jms.XASession;
/*     */ import javax.jms.XATopicConnection;
/*     */ import javax.jms.XATopicSession;
/*     */ import org.jboss.jms.client.delegate.ClientConnectionDelegate;
/*     */ import org.jboss.jms.client.delegate.DelegateSupport;
/*     */ import org.jboss.jms.client.remoting.JMSRemotingConnection;
/*     */ import org.jboss.jms.client.state.ConnectionState;
/*     */ import org.jboss.jms.delegate.ConnectionDelegate;
/*     */ import org.jboss.jms.delegate.SessionDelegate;
/*     */ import org.jboss.remoting.Client;
/*     */ 
/*     */ public class JBossConnection
/*     */   implements Connection, QueueConnection, TopicConnection, XAConnection, XAQueueConnection, XATopicConnection, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = -3715868654823177898L;
/*     */   static final int TYPE_GENERIC_CONNECTION = 0;
/*     */   static final int TYPE_QUEUE_CONNECTION = 1;
/*     */   static final int TYPE_TOPIC_CONNECTION = 2;
/*     */   protected ConnectionDelegate delegate;
/*     */   private int connectionType;
/*     */ 
/*     */   public JBossConnection(ConnectionDelegate delegate, int connectionType)
/*     */   {
/*  83 */     this.delegate = delegate;
/*  84 */     this.connectionType = connectionType;
/*     */   }
/*     */ 
/*     */   public Session createSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/*  91 */     return createSessionInternal(transacted, acknowledgeMode, false, 0);
/*     */   }
/*     */ 
/*     */   public String getClientID() throws JMSException
/*     */   {
/*  96 */     return this.delegate.getClientID();
/*     */   }
/*     */ 
/*     */   public void setClientID(String clientID) throws JMSException
/*     */   {
/* 101 */     this.delegate.setClientID(clientID);
/*     */   }
/*     */ 
/*     */   public ConnectionMetaData getMetaData() throws JMSException
/*     */   {
/* 106 */     return this.delegate.getConnectionMetaData();
/*     */   }
/*     */ 
/*     */   public ExceptionListener getExceptionListener() throws JMSException
/*     */   {
/* 111 */     return this.delegate.getExceptionListener();
/*     */   }
/*     */ 
/*     */   public void setExceptionListener(ExceptionListener listener) throws JMSException
/*     */   {
/* 116 */     this.delegate.setExceptionListener(listener);
/*     */   }
/*     */ 
/*     */   public void start() throws JMSException
/*     */   {
/* 121 */     this.delegate.start();
/*     */   }
/*     */ 
/*     */   public void stop() throws JMSException
/*     */   {
/* 126 */     this.delegate.stop();
/*     */   }
/*     */ 
/*     */   public void close() throws JMSException
/*     */   {
/* 131 */     this.delegate.closing(-1L);
/* 132 */     this.delegate.close();
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 140 */     return this.delegate.createConnectionConsumer(destination, null, messageSelector, sessionPool, maxMessages);
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 151 */     if (this.connectionType == 1)
/*     */     {
/* 153 */       String msg = "Cannot create a durable connection consumer on a QueueConnection";
/* 154 */       throw new IllegalStateException(msg);
/*     */     }
/* 156 */     return this.delegate.createConnectionConsumer(topic, subscriptionName, messageSelector, sessionPool, maxMessages);
/*     */   }
/*     */ 
/*     */   public QueueSession createQueueSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/* 165 */     return createSessionInternal(transacted, acknowledgeMode, false, 1);
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Queue queue, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 173 */     return this.delegate.createConnectionConsumer(queue, null, messageSelector, sessionPool, maxMessages);
/*     */   }
/*     */ 
/*     */   public TopicSession createTopicSession(boolean transacted, int acknowledgeMode)
/*     */     throws JMSException
/*     */   {
/* 182 */     return createSessionInternal(transacted, acknowledgeMode, false, 2);
/*     */   }
/*     */ 
/*     */   public ConnectionConsumer createConnectionConsumer(Topic topic, String messageSelector, ServerSessionPool sessionPool, int maxMessages)
/*     */     throws JMSException
/*     */   {
/* 190 */     return this.delegate.createConnectionConsumer(topic, null, messageSelector, sessionPool, maxMessages);
/*     */   }
/*     */ 
/*     */   public XASession createXASession()
/*     */     throws JMSException
/*     */   {
/* 198 */     return createSessionInternal(true, 0, true, 0);
/*     */   }
/*     */ 
/*     */   public XAQueueSession createXAQueueSession()
/*     */     throws JMSException
/*     */   {
/* 206 */     return createSessionInternal(true, 0, true, 1);
/*     */   }
/*     */ 
/*     */   public XATopicSession createXATopicSession()
/*     */     throws JMSException
/*     */   {
/* 215 */     return createSessionInternal(true, 0, true, 2);
/*     */   }
/*     */ 
/*     */   public String getRemotingClientSessionID()
/*     */   {
/* 224 */     ConnectionState state = (ConnectionState)((ClientConnectionDelegate)this.delegate).getState();
/*     */ 
/* 226 */     return state.getRemotingConnection().getRemotingClient().getSessionId();
/*     */   }
/*     */ 
/*     */   public ConnectionDelegate getDelegate()
/*     */   {
/* 231 */     return this.delegate;
/*     */   }
/*     */ 
/*     */   public int getServerID()
/*     */   {
/* 239 */     return ((ConnectionState)((DelegateSupport)this.delegate).getState()).getServerID();
/*     */   }
/*     */ 
/*     */   public void registerFailoverListener(FailoverListener listener)
/*     */   {
/* 244 */     this.delegate.registerFailoverListener(listener);
/*     */   }
/*     */ 
/*     */   public synchronized boolean unregisterFailoverListener(FailoverListener listener)
/*     */   {
/* 249 */     return this.delegate.unregisterFailoverListener(listener);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 254 */     return "JBossConnection->" + this.delegate;
/*     */   }
/*     */ 
/*     */   protected JBossSession createSessionInternal(boolean transacted, int acknowledgeMode, boolean isXA, int type)
/*     */     throws JMSException
/*     */   {
/* 264 */     if (transacted)
/*     */     {
/* 266 */       acknowledgeMode = 0;
/*     */     }
/*     */ 
/* 269 */     SessionDelegate sessionDelegate = this.delegate.createSessionDelegate(transacted, acknowledgeMode, isXA);
/*     */ 
/* 271 */     return new JBossSession(sessionDelegate, type);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.jms.client.JBossConnection
 * JD-Core Version:    0.6.0
 */