/*     */ package org.jboss.invocation.unified.marshall;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.OutputStream;
/*     */ import javax.transaction.SystemException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.remoting.InvocationRequest;
/*     */ import org.jboss.remoting.marshal.Marshaller;
/*     */ import org.jboss.remoting.marshal.MarshallerDecorator;
/*     */ import org.jboss.remoting.marshal.serializable.SerializableMarshaller;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextUtil;
/*     */ 
/*     */ public class InvocationMarshaller extends SerializableMarshaller
/*     */   implements MarshallerDecorator
/*     */ {
/*     */   static final long serialVersionUID = -2109634245396128775L;
/*     */   public static final String DATATYPE = "invocation";
/*  52 */   private static final Logger log = Logger.getLogger(InvocationMarshaller.class);
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output)
/*     */     throws IOException
/*     */   {
/*  69 */     super.write(addDecoration(dataObject), output);
/*     */   }
/*     */ 
/*     */   public void write(Object dataObject, OutputStream output, int version)
/*     */     throws IOException
/*     */   {
/*  75 */     super.write(addDecoration(dataObject), output, version);
/*     */   }
/*     */ 
/*     */   public Object addDecoration(Object dataObject) throws IOException {
/*  79 */     if ((dataObject instanceof InvocationRequest))
/*     */     {
/*  81 */       InvocationRequest remoteInv = (InvocationRequest)dataObject;
/*     */ 
/*  83 */       if ((remoteInv.getParameter() instanceof Invocation))
/*     */       {
/*  85 */         Invocation inv = (Invocation)remoteInv.getParameter();
/*     */ 
/*  87 */         MarshalledInvocation marshInv = new MarshalledInvocation(inv);
/*     */ 
/*  89 */         if (inv != null)
/*     */         {
/*     */           try
/*     */           {
/*  97 */             marshInv.setTransactionPropagationContext(getTransactionPropagationContext());
/*     */           }
/*     */           catch (SystemException e)
/*     */           {
/* 101 */             log.error("Error setting transaction propagation context.", e);
/* 102 */             throw new IOException("Error setting transaction context.  Message: " + e.getMessage());
/*     */           }
/*     */ 
/* 106 */           remoteInv.setParameter(marshInv);
/*     */         }
/*     */         else
/*     */         {
/* 111 */           log.error("Attempting to marshall Invocation but is null.  Can not proceed.");
/* 112 */           throw new IOException("Can not process data object due to the InvocationRequest's parameter being null.");
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 117 */     return dataObject;
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */     throws SystemException
/*     */   {
/* 123 */     TransactionPropagationContextFactory tpcFactory = TransactionPropagationContextUtil.getTPCFactoryClientSide();
/* 124 */     return tpcFactory == null ? null : tpcFactory.getTransactionPropagationContext();
/*     */   }
/*     */ 
/*     */   public Marshaller cloneMarshaller() throws CloneNotSupportedException
/*     */   {
/* 129 */     return new InvocationMarshaller();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.marshall.InvocationMarshaller
 * JD-Core Version:    0.6.0
 */