/*    */ package org.jboss.invocation.unified.marshall;
/*    */ 
/*    */ import java.io.IOException;
/*    */ import java.io.InputStream;
/*    */ import java.util.Map;
/*    */ import org.jboss.invocation.MarshalledInvocation;
/*    */ import org.jboss.remoting.InvocationRequest;
/*    */ import org.jboss.remoting.marshal.UnMarshaller;
/*    */ import org.jboss.remoting.marshal.http.HTTPUnMarshaller;
/*    */ import org.jboss.tm.TransactionPropagationContextImporter;
/*    */ import org.jboss.tm.TransactionPropagationContextUtil;
/*    */ 
/*    */ public class HTTPInvocationUnMarshaller extends HTTPUnMarshaller
/*    */ {
/*    */   static final long serialVersionUID = 2114466048129928103L;
/*    */   public static final String DATATYPE = "invocationhttp";
/*    */ 
/*    */   public Object read(InputStream inputStream, Map metadata, int version)
/*    */     throws IOException, ClassNotFoundException
/*    */   {
/* 51 */     Object ret = super.read(inputStream, metadata, version);
/*    */ 
/* 53 */     if ((ret instanceof InvocationRequest))
/*    */     {
/* 55 */       InvocationRequest remoteInv = (InvocationRequest)ret;
/* 56 */       Object param = remoteInv.getParameter();
/*    */ 
/* 58 */       if ((param instanceof MarshalledInvocation))
/*    */       {
/* 60 */         MarshalledInvocation mi = (MarshalledInvocation)param;
/* 61 */         Object txCxt = mi.getTransactionPropagationContext();
/* 62 */         if (txCxt != null)
/*    */         {
/* 64 */           TransactionPropagationContextImporter tpcImporter = TransactionPropagationContextUtil.getTPCImporter();
/* 65 */           mi.setTransaction(tpcImporter.importTransactionPropagationContext(txCxt));
/*    */         }
/*    */       }
/*    */     }
/*    */ 
/* 70 */     return ret;
/*    */   }
/*    */ 
/*    */   public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException
/*    */   {
/* 75 */     HTTPInvocationUnMarshaller unmarshaller = new HTTPInvocationUnMarshaller();
/* 76 */     unmarshaller.setClassLoader(this.customClassLoader);
/* 77 */     return unmarshaller;
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.unified.marshall.HTTPInvocationUnMarshaller
 * JD-Core Version:    0.6.0
 */