/*     */ package org.jboss.invocation.http.server;
/*     */ 
/*     */ import java.net.InetAddress;
/*     */ import java.net.UnknownHostException;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanServer;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.RuntimeMBeanException;
/*     */ import javax.management.RuntimeOperationsException;
/*     */ import javax.naming.InitialContext;
/*     */ import javax.naming.NamingException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.invocation.http.interfaces.HttpInvokerProxy;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.system.Registry;
/*     */ import org.jboss.system.ServiceMBeanSupport;
/*     */ import org.jboss.system.server.ServerConfigUtil;
/*     */ import org.jboss.util.StringPropertyReplacer;
/*     */ 
/*     */ public class HttpInvoker extends ServiceMBeanSupport
/*     */   implements HttpInvokerMBean
/*     */ {
/*     */   private String invokerURL;
/*  53 */   private String invokerURLPrefix = "http://";
/*  54 */   private String invokerURLSuffix = ":8080/invoker/JMXInvokerServlet";
/*  55 */   private boolean useHostName = false;
/*     */ 
/*     */   public String getInvokerURL()
/*     */   {
/*  61 */     return this.invokerURL;
/*     */   }
/*     */ 
/*     */   public void setInvokerURL(String invokerURL)
/*     */   {
/*  66 */     String tmp = StringPropertyReplacer.replaceProperties(invokerURL);
/*  67 */     this.invokerURL = tmp;
/*  68 */     this.log.debug("Set invokerURL to " + this.invokerURL);
/*     */   }
/*     */ 
/*     */   public String getInvokerURLPrefix()
/*     */   {
/*  73 */     return this.invokerURLPrefix;
/*     */   }
/*     */ 
/*     */   public void setInvokerURLPrefix(String invokerURLPrefix) {
/*  77 */     this.invokerURLPrefix = invokerURLPrefix;
/*     */   }
/*     */ 
/*     */   public String getInvokerURLSuffix()
/*     */   {
/*  82 */     return this.invokerURLSuffix;
/*     */   }
/*     */ 
/*     */   public void setInvokerURLSuffix(String invokerURLSuffix) {
/*  86 */     this.invokerURLSuffix = invokerURLSuffix;
/*     */   }
/*     */ 
/*     */   public boolean getUseHostName()
/*     */   {
/*  91 */     return this.useHostName;
/*     */   }
/*     */ 
/*     */   public void setUseHostName(boolean flag) {
/*  95 */     this.useHostName = flag;
/*     */   }
/*     */ 
/*     */   protected void startService()
/*     */     throws Exception
/*     */   {
/* 101 */     checkInvokerURL();
/* 102 */     Invoker delegateInvoker = new HttpInvokerProxy(this.invokerURL);
/*     */ 
/* 105 */     ObjectName name = super.getServiceName();
/* 106 */     Registry.bind(name, delegateInvoker);
/* 107 */     this.log.debug("Bound Http invoker for JMX node");
/*     */   }
/*     */ 
/*     */   protected void stopService()
/*     */   {
/*     */     try
/*     */     {
/* 114 */       InitialContext ctx = new InitialContext();
/* 115 */       ctx.unbind("invokers/" + InetAddress.getLocalHost().getHostName() + "/http");
/*     */     }
/*     */     catch (NamingException ignore)
/*     */     {
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 122 */       this.log.error("Failed", e);
/* 123 */       return;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void destroyService()
/*     */   {
/* 130 */     Registry.unbind(this.serviceName);
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 139 */     ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
/*     */     try
/*     */     {
/* 143 */       MarshalledInvocation mi = (MarshalledInvocation)invocation;
/* 144 */       Object tpc = mi.getTransactionPropagationContext();
/* 145 */       Transaction tx = importTPC(tpc);
/* 146 */       invocation.setTransaction(tx);
/*     */ 
/* 148 */       Integer nameHash = (Integer)invocation.getObjectName();
/* 149 */       ObjectName mbean = (ObjectName)Registry.lookup(nameHash);
/*     */ 
/* 152 */       Object[] args = { invocation };
/* 153 */       String[] sig = { "org.jboss.invocation.Invocation" };
/* 154 */       Object obj = super.getServer().invoke(mbean, "invoke", args, sig);
/*     */ 
/* 158 */       localObject1 = obj;
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*     */       Object localObject1;
/* 162 */       if ((e instanceof MBeanException)) {
/* 163 */         e = ((MBeanException)e).getTargetException();
/*     */       }
/* 165 */       if ((e instanceof RuntimeMBeanException)) {
/* 166 */         e = ((RuntimeMBeanException)e).getTargetException();
/*     */       }
/* 168 */       if ((e instanceof RuntimeOperationsException)) {
/* 169 */         e = ((RuntimeOperationsException)e).getTargetException();
/*     */       }
/*     */ 
/* 172 */       if (this.log.isTraceEnabled())
/* 173 */         this.log.trace("operation failed", e);
/* 174 */       throw e;
/*     */     }
/*     */     finally
/*     */     {
/* 178 */       Thread.currentThread().setContextClassLoader(oldCl);
/*     */     }
/*     */   }
/*     */ 
/*     */   protected Transaction importTPC(Object tpc)
/*     */   {
/* 192 */     return null;
/*     */   }
/*     */ 
/*     */   protected void checkInvokerURL()
/*     */     throws UnknownHostException
/*     */   {
/* 202 */     if (this.invokerURL == null)
/*     */     {
/* 204 */       InetAddress addr = InetAddress.getLocalHost();
/*     */ 
/* 206 */       String host = ServerConfigUtil.getSpecificBindAddress();
/* 207 */       if (host == null)
/*     */       {
/* 209 */         host = this.useHostName ? addr.getHostName() : addr.getHostAddress();
/*     */       }
/* 211 */       String url = this.invokerURLPrefix + host + this.invokerURLSuffix;
/* 212 */       setInvokerURL(url);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.http.server.HttpInvoker
 * JD-Core Version:    0.6.0
 */