/*     */ package org.jboss.invocation.http.interfaces;
/*     */ 
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectStreamException;
/*     */ import java.io.OutputStream;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.lang.reflect.Method;
/*     */ import java.net.Authenticator;
/*     */ import java.net.HttpURLConnection;
/*     */ import java.net.MalformedURLException;
/*     */ import java.net.URL;
/*     */ import java.security.AccessController;
/*     */ import java.security.PrivilegedAction;
/*     */ import java.util.zip.GZIPInputStream;
/*     */ import javax.net.ssl.HttpsURLConnection;
/*     */ import javax.net.ssl.SSLSocketFactory;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationException;
/*     */ import org.jboss.invocation.MarshalledValue;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.net.ssl.SSLSocketFactoryBuilder;
/*     */ import org.jboss.security.SecurityAssociationAuthenticator;
/*     */ 
/*     */ public class Util
/*     */ {
/*     */   public static final String IGNORE_HTTPS_HOST = "org.jboss.security.ignoreHttpsHost";
/*     */   public static final String SSL_FACTORY_BUILDER = "org.jboss.security.httpInvoker.sslSocketFactoryBuilder";
/*  63 */   private static String REQUEST_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledInvocation";
/*     */ 
/*  65 */   private static Logger log = Logger.getLogger(Util.class);
/*     */   private static SSLSocketFactoryBuilder sslSocketFactoryBuilder;
/*     */ 
/*     */   public static void init()
/*     */   {
/*     */     try
/*     */     {
/* 133 */       SetAuthenticator action = new SetAuthenticator();
/* 134 */       AccessController.doPrivileged(action);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 138 */       log.warn("Failed to install SecurityAssociationAuthenticator", e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public static Object invoke(URL externalURL, Invocation mi)
/*     */     throws Exception
/*     */   {
/* 149 */     if (log.isTraceEnabled()) {
/* 150 */       log.trace("invoke, externalURL=" + externalURL);
/*     */     }
/*     */ 
/* 155 */     HttpURLConnection conn = (HttpURLConnection)externalURL.openConnection();
/* 156 */     configureHttpsHostVerifier(conn);
/* 157 */     conn.setDoInput(true);
/* 158 */     conn.setDoOutput(true);
/* 159 */     conn.setRequestProperty("ContentType", REQUEST_CONTENT_TYPE);
/* 160 */     conn.setRequestMethod("POST");
/*     */ 
/* 162 */     conn.setRequestProperty("Accept-Encoding", "x-gzip,x-deflate,gzip,deflate");
/* 163 */     OutputStream os = conn.getOutputStream();
/* 164 */     ObjectOutputStream oos = new ObjectOutputStream(os);
/*     */     try
/*     */     {
/* 167 */       oos.writeObject(mi);
/* 168 */       oos.flush();
/*     */     }
/*     */     catch (ObjectStreamException e)
/*     */     {
/* 174 */       throw new InvocationException(e);
/*     */     }
/*     */ 
/* 178 */     InputStream is = conn.getInputStream();
/*     */ 
/* 180 */     String encoding = conn.getHeaderField("Content-Encoding");
/* 181 */     if ((encoding != null) && (encoding.indexOf("gzip") >= 0))
/* 182 */       is = new GZIPInputStream(is);
/* 183 */     ObjectInputStream ois = new ObjectInputStream(is);
/* 184 */     MarshalledValue mv = (MarshalledValue)ois.readObject();
/*     */ 
/* 186 */     ois.read();
/* 187 */     ois.close();
/* 188 */     oos.close();
/*     */ 
/* 191 */     Object value = mv.get();
/* 192 */     if ((value instanceof Exception))
/*     */     {
/* 194 */       throw ((Exception)value);
/*     */     }
/*     */ 
/* 197 */     return value;
/*     */   }
/*     */ 
/*     */   public static void configureHttpsHostVerifier(HttpURLConnection conn)
/*     */   {
/* 210 */     if ((conn instanceof HttpsURLConnection))
/*     */     {
/* 213 */       if (Boolean.getBoolean("org.jboss.security.ignoreHttpsHost") == true)
/*     */       {
/* 215 */         AnyhostVerifier.setHostnameVerifier(conn);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void configureSSLSocketFactory(HttpURLConnection conn)
/*     */     throws InvocationTargetException
/*     */   {
/* 231 */     Class connClass = conn.getClass();
/* 232 */     if (((conn instanceof HttpsURLConnection)) && (sslSocketFactoryBuilder != null))
/*     */     {
/*     */       try
/*     */       {
/* 236 */         SSLSocketFactory socketFactory = sslSocketFactoryBuilder.getSocketFactory();
/* 237 */         Class[] sig = { SSLSocketFactory.class };
/* 238 */         Method method = connClass.getMethod("setSSLSocketFactory", sig);
/* 239 */         Object[] args = { socketFactory };
/* 240 */         method.invoke(conn, args);
/* 241 */         log.trace("Socket factory set on connection");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 245 */         throw new InvocationTargetException(e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public static URL resolveURL(String urlValue)
/*     */     throws MalformedURLException
/*     */   {
/* 260 */     if (urlValue == null) {
/* 261 */       return null;
/*     */     }
/* 263 */     URL externalURL = null;
/*     */     try
/*     */     {
/* 266 */       externalURL = new URL(urlValue);
/*     */     }
/*     */     catch (MalformedURLException e)
/*     */     {
/* 271 */       String urlProperty = System.getProperty(urlValue);
/* 272 */       if (urlProperty == null)
/* 273 */         throw e;
/* 274 */       externalURL = new URL(urlProperty);
/*     */     }
/* 276 */     return externalURL;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/*  92 */       SetAuthenticator action = new SetAuthenticator();
/*  93 */       AccessController.doPrivileged(action);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/*  97 */       log.warn("Failed to install SecurityAssociationAuthenticator", e);
/*     */     }
/*  99 */     ClassLoader loader = Thread.currentThread().getContextClassLoader();
/*     */ 
/* 101 */     String factoryFactoryFQCN = null;
/*     */     try
/*     */     {
/* 104 */       ReadSSLBuilder action = new ReadSSLBuilder();
/* 105 */       factoryFactoryFQCN = (String)AccessController.doPrivileged(action);
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 109 */       log.warn("Failed to read org.jboss.security.httpInvoker.sslSocketFactoryBuilder", e);
/*     */     }
/*     */ 
/* 112 */     if (factoryFactoryFQCN != null)
/*     */     {
/*     */       try
/*     */       {
/* 116 */         Class clazz = loader.loadClass(factoryFactoryFQCN);
/* 117 */         sslSocketFactoryBuilder = (SSLSocketFactoryBuilder)clazz.newInstance();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 121 */         log.warn("Could not instantiate SSLSocketFactoryFactory", e);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   static class ReadSSLBuilder
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/*  82 */       String value = System.getProperty("org.jboss.security.httpInvoker.sslSocketFactoryBuilder");
/*  83 */       return value;
/*     */     }
/*     */   }
/*     */ 
/*     */   static class SetAuthenticator
/*     */     implements PrivilegedAction
/*     */   {
/*     */     public Object run()
/*     */     {
/*  73 */       Authenticator.setDefault(new SecurityAssociationAuthenticator());
/*  74 */       return null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.http.interfaces.Util
 * JD-Core Version:    0.6.0
 */