/*     */ package org.jboss.invocation.http.interfaces;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInput;
/*     */ import java.io.ObjectOutput;
/*     */ import java.lang.reflect.InvocationTargetException;
/*     */ import java.net.URL;
/*     */ import java.rmi.ServerException;
/*     */ import org.jboss.invocation.Invocation;
/*     */ import org.jboss.invocation.InvocationException;
/*     */ import org.jboss.invocation.Invoker;
/*     */ import org.jboss.invocation.MarshalledInvocation;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ public class HttpInvokerProxy
/*     */   implements Invoker, Externalizable
/*     */ {
/*  52 */   private static Logger log = Logger.getLogger(HttpInvokerProxy.class);
/*     */   static final long serialVersionUID = -8249272784108192267L;
/*     */   protected String externalURLValue;
/*     */   protected transient URL externalURL;
/*     */ 
/*     */   public HttpInvokerProxy()
/*     */   {
/*     */   }
/*     */ 
/*     */   public HttpInvokerProxy(String externalURLValue)
/*     */   {
/*  75 */     this.externalURLValue = externalURLValue;
/*     */   }
/*     */ 
/*     */   public String getServerHostName()
/*     */     throws Exception
/*     */   {
/*  82 */     if (this.externalURL == null)
/*  83 */       this.externalURL = Util.resolveURL(this.externalURLValue);
/*  84 */     return this.externalURL.getHost();
/*     */   }
/*     */ 
/*     */   public String getExternalURLValue() {
/*  88 */     return this.externalURLValue;
/*     */   }
/*     */ 
/*     */   public URL getExternalURL() {
/*  92 */     return this.externalURL;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/*  97 */     StringBuffer tmp = new StringBuffer(super.toString());
/*  98 */     tmp.append('(');
/*  99 */     tmp.append("externalURL:");
/* 100 */     tmp.append(this.externalURL);
/* 101 */     tmp.append(')');
/* 102 */     return tmp.toString();
/*     */   }
/*     */ 
/*     */   public Object invoke(Invocation invocation)
/*     */     throws Exception
/*     */   {
/* 112 */     MarshalledInvocation mi = new MarshalledInvocation(invocation);
/*     */ 
/* 114 */     if (this.externalURL == null)
/* 115 */       this.externalURL = Util.resolveURL(this.externalURLValue);
/*     */     try
/*     */     {
/* 118 */       Object value = Util.invoke(this.externalURL, mi);
/* 119 */       return value;
/*     */     }
/*     */     catch (InvocationException e)
/*     */     {
/* 124 */       Throwable t = e.getTargetException();
/* 125 */       if ((t instanceof Exception))
/* 126 */         throw ((Exception)t);
/* 127 */       if ((t instanceof Error))
/* 128 */         throw ((Error)t);
/* 129 */       throw new InvocationTargetException(t);
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 133 */     throw new ServerException("IOE", e);
/*     */   }
/*     */ 
/*     */   public void writeExternal(ObjectOutput out)
/*     */     throws IOException
/*     */   {
/* 142 */     out.writeObject(this.externalURLValue);
/*     */   }
/*     */ 
/*     */   public void readExternal(ObjectInput in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 150 */     this.externalURLValue = ((String)in.readObject());
/* 151 */     this.externalURL = Util.resolveURL(this.externalURLValue);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.invocation.http.interfaces.HttpInvokerProxy
 * JD-Core Version:    0.6.0
 */