/*    */ package org.jboss.injection;
/*    */ 
/*    */ import javax.ejb.TransactionManagementType;
/*    */ import javax.transaction.UserTransaction;
/*    */ import org.jboss.aop.Advisor;
/*    */ import org.jboss.ejb3.Container;
/*    */ import org.jboss.ejb3.tx.TxUtil;
/*    */ import org.jboss.ejb3.tx.UserTransactionImpl;
/*    */ import org.jboss.injection.lang.reflect.BeanProperty;
/*    */ 
/*    */ public class UserTransactionPropertyInjector extends AbstractPropertyInjector
/*    */ {
/*    */   public UserTransactionPropertyInjector(BeanProperty property, InjectionContainer container)
/*    */   {
/* 44 */     super(property);
/*    */ 
/* 46 */     if ((container instanceof Container))
/*    */     {
/* 48 */       TransactionManagementType type = TxUtil.getTransactionManagementType((Advisor)container);
/* 49 */       if (type != TransactionManagementType.BEAN)
/* 50 */         throw new IllegalStateException("Container " + ((Container)container).getEjbName() + ": it is illegal to inject UserTransaction into a CMT bean");
/*    */     }
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/* 56 */     UserTransaction ut = new UserTransactionImpl();
/* 57 */     this.property.set(instance, ut);
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.UserTransactionPropertyInjector
 * JD-Core Version:    0.6.0
 */