/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.AnnotatedElement;
/*    */ import javax.naming.Context;
/*    */ import javax.xml.ws.WebServiceException;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
/*    */ import org.jboss.metadata.serviceref.ServiceReferenceHandler;
/*    */ import org.jboss.metadata.serviceref.VirtualFileAdaptor;
/*    */ import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
/*    */ 
/*    */ public class ServiceRefInjector
/*    */   implements EncInjector
/*    */ {
/* 45 */   private static final Logger log = Logger.getLogger(ServiceRefInjector.class);
/*    */   private String name;
/*    */   private ServiceReferenceMetaData sref;
/*    */ 
/*    */   public ServiceRefInjector(String name, AnnotatedElement anElement, ServiceReferenceMetaData sref)
/*    */   {
/* 52 */     this.name = name;
/* 53 */     this.sref = sref;
/* 54 */     this.sref.setAnnotatedElement(anElement);
/*    */   }
/*    */ 
/*    */   public void inject(InjectionContainer container)
/*    */   {
/*    */     try
/*    */     {
/* 61 */       Context envCtx = container.getEnc();
/* 62 */       ClassLoader loader = container.getClassloader();
/* 63 */       UnifiedVirtualFile vfsRoot = new VirtualFileAdaptor(container.getRootFile());
/* 64 */       new ServiceReferenceHandler().bindServiceRef(envCtx, this.name, vfsRoot, loader, this.sref);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 68 */       throw new WebServiceException("Unable to bind ServiceRef [enc=" + this.name + "]", e);
/*    */     }
/*    */   }
/*    */ 
/*    */   public String toString()
/*    */   {
/* 74 */     return super.toString() + "{enc=" + this.name + "}";
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.ServiceRefInjector
 * JD-Core Version:    0.6.0
 */