/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.persistence.EntityManagerFactory;
/*     */ import javax.persistence.PersistenceUnit;
/*     */ import javax.persistence.PersistenceUnits;
/*     */ import org.hibernate.SessionFactory;
/*     */ import org.jboss.ejb3.DependencyPolicy;
/*     */ import org.jboss.ejb3.annotation.IgnoreDependency;
/*     */ import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
/*     */ import org.jboss.ejb3.entity.InjectedSessionFactory;
/*     */ import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
/*     */ import org.jboss.ejb3.entity.PersistenceUnitDeployment;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceUnitReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ 
/*     */ public class PersistenceUnitHandler<X extends RemoteEnvironment>
/*     */   implements InjectionHandler<X>
/*     */ {
/*  52 */   private static final Logger log = Logger.getLogger(PersistenceUnitHandler.class);
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container)
/*     */   {
/*  56 */     if (xml == null) return;
/*  57 */     if (xml.getPersistenceUnitRefs() == null) return;
/*     */ 
/*  59 */     for (PersistenceUnitReferenceMetaData ref : xml.getPersistenceUnitRefs())
/*     */     {
/*  61 */       String encName = "env/" + ref.getPersistenceUnitRefName();
/*     */ 
/*  64 */       Class injectionType = InjectionUtil.injectionTarget(encName, ref, container, container.getEncInjections());
/*  65 */       if (container.getEncInjectors().containsKey(encName))
/*  66 */         return;
/*  67 */       container.getEncInjectors().put(encName, new PuEncInjector(encName, injectionType, ref.getPersistenceUnitName(), "<persistence-unit-ref>"));
/*     */       try
/*     */       {
/*  70 */         addPUDependency(ref.getPersistenceUnitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/*  74 */         throw new RuntimeException("Illegal <persistence-unit-ref> of " + ref.getPersistenceUnitRefName() + " :" + e.getMessage());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*     */   {
/*  82 */     PersistenceUnits resources = (PersistenceUnits)container.getAnnotation(PersistenceUnits.class, clazz);
/*     */ 
/*  84 */     if (resources != null)
/*     */     {
/*  86 */       for (PersistenceUnit ref : resources.value())
/*     */       {
/*  88 */         handleClassAnnotation(ref, container, clazz);
/*     */       }
/*     */     }
/*  91 */     PersistenceUnit pu = (PersistenceUnit)container.getAnnotation(PersistenceUnit.class, clazz);
/*  92 */     if (pu != null)
/*     */     {
/*  94 */       handleClassAnnotation(pu, container, clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void handleClassAnnotation(PersistenceUnit ref, InjectionContainer container, Class<?> clazz)
/*     */   {
/* 100 */     String encName = ref.name();
/* 101 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 103 */       throw new RuntimeException("JBoss requires name() for class level @PersistenceUnit");
/*     */     }
/* 105 */     encName = "env/" + encName;
/* 106 */     if (container.getEncInjectors().containsKey(encName)) return;
/* 107 */     container.getEncInjectors().put(encName, new PuEncInjector(encName, null, ref.unitName(), "@PersistenceUnit"));
/*     */     try
/*     */     {
/* 110 */       addPUDependency(ref.unitName(), container);
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/* 114 */       throw new RuntimeException("Illegal @PersistenceUnit on " + clazz.getName() + " of unitname " + ref.unitName() + " :" + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void addPUDependency(String unitName, InjectionContainer container) throws NameNotFoundException
/*     */   {
/* 120 */     PersistenceUnitDeployment deployment = null;
/*     */ 
/* 122 */     deployment = container.getPersistenceUnitDeployment(unitName);
/* 123 */     if (deployment != null)
/*     */     {
/* 125 */       container.getDependencyPolicy().addDependency(deployment.getKernelName());
/* 126 */       log.debug("***** adding PU dependency from located persistence unit: " + deployment.getKernelName());
/* 127 */       return;
/*     */     }
/*     */ 
/* 131 */     log.debug("******* could not find PU dependency so adding a default: " + PersistenceUnitDeployment.getDefaultKernelName(unitName));
/* 132 */     container.getDependencyPolicy().addDependency(PersistenceUnitDeployment.getDefaultKernelName(unitName));
/*     */   }
/*     */ 
/*     */   public static ManagedEntityManagerFactory getManagedEntityManagerFactory(InjectionContainer container, String unitName)
/*     */     throws NameNotFoundException
/*     */   {
/* 139 */     PersistenceUnitDeployment deployment = container.getPersistenceUnitDeployment(unitName);
/*     */     ManagedEntityManagerFactory factory;
/* 140 */     if (deployment != null)
/*     */     {
/* 142 */       factory = deployment.getManagedFactory();
/*     */     }
/*     */     else
/*     */     {
/* 146 */       throw new NameNotFoundException("Unable to find persistence unit: " + unitName + " for deployment: " + container.getIdentifier());
/*     */     }
/*     */     ManagedEntityManagerFactory factory;
/* 148 */     return factory;
/*     */   }
/*     */ 
/*     */   public static EntityManagerFactory getEntityManagerFactory(PersistenceUnit ref, InjectionContainer container)
/*     */     throws NameNotFoundException
/*     */   {
/* 154 */     return getEntityManagerFactory(ref.unitName(), container);
/*     */   }
/*     */ 
/*     */   public static Object getFactory(Class<?> type, String unitName, InjectionContainer container) throws NameNotFoundException
/*     */   {
/* 159 */     if ((type != null) && (type.getName().equals(SessionFactory.class.getName())))
/* 160 */       return getSessionFactory(unitName, container);
/* 161 */     return getEntityManagerFactory(unitName, container);
/*     */   }
/*     */ 
/*     */   public static EntityManagerFactory getEntityManagerFactory(String unitName, InjectionContainer container)
/*     */     throws NameNotFoundException
/*     */   {
/* 167 */     PersistenceUnitDeployment deployment = container.getPersistenceUnitDeployment(unitName);
/*     */     ManagedEntityManagerFactory managedFactory;
/* 168 */     if (deployment != null)
/*     */     {
/* 170 */       managedFactory = deployment.getManagedFactory();
/*     */     }
/*     */     else
/*     */     {
/* 174 */       return null;
/*     */     }
/*     */     ManagedEntityManagerFactory managedFactory;
/* 176 */     return new InjectedEntityManagerFactory(managedFactory);
/*     */   }
/*     */ 
/*     */   private static SessionFactory getSessionFactory(String ref, InjectionContainer container)
/*     */     throws NameNotFoundException
/*     */   {
/* 183 */     PersistenceUnitDeployment deployment = container.getPersistenceUnitDeployment(ref);
/*     */     ManagedEntityManagerFactory managedFactory;
/* 184 */     if (deployment != null)
/*     */     {
/* 186 */       managedFactory = deployment.getManagedFactory();
/*     */     }
/*     */     else
/*     */     {
/* 190 */       return null;
/*     */     }
/*     */     ManagedEntityManagerFactory managedFactory;
/* 192 */     return new InjectedSessionFactory(managedFactory);
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 197 */     PersistenceUnit ref = (PersistenceUnit)method.getAnnotation(PersistenceUnit.class);
/* 198 */     if (ref == null) return;
/* 199 */     if (!method.getName().startsWith("set"))
/* 200 */       throw new RuntimeException("@PersistenceUnit can only be used with a set method: " + method);
/* 201 */     String encName = ref.name();
/* 202 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 204 */       encName = InjectionUtil.getEncName(method);
/*     */     }
/*     */     else
/*     */     {
/* 208 */       encName = "env/" + encName;
/*     */     }
/* 210 */     if (!container.getEncInjectors().containsKey(encName))
/*     */     {
/* 212 */       container.getEncInjectors().put(encName, new PuEncInjector(encName, method.getParameterTypes()[0], ref.unitName(), "@PersistenceUnit"));
/*     */       try
/*     */       {
/* 215 */         if (!method.isAnnotationPresent(IgnoreDependency.class)) addPUDependency(ref.unitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 219 */         throw new RuntimeException("Illegal @PersistenceUnit on " + method + " :" + e.getMessage());
/*     */       }
/*     */     }
/*     */ 
/* 223 */     injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 228 */     PersistenceUnit ref = (PersistenceUnit)field.getAnnotation(PersistenceUnit.class);
/* 229 */     if (ref == null) return;
/* 230 */     String encName = ref.name();
/* 231 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 233 */       encName = InjectionUtil.getEncName(field);
/*     */     }
/*     */     else
/*     */     {
/* 237 */       encName = "env/" + encName;
/*     */     }
/* 239 */     if (!container.getEncInjectors().containsKey(encName))
/*     */     {
/* 241 */       container.getEncInjectors().put(encName, new PuEncInjector(encName, field.getType(), ref.unitName(), "@PersistenceUnit"));
/*     */       try
/*     */       {
/* 244 */         if (!field.isAnnotationPresent(IgnoreDependency.class)) addPUDependency(ref.unitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 248 */         throw new RuntimeException("Illegal @PersistenceUnit on " + field + " :" + e.getMessage());
/*     */       }
/*     */     }
/*     */ 
/* 252 */     injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.PersistenceUnitHandler
 * JD-Core Version:    0.6.0
 */