/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.AccessibleObject;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.util.Map;
/*     */ import javax.naming.NameNotFoundException;
/*     */ import javax.persistence.PersistenceContext;
/*     */ import javax.persistence.PersistenceContextType;
/*     */ import javax.persistence.PersistenceContexts;
/*     */ import org.jboss.ejb3.annotation.IgnoreDependency;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.metadata.javaee.spec.Environment;
/*     */ import org.jboss.metadata.javaee.spec.PersistenceContextReferenceMetaData;
/*     */ import org.jboss.metadata.javaee.spec.RemoteEnvironment;
/*     */ 
/*     */ public class PersistenceContextHandler<X extends RemoteEnvironment>
/*     */   implements InjectionHandler<X>
/*     */ {
/*  50 */   private static final Logger log = Logger.getLogger(PersistenceContextHandler.class);
/*     */ 
/*     */   public void loadXml(X xml, InjectionContainer container)
/*     */   {
/*  55 */     if (xml == null) return;
/*  56 */     if (!(xml instanceof Environment)) return;
/*  57 */     Environment env = (Environment)xml;
/*  58 */     if (env.getPersistenceContextRefs() == null) return;
/*  59 */     for (PersistenceContextReferenceMetaData ref : env.getPersistenceContextRefs())
/*     */     {
/*  61 */       String encName = "env/" + ref.getPersistenceContextRefName();
/*     */ 
/*  64 */       Class injectionType = InjectionUtil.injectionTarget(encName, ref, container, container.getEncInjections());
/*     */ 
/*  66 */       if (container.getEncInjectors().containsKey(encName)) {
/*     */         continue;
/*     */       }
/*  69 */       String error = "unable to load <persistence-context-ref> for unitName: " + ref.getPersistenceUnitName() + " <ref-name>: " + ref.getPersistenceContextRefName();
/*     */ 
/*  71 */       PersistenceContextType type = ref.getPersistenceContextType();
/*  72 */       String unitName = ref.getPersistenceUnitName();
/*  73 */       container.getEncInjectors().put(encName, new PcEncInjector(encName, unitName, type, injectionType, error));
/*     */       try
/*     */       {
/*  76 */         PersistenceUnitHandler.addPUDependency(ref.getPersistenceUnitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/*  80 */         throw new RuntimeException("Illegal <persistence-context-ref> of " + ref.getPersistenceContextRefName() + " :" + e.getMessage());
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleClassAnnotations(Class<?> clazz, InjectionContainer container)
/*     */   {
/*  87 */     PersistenceContexts resources = (PersistenceContexts)container.getAnnotation(PersistenceContexts.class, clazz);
/*  88 */     if (resources != null)
/*     */     {
/*  90 */       for (PersistenceContext ref : resources.value())
/*     */       {
/*  92 */         loadPersistenceContextClassAnnotation(ref, container, clazz);
/*     */       }
/*     */     }
/*  95 */     PersistenceContext pc = (PersistenceContext)container.getAnnotation(PersistenceContext.class, clazz);
/*     */ 
/*  97 */     if (pc != null)
/*     */     {
/*  99 */       loadPersistenceContextClassAnnotation(pc, container, clazz);
/*     */     }
/*     */   }
/*     */ 
/*     */   private static void loadPersistenceContextClassAnnotation(PersistenceContext ref, InjectionContainer container, Class<?> clazz)
/*     */   {
/* 107 */     String encName = ref.name();
/* 108 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 110 */       throw new RuntimeException("JBoss requires name() for class level @PersistenceContext");
/*     */     }
/*     */ 
/* 113 */     encName = "env/" + ref.name();
/* 114 */     if (container.getEncInjectors().containsKey(encName)) return;
/*     */ 
/* 116 */     String error = "Unable to load class-level @PersistenceContext(" + ref.unitName() + ") on " + container.getIdentifier();
/*     */ 
/* 118 */     container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), null, error));
/*     */     try
/*     */     {
/* 121 */       PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
/*     */     }
/*     */     catch (NameNotFoundException e)
/*     */     {
/* 125 */       throw new RuntimeException("Illegal @PersistenceUnit on " + clazz.getName() + " of unitname " + ref.unitName() + " :" + e.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   public void handleMethodAnnotations(Method method, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 131 */     PersistenceContext ref = (PersistenceContext)method.getAnnotation(PersistenceContext.class);
/* 132 */     if (ref == null) return;
/* 133 */     if (!method.getName().startsWith("set")) {
/* 134 */       throw new RuntimeException("@PersistenceUnit can only be used with a set method: " + method);
/*     */     }
/* 136 */     String encName = ref.name();
/* 137 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 139 */       encName = InjectionUtil.getEncName(method);
/*     */     }
/*     */     else
/*     */     {
/* 143 */       encName = "env/" + ref.name();
/*     */     }
/* 145 */     if (!container.getEncInjectors().containsKey(encName))
/*     */     {
/*     */       try
/*     */       {
/* 149 */         if (!method.isAnnotationPresent(IgnoreDependency.class)) PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 153 */         throw new RuntimeException("Illegal @PersistenceUnit on " + method + " :" + e.getMessage());
/*     */       }
/* 155 */       String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getIdentifier() + " failed to inject on method " + method.toString();
/*     */ 
/* 159 */       container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), method.getParameterTypes()[0], error));
/*     */     }
/* 161 */     injectors.put(method, new JndiMethodInjector(method, encName, container.getEnc()));
/*     */   }
/*     */ 
/*     */   public void handleFieldAnnotations(Field field, InjectionContainer container, Map<AccessibleObject, Injector> injectors)
/*     */   {
/* 167 */     PersistenceContext ref = (PersistenceContext)field.getAnnotation(PersistenceContext.class);
/* 168 */     if (ref == null) return;
/*     */ 
/* 170 */     String encName = ref.name();
/* 171 */     if ((encName == null) || (encName.equals("")))
/*     */     {
/* 173 */       encName = InjectionUtil.getEncName(field);
/*     */     }
/*     */     else
/*     */     {
/* 177 */       encName = "env/" + ref.name();
/*     */     }
/* 179 */     if (!container.getEncInjectors().containsKey(encName))
/*     */     {
/*     */       try
/*     */       {
/* 183 */         if (!field.isAnnotationPresent(IgnoreDependency.class)) PersistenceUnitHandler.addPUDependency(ref.unitName(), container);
/*     */       }
/*     */       catch (NameNotFoundException e)
/*     */       {
/* 187 */         throw new RuntimeException("Illegal @PersistenceUnit on " + field + " :" + e.getMessage());
/*     */       }
/* 189 */       String error = "@PersistenceContext(name='" + encName + "',unitName='" + ref.unitName() + "') on EJB: " + container.getIdentifier() + " failed to inject on field " + field.toString();
/*     */ 
/* 193 */       container.getEncInjectors().put(encName, new PcEncInjector(encName, ref.unitName(), ref.type(), field.getType(), error));
/*     */     }
/* 195 */     injectors.put(field, new JndiFieldInjector(field, encName, container.getEnc()));
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.PersistenceContextHandler
 * JD-Core Version:    0.6.0
 */