/*     */ package org.jboss.injection;
/*     */ 
/*     */ import java.lang.reflect.Field;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.NamingException;
/*     */ import org.jboss.ejb3.BeanContext;
/*     */ import org.jboss.ejb3.JndiUtil;
/*     */ import org.jboss.logging.Logger;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class JndiFieldInjector
/*     */   implements Injector, PojoInjector
/*     */ {
/*  42 */   private static final Logger log = Logger.getLogger(JndiFieldInjector.class);
/*     */   private Field field;
/*     */   private String jndiName;
/*     */   private Context ctx;
/*     */ 
/*     */   public JndiFieldInjector(Field field, String jndiName, Context ctx)
/*     */   {
/*  50 */     this.field = field;
/*  51 */     this.field.setAccessible(true);
/*  52 */     this.jndiName = jndiName;
/*  53 */     this.ctx = ctx;
/*     */   }
/*     */ 
/*     */   public JndiFieldInjector(Field field, Context ctx)
/*     */   {
/*  58 */     this(field, field.getName(), ctx);
/*     */   }
/*     */ 
/*     */   public void inject(BeanContext bctx)
/*     */   {
/*  63 */     inject(bctx, bctx.getInstance());
/*     */   }
/*     */ 
/*     */   public Class getInjectionClass()
/*     */   {
/*  68 */     return this.field.getType();
/*     */   }
/*     */ 
/*     */   public Field getField()
/*     */   {
/*  73 */     return this.field;
/*     */   }
/*     */ 
/*     */   protected Object lookup(String jndiName, Class field)
/*     */   {
/*  78 */     Object dependency = null;
/*     */     try
/*     */     {
/*  82 */       dependency = JndiUtil.lookup(this.ctx, jndiName);
/*     */     }
/*     */     catch (NamingException e)
/*     */     {
/*  86 */       e.printStackTrace();
/*  87 */       throw new RuntimeException("Unable to inject jndi dependency: " + jndiName + " into field " + field, e);
/*     */     }
/*     */ 
/*  90 */     return dependency;
/*     */   }
/*     */ 
/*     */   public void inject(BeanContext bctx, Object instance)
/*     */   {
/*  95 */     inject(instance);
/*     */   }
/*     */ 
/*     */   public void inject(Object instance)
/*     */   {
/* 101 */     Object dependency = lookup(this.jndiName, this.field.getType());
/*     */     try
/*     */     {
/* 105 */       this.field.set(instance, dependency);
/*     */     }
/*     */     catch (IllegalArgumentException e)
/*     */     {
/* 109 */       String type = "UNKNOWN";
/* 110 */       String interfaces = "";
/* 111 */       if (dependency != null)
/*     */       {
/* 113 */         type = dependency.getClass().getName();
/* 114 */         Class[] intfs = dependency.getClass().getInterfaces();
/* 115 */         for (Class intf : intfs) interfaces = interfaces + ", " + intf.getName();
/*     */       }
/* 117 */       throw new RuntimeException("Non matching type for inject of field: " + this.field + " for type: " + type + " of jndiName " + this.jndiName + "\nintfs: " + interfaces, e);
/*     */     }
/*     */     catch (IllegalAccessException e)
/*     */     {
/* 121 */       throw new RuntimeException(e);
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 127 */     return super.toString() + "{field=" + this.field + ",jndiName=" + this.jndiName + "}";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.JndiFieldInjector
 * JD-Core Version:    0.6.0
 */