/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.lang.reflect.Field;
/*    */ import org.jboss.ejb3.BeanContext;
/*    */ import org.jboss.logging.Logger;
/*    */ 
/*    */ public class EntityManagerFactoryFieldInjector
/*    */   implements Injector, PojoInjector
/*    */ {
/* 36 */   private static final Logger log = Logger.getLogger(EntityManagerFactoryFieldInjector.class);
/*    */   private Field field;
/*    */   private Object factory;
/*    */ 
/*    */   public EntityManagerFactoryFieldInjector(Field field, Object factory)
/*    */   {
/* 42 */     this.field = field;
/* 43 */     this.field.setAccessible(true);
/* 44 */     this.factory = factory;
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx)
/*    */   {
/* 49 */     inject(ctx, ctx.getInstance());
/*    */   }
/*    */ 
/*    */   public void inject(BeanContext ctx, Object instance)
/*    */   {
/* 54 */     inject(instance);
/*    */   }
/*    */ 
/*    */   public void inject(Object instance)
/*    */   {
/*    */     try
/*    */     {
/* 61 */       this.field.set(instance, this.factory);
/*    */     }
/*    */     catch (IllegalAccessException e)
/*    */     {
/* 65 */       throw new RuntimeException(e);
/*    */     }
/*    */     catch (IllegalArgumentException e)
/*    */     {
/* 69 */       throw new RuntimeException("Failed in setting EntityManager on setter field: " + this.field.toString());
/*    */     }
/*    */   }
/*    */ 
/*    */   public Class getInjectionClass()
/*    */   {
/* 75 */     return this.field.getType();
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EntityManagerFactoryFieldInjector
 * JD-Core Version:    0.6.0
 */