/*    */ package org.jboss.injection;
/*    */ 
/*    */ import java.util.Collection;
/*    */ import org.jboss.logging.Logger;
/*    */ import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
/*    */ import org.jboss.metadata.javaee.spec.Environment;
/*    */ 
/*    */ public class EJBHandler<X extends Environment> extends EJBRemoteHandler<X>
/*    */ {
/* 40 */   private static final Logger log = Logger.getLogger(EJBHandler.class);
/*    */ 
/*    */   public void loadXml(X xml, InjectionContainer container)
/*    */   {
/* 44 */     super.loadXml(xml, container);
/* 45 */     if (xml != null)
/*    */     {
/* 47 */       if (xml.getEjbLocalReferences() != null) loadEjbLocalXml(xml.getEjbLocalReferences(), container);
/*    */     }
/*    */   }
/*    */ 
/*    */   protected void loadEjbLocalXml(Collection<EJBLocalReferenceMetaData> refs, InjectionContainer container)
/*    */   {
/* 53 */     for (EJBLocalReferenceMetaData ref : refs)
/*    */     {
/* 55 */       String interfaceName = ref.getLocal();
/* 56 */       String errorType = "<ejb-local-ref>";
/*    */ 
/* 58 */       ejbRefXml(ref, interfaceName, container, errorType);
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.injection.EJBHandler
 * JD-Core Version:    0.6.0
 */