/*      */ package org.jboss.iiop.rmi.marshal;
/*      */ 
/*      */ import java.io.Externalizable;
/*      */ import java.io.Serializable;
/*      */ import java.lang.reflect.InvocationTargetException;
/*      */ import java.lang.reflect.Method;
/*      */ import javax.rmi.CORBA.Util;
/*      */ import javax.rmi.PortableRemoteObject;
/*      */ import org.jboss.iiop.rmi.RmiIdlUtil;
/*      */ import org.omg.CORBA.portable.IDLEntity;
/*      */ 
/*      */ public class CDRStream
/*      */ {
/*      */   public static String abbrevFor(Class clz)
/*      */   {
/*   91 */     if (clz == Boolean.TYPE) {
/*   92 */       return "Z";
/*      */     }
/*   94 */     if (clz == Byte.TYPE) {
/*   95 */       return "B";
/*      */     }
/*   97 */     if (clz == Character.TYPE) {
/*   98 */       return "C";
/*      */     }
/*  100 */     if (clz == Double.TYPE) {
/*  101 */       return "D";
/*      */     }
/*  103 */     if (clz == Float.TYPE) {
/*  104 */       return "F";
/*      */     }
/*  106 */     if (clz == Integer.TYPE) {
/*  107 */       return "I";
/*      */     }
/*  109 */     if (clz == Long.TYPE) {
/*  110 */       return "J";
/*      */     }
/*  112 */     if (clz == Short.TYPE) {
/*  113 */       return "S";
/*      */     }
/*  115 */     if (clz == Void.TYPE) {
/*  116 */       return "V";
/*      */     }
/*  118 */     if (clz == String.class) {
/*  119 */       return "G";
/*      */     }
/*  121 */     if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
/*  122 */       return "R" + clz.getName();
/*      */     }
/*  124 */     if (clz == org.omg.CORBA.Object.class) {
/*  125 */       return "M";
/*      */     }
/*  127 */     if (org.omg.CORBA.Object.class.isAssignableFrom(clz)) {
/*  128 */       return "N" + clz.getName();
/*      */     }
/*  130 */     if (IDLEntity.class.isAssignableFrom(clz)) {
/*  131 */       return "L" + clz.getName();
/*      */     }
/*  133 */     if (clz == Serializable.class) {
/*  134 */       return "E";
/*      */     }
/*  136 */     if (RmiIdlUtil.isAbstractInterface(clz)) {
/*  137 */       return "A";
/*      */     }
/*  139 */     if (Serializable.class.isAssignableFrom(clz)) {
/*  140 */       return "L" + clz.getName();
/*      */     }
/*  142 */     if (Externalizable.class.isAssignableFrom(clz)) {
/*  143 */       return "X";
/*      */     }
/*  145 */     if (clz == java.lang.Object.class) {
/*  146 */       return "O";
/*      */     }
/*      */ 
/*  149 */     return "L" + clz.getName();
/*      */   }
/*      */ 
/*      */   public static CDRStreamReader readerFor(String s, ClassLoader cl)
/*      */   {
/*  159 */     switch (s.charAt(0))
/*      */     {
/*      */     case 'A':
/*  162 */       return AbstractInterfaceReader.instance;
/*      */     case 'B':
/*  164 */       return ByteReader.instance;
/*      */     case 'C':
/*  166 */       return CharReader.instance;
/*      */     case 'D':
/*  168 */       return DoubleReader.instance;
/*      */     case 'E':
/*  170 */       return SerializableReader.instance;
/*      */     case 'F':
/*  172 */       return FloatReader.instance;
/*      */     case 'G':
/*  174 */       return StringReader.instance;
/*      */     case 'I':
/*  176 */       return IntReader.instance;
/*      */     case 'J':
/*  178 */       return LongReader.instance;
/*      */     case 'L':
/*      */       try
/*      */       {
/*  183 */         return new ValuetypeReader(Class.forName(s.substring(1), true, cl));
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  188 */         throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
/*      */       }
/*      */ 
/*      */     case 'M':
/*  192 */       return CorbaObjectReader.instance;
/*      */     case 'N':
/*      */       try {
/*  195 */         return new IdlInterfaceReader(cl.loadClass(s.substring(1)));
/*      */       }
/*      */       catch (ClassNotFoundException e) {
/*  198 */         throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
/*      */       }
/*      */ 
/*      */     case 'O':
/*  202 */       return ObjectReader.instance;
/*      */     case 'R':
/*      */       try {
/*  205 */         return new RemoteReader(cl.loadClass(s.substring(1)));
/*      */       }
/*      */       catch (ClassNotFoundException e) {
/*  208 */         throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
/*      */       }
/*      */ 
/*      */     case 'S':
/*  212 */       return ShortReader.instance;
/*      */     case 'V':
/*  214 */       return null;
/*      */     case 'X':
/*  216 */       return ExternalizableReader.instance;
/*      */     case 'Z':
/*  218 */       return BooleanReader.instance;
/*      */     case 'H':
/*      */     case 'K':
/*      */     case 'P':
/*      */     case 'Q':
/*      */     case 'T':
/*      */     case 'U':
/*      */     case 'W':
/*  220 */     case 'Y': } return null;
/*      */   }
/*      */ 
/*      */   public static CDRStreamWriter writerFor(String s, ClassLoader cl)
/*      */   {
/*  230 */     switch (s.charAt(0))
/*      */     {
/*      */     case 'A':
/*  233 */       return AbstractInterfaceWriter.instance;
/*      */     case 'B':
/*  235 */       return ByteWriter.instance;
/*      */     case 'C':
/*  237 */       return CharWriter.instance;
/*      */     case 'D':
/*  239 */       return DoubleWriter.instance;
/*      */     case 'E':
/*  241 */       return SerializableWriter.instance;
/*      */     case 'F':
/*  243 */       return FloatWriter.instance;
/*      */     case 'G':
/*  245 */       return StringWriter.instance;
/*      */     case 'I':
/*  247 */       return IntWriter.instance;
/*      */     case 'J':
/*  249 */       return LongWriter.instance;
/*      */     case 'L':
/*      */       try
/*      */       {
/*  254 */         return new ValuetypeWriter(Class.forName(s.substring(1), true, cl));
/*      */       }
/*      */       catch (ClassNotFoundException e)
/*      */       {
/*  259 */         throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
/*      */       }
/*      */ 
/*      */     case 'M':
/*  263 */       return CorbaObjectWriter.instance;
/*      */     case 'N':
/*      */       try {
/*  266 */         return new IdlInterfaceWriter(cl.loadClass(s.substring(1)));
/*      */       }
/*      */       catch (ClassNotFoundException e) {
/*  269 */         throw new RuntimeException("Error loading class " + s.substring(1) + ": " + e);
/*      */       }
/*      */ 
/*      */     case 'O':
/*  273 */       return ObjectWriter.instance;
/*      */     case 'R':
/*  275 */       return RemoteWriter.instance;
/*      */     case 'S':
/*  277 */       return ShortWriter.instance;
/*      */     case 'V':
/*  279 */       return null;
/*      */     case 'X':
/*  281 */       return ExternalizableWriter.instance;
/*      */     case 'Z':
/*  283 */       return BooleanWriter.instance;
/*      */     case 'H':
/*      */     case 'K':
/*      */     case 'P':
/*      */     case 'Q':
/*      */     case 'T':
/*      */     case 'U':
/*      */     case 'W':
/*  285 */     case 'Y': } return null;
/*      */   }
/*      */ 
/*      */   public static CDRStreamReader readerFor(Class clz)
/*      */   {
/*  294 */     if (clz == Boolean.TYPE) {
/*  295 */       return BooleanReader.instance;
/*      */     }
/*  297 */     if (clz == Byte.TYPE) {
/*  298 */       return ByteReader.instance;
/*      */     }
/*  300 */     if (clz == Character.TYPE) {
/*  301 */       return CharReader.instance;
/*      */     }
/*  303 */     if (clz == Double.TYPE) {
/*  304 */       return DoubleReader.instance;
/*      */     }
/*  306 */     if (clz == Float.TYPE) {
/*  307 */       return FloatReader.instance;
/*      */     }
/*  309 */     if (clz == Integer.TYPE) {
/*  310 */       return IntReader.instance;
/*      */     }
/*  312 */     if (clz == Long.TYPE) {
/*  313 */       return LongReader.instance;
/*      */     }
/*  315 */     if (clz == Short.TYPE) {
/*  316 */       return ShortReader.instance;
/*      */     }
/*  318 */     if (clz == Void.TYPE) {
/*  319 */       return null;
/*      */     }
/*  321 */     if (clz == String.class) {
/*  322 */       return StringReader.instance;
/*      */     }
/*  324 */     if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
/*  325 */       return new RemoteReader(clz);
/*      */     }
/*  327 */     if (clz == org.omg.CORBA.Object.class) {
/*  328 */       return CorbaObjectReader.instance;
/*      */     }
/*  330 */     if (org.omg.CORBA.Object.class.isAssignableFrom(clz)) {
/*  331 */       return new IdlInterfaceReader(clz);
/*      */     }
/*  333 */     if (IDLEntity.class.isAssignableFrom(clz)) {
/*  334 */       return new ValuetypeReader(clz);
/*      */     }
/*  336 */     if (clz == Serializable.class) {
/*  337 */       return SerializableReader.instance;
/*      */     }
/*  339 */     if (RmiIdlUtil.isAbstractInterface(clz)) {
/*  340 */       return AbstractInterfaceReader.instance;
/*      */     }
/*  342 */     if (Serializable.class.isAssignableFrom(clz)) {
/*  343 */       return new ValuetypeReader(clz);
/*      */     }
/*  345 */     if (Externalizable.class.isAssignableFrom(clz)) {
/*  346 */       return ExternalizableReader.instance;
/*      */     }
/*  348 */     if (clz == java.lang.Object.class) {
/*  349 */       return ObjectReader.instance;
/*      */     }
/*      */ 
/*  352 */     return new ValuetypeReader(clz);
/*      */   }
/*      */ 
/*      */   public static CDRStreamWriter writerFor(Class clz)
/*      */   {
/*  361 */     if (clz == Boolean.TYPE) {
/*  362 */       return BooleanWriter.instance;
/*      */     }
/*  364 */     if (clz == Byte.TYPE) {
/*  365 */       return ByteWriter.instance;
/*      */     }
/*  367 */     if (clz == Character.TYPE) {
/*  368 */       return CharWriter.instance;
/*      */     }
/*  370 */     if (clz == Double.TYPE) {
/*  371 */       return DoubleWriter.instance;
/*      */     }
/*  373 */     if (clz == Float.TYPE) {
/*  374 */       return FloatWriter.instance;
/*      */     }
/*  376 */     if (clz == Integer.TYPE) {
/*  377 */       return IntWriter.instance;
/*      */     }
/*  379 */     if (clz == Long.TYPE) {
/*  380 */       return LongWriter.instance;
/*      */     }
/*  382 */     if (clz == Short.TYPE) {
/*  383 */       return ShortWriter.instance;
/*      */     }
/*  385 */     if (clz == String.class) {
/*  386 */       return StringWriter.instance;
/*      */     }
/*  388 */     if (clz == Void.TYPE) {
/*  389 */       return null;
/*      */     }
/*  391 */     if (RmiIdlUtil.isRMIIDLRemoteInterface(clz)) {
/*  392 */       return RemoteWriter.instance;
/*      */     }
/*  394 */     if (clz == org.omg.CORBA.Object.class) {
/*  395 */       return CorbaObjectWriter.instance;
/*      */     }
/*  397 */     if (org.omg.CORBA.Object.class.isAssignableFrom(clz)) {
/*  398 */       return new IdlInterfaceWriter(clz);
/*      */     }
/*  400 */     if (IDLEntity.class.isAssignableFrom(clz)) {
/*  401 */       return new ValuetypeWriter(clz);
/*      */     }
/*  403 */     if (clz == Serializable.class) {
/*  404 */       return SerializableWriter.instance;
/*      */     }
/*  406 */     if (RmiIdlUtil.isAbstractInterface(clz)) {
/*  407 */       return AbstractInterfaceWriter.instance;
/*      */     }
/*  409 */     if (Serializable.class.isAssignableFrom(clz)) {
/*  410 */       return new ValuetypeWriter(clz);
/*      */     }
/*  412 */     if (Externalizable.class.isAssignableFrom(clz)) {
/*  413 */       return ExternalizableWriter.instance;
/*      */     }
/*  415 */     if (clz == java.lang.Object.class) {
/*  416 */       return ObjectWriter.instance;
/*      */     }
/*      */ 
/*  419 */     return new ValuetypeWriter(clz);
/*      */   }
/*      */ 
/*      */   private static final class ValuetypeWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*      */     private Class clz;
/*      */ 
/*      */     ValuetypeWriter(Class clz)
/*      */     {
/* 1085 */       this.clz = clz;
/*      */     }
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/* 1090 */       out.write_value((Serializable)obj, this.clz);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class AbstractInterfaceWriter
/*      */     implements CDRStreamWriter
/*      */   {
/* 1062 */     static final CDRStreamWriter instance = new AbstractInterfaceWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/* 1068 */       out.write_abstract_interface(obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class IdlInterfaceWriter
/*      */     implements CDRStreamWriter
/*      */   {
/* 1012 */     private Method writeMethod = null;
/*      */ 
/*      */     IdlInterfaceWriter(Class clz)
/*      */     {
/* 1016 */       String helperClassName = clz.getName() + "Helper";
/*      */       try
/*      */       {
/* 1019 */         Class helperClass = clz.getClassLoader().loadClass(helperClassName);
/*      */ 
/* 1021 */         Class[] paramTypes = { org.omg.CORBA.portable.OutputStream.class, clz };
/*      */ 
/* 1025 */         this.writeMethod = helperClass.getMethod("write", paramTypes);
/*      */       }
/*      */       catch (ClassNotFoundException e) {
/* 1028 */         throw new RuntimeException("Error loading class " + helperClassName + ": " + e);
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/* 1032 */         throw new RuntimeException("No write method in helper class " + helperClassName + ": " + e);
/*      */       }
/*      */     }
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*      */       try
/*      */       {
/* 1040 */         this.writeMethod.invoke(null, new java.lang.Object[] { out, obj });
/*      */       }
/*      */       catch (IllegalAccessException e) {
/* 1043 */         throw new RuntimeException("Internal error: " + e);
/*      */       }
/*      */       catch (InvocationTargetException e) {
/* 1046 */         throw new RuntimeException("Exception marshaling CORBA object: " + e.getTargetException());
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class CorbaObjectWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  991 */     static final CDRStreamWriter instance = new CorbaObjectWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  997 */       out.write_Object((org.omg.CORBA.Object)obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ExternalizableWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  974 */     static final CDRStreamWriter instance = new ExternalizableWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  980 */       Util.writeAny(out, (Externalizable)obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class SerializableWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  957 */     static final CDRStreamWriter instance = new SerializableWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  963 */       Util.writeAny(out, (Serializable)obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ObjectWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  940 */     static final CDRStreamWriter instance = new ObjectWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  946 */       Util.writeAny(out, obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class RemoteWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  923 */     static final CDRStreamWriter instance = new RemoteWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  929 */       out.write_Object((org.omg.CORBA.Object)obj);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class StringWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  906 */     static final CDRStreamWriter instance = new StringWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  912 */       out.write_value((String)obj, String.class);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ShortWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  889 */     static final CDRStreamWriter instance = new ShortWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  895 */       out.write_short(((Short)obj).shortValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class LongWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  872 */     static final CDRStreamWriter instance = new LongWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  878 */       out.write_longlong(((Long)obj).longValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class IntWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  855 */     static final CDRStreamWriter instance = new IntWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  861 */       out.write_long(((Integer)obj).intValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class FloatWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  838 */     static final CDRStreamWriter instance = new FloatWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  844 */       out.write_float(((Float)obj).floatValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class DoubleWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  821 */     static final CDRStreamWriter instance = new DoubleWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  827 */       out.write_double(((Double)obj).doubleValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class CharWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  804 */     static final CDRStreamWriter instance = new CharWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  810 */       out.write_wchar(((Character)obj).charValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ByteWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  786 */     static final CDRStreamWriter instance = new ByteWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  792 */       out.write_octet(((Byte)obj).byteValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class BooleanWriter
/*      */     implements CDRStreamWriter
/*      */   {
/*  769 */     static final CDRStreamWriter instance = new BooleanWriter();
/*      */ 
/*      */     public void write(org.omg.CORBA_2_3.portable.OutputStream out, java.lang.Object obj)
/*      */     {
/*  775 */       out.write_boolean(((Boolean)obj).booleanValue());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ValuetypeReader
/*      */     implements CDRStreamReader
/*      */   {
/*      */     private Class clz;
/*      */ 
/*      */     ValuetypeReader(Class clz)
/*      */     {
/*  753 */       this.clz = clz;
/*      */     }
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  758 */       return in.read_value(this.clz);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class AbstractInterfaceReader
/*      */     implements CDRStreamReader
/*      */   {
/*  731 */     static final CDRStreamReader instance = new AbstractInterfaceReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  737 */       return in.read_abstract_interface();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class IdlInterfaceReader
/*      */     implements CDRStreamReader
/*      */   {
/*  681 */     private static Class[] paramTypes = { org.omg.CORBA.portable.InputStream.class };
/*      */ 
/*  685 */     private Method readMethod = null;
/*      */ 
/*      */     IdlInterfaceReader(Class clz)
/*      */     {
/*  689 */       String helperClassName = clz.getName() + "Helper";
/*      */       try
/*      */       {
/*  692 */         Class helperClass = clz.getClassLoader().loadClass(helperClassName);
/*      */ 
/*  694 */         this.readMethod = helperClass.getMethod("read", paramTypes);
/*      */       }
/*      */       catch (ClassNotFoundException e) {
/*  697 */         throw new RuntimeException("Error loading class " + helperClassName + ": " + e);
/*      */       }
/*      */       catch (NoSuchMethodException e)
/*      */       {
/*  701 */         throw new RuntimeException("No read method in helper class " + helperClassName + ": " + e);
/*      */       }
/*      */     }
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*      */       try
/*      */       {
/*  709 */         return this.readMethod.invoke(null, new java.lang.Object[] { in });
/*      */       }
/*      */       catch (IllegalAccessException e) {
/*  712 */         throw new RuntimeException("Internal error: " + e);
/*      */       } catch (InvocationTargetException e) {
/*      */       }
/*  715 */       throw new RuntimeException("Exception unmarshaling CORBA object: " + e.getTargetException());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class CorbaObjectReader
/*      */     implements CDRStreamReader
/*      */   {
/*  661 */     static final CDRStreamReader instance = new CorbaObjectReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  667 */       return in.read_Object();
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ExternalizableReader
/*      */     implements CDRStreamReader
/*      */   {
/*  644 */     static final CDRStreamReader instance = new ExternalizableReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  650 */       return (Externalizable)Util.readAny(in);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class SerializableReader
/*      */     implements CDRStreamReader
/*      */   {
/*  627 */     static final CDRStreamReader instance = new SerializableReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  633 */       return (Serializable)Util.readAny(in);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ObjectReader
/*      */     implements CDRStreamReader
/*      */   {
/*  610 */     static final CDRStreamReader instance = new ObjectReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  616 */       return Util.readAny(in);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class RemoteReader
/*      */     implements CDRStreamReader
/*      */   {
/*      */     private Class clz;
/*      */ 
/*      */     RemoteReader(Class clz)
/*      */     {
/*  592 */       this.clz = clz;
/*      */     }
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  599 */       return PortableRemoteObject.narrow(in.read_Object(), this.clz);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class StringReader
/*      */     implements CDRStreamReader
/*      */   {
/*  570 */     static final CDRStreamReader instance = new StringReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  576 */       return in.read_value(String.class);
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ShortReader
/*      */     implements CDRStreamReader
/*      */   {
/*  553 */     static final CDRStreamReader instance = new ShortReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  559 */       return new Short(in.read_short());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class LongReader
/*      */     implements CDRStreamReader
/*      */   {
/*  536 */     static final CDRStreamReader instance = new LongReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  542 */       return new Long(in.read_longlong());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class IntReader
/*      */     implements CDRStreamReader
/*      */   {
/*  519 */     static final CDRStreamReader instance = new IntReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  525 */       return new Integer(in.read_long());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class FloatReader
/*      */     implements CDRStreamReader
/*      */   {
/*  502 */     static final CDRStreamReader instance = new FloatReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  508 */       return new Float(in.read_float());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class DoubleReader
/*      */     implements CDRStreamReader
/*      */   {
/*  485 */     static final CDRStreamReader instance = new DoubleReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  491 */       return new Double(in.read_double());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class CharReader
/*      */     implements CDRStreamReader
/*      */   {
/*  468 */     static final CDRStreamReader instance = new CharReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  474 */       return new Character(in.read_wchar());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class ByteReader
/*      */     implements CDRStreamReader
/*      */   {
/*  451 */     static final CDRStreamReader instance = new ByteReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  457 */       return new Byte(in.read_octet());
/*      */     }
/*      */   }
/*      */ 
/*      */   private static final class BooleanReader
/*      */     implements CDRStreamReader
/*      */   {
/*  434 */     static final CDRStreamReader instance = new BooleanReader();
/*      */ 
/*      */     public java.lang.Object read(org.omg.CORBA_2_3.portable.InputStream in)
/*      */     {
/*  440 */       return new Boolean(in.read_boolean());
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.marshal.CDRStream
 * JD-Core Version:    0.6.0
 */