/*      */ package org.jboss.iiop.rmi.ir;
/*      */ 
/*      */ import java.io.Externalizable;
/*      */ import java.io.Serializable;
/*      */ import java.util.ArrayList;
/*      */ import java.util.HashMap;
/*      */ import java.util.List;
/*      */ import java.util.Map;
/*      */ import javax.naming.InitialContext;
/*      */ import javax.naming.NamingException;
/*      */ import javax.rmi.CORBA.ClassDesc;
/*      */ import org.jboss.iiop.rmi.AttributeAnalysis;
/*      */ import org.jboss.iiop.rmi.ConstantAnalysis;
/*      */ import org.jboss.iiop.rmi.ContainerAnalysis;
/*      */ import org.jboss.iiop.rmi.ExceptionAnalysis;
/*      */ import org.jboss.iiop.rmi.InterfaceAnalysis;
/*      */ import org.jboss.iiop.rmi.OperationAnalysis;
/*      */ import org.jboss.iiop.rmi.ParameterAnalysis;
/*      */ import org.jboss.iiop.rmi.RMIIIOPViolationException;
/*      */ import org.jboss.iiop.rmi.RmiIdlUtil;
/*      */ import org.jboss.iiop.rmi.Util;
/*      */ import org.jboss.iiop.rmi.ValueAnalysis;
/*      */ import org.jboss.iiop.rmi.ValueMemberAnalysis;
/*      */ import org.jboss.logging.Logger;
/*      */ import org.omg.CORBA.Any;
/*      */ import org.omg.CORBA.DefinitionKind;
/*      */ import org.omg.CORBA.ExceptionDef;
/*      */ import org.omg.CORBA.ExceptionDefHelper;
/*      */ import org.omg.CORBA.ORB;
/*      */ import org.omg.CORBA.ParameterDescription;
/*      */ import org.omg.CORBA.ParameterMode;
/*      */ import org.omg.CORBA.Repository;
/*      */ import org.omg.CORBA.RepositoryHelper;
/*      */ import org.omg.CORBA.StructMember;
/*      */ import org.omg.CORBA.TCKind;
/*      */ import org.omg.CORBA.TypeCode;
/*      */ import org.omg.PortableServer.POA;
/*      */ 
/*      */ public class InterfaceRepository
/*      */ {
/*      */   private static Map primitiveTypeCodeMap;
/*      */   private static Map constantTypeCodeMap;
/*      */   private static final Logger logger;
/*      */   RepositoryImpl impl;
/*  190 */   private ORB orb = null;
/*      */ 
/*  195 */   private POA poa = null;
/*      */ 
/*  201 */   private Map typeCodeMap = new HashMap(primitiveTypeCodeMap);
/*      */ 
/*  206 */   private Map interfaceMap = new HashMap();
/*      */ 
/*  211 */   private Map valueMap = new HashMap();
/*      */ 
/*  216 */   private Map exceptionMap = new HashMap();
/*      */ 
/*  221 */   private Map arrayMap = new HashMap();
/*      */ 
/*  230 */   private AliasDefImpl javaIoSerializable = null;
/*      */ 
/*  238 */   private AliasDefImpl javaIoExternalizable = null;
/*      */ 
/*  246 */   private AliasDefImpl javaLang_Object = null;
/*      */ 
/*  254 */   private ValueDefImpl javaLangString = null;
/*      */ 
/*  262 */   private ValueDefImpl javaxRmiCORBAClassDesc = null;
/*      */ 
/*      */   public InterfaceRepository(ORB orb, POA poa, String name)
/*      */   {
/*  128 */     this.orb = orb;
/*  129 */     this.poa = poa;
/*  130 */     this.impl = new RepositoryImpl(orb, poa, name);
/*      */   }
/*      */ 
/*      */   public void mapClass(Class cls)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  143 */     getTypeCode(cls);
/*      */   }
/*      */ 
/*      */   public void finishBuild()
/*      */     throws IRConstructionException
/*      */   {
/*  153 */     this.impl.allDone();
/*      */   }
/*      */ 
/*      */   public Repository getReference()
/*      */   {
/*  161 */     return RepositoryHelper.narrow(this.impl.getReference());
/*      */   }
/*      */ 
/*      */   public void shutdown()
/*      */   {
/*  169 */     this.impl.shutdown();
/*      */   }
/*      */ 
/*      */   private TypeCode getConstantTypeCode(Class cls)
/*      */     throws IRConstructionException
/*      */   {
/*  272 */     if (cls == null) {
/*  273 */       throw new IllegalArgumentException("Null class");
/*      */     }
/*  275 */     TypeCode ret = (TypeCode)constantTypeCodeMap.get(cls);
/*      */ 
/*  277 */     if (ret == null) {
/*  278 */       throw new IRConstructionException("Bad class \"" + cls.getName() + "\" for a constant.");
/*      */     }
/*      */ 
/*  281 */     return ret;
/*      */   }
/*      */ 
/*      */   private TypeCode getTypeCode(Class cls)
/*      */     throws IRConstructionException, RMIIIOPViolationException
/*      */   {
/*  299 */     if (cls == null) {
/*  300 */       throw new IllegalArgumentException("Null class");
/*      */     }
/*  302 */     TypeCode ret = (TypeCode)this.typeCodeMap.get(cls);
/*      */ 
/*  304 */     if (ret == null) {
/*  305 */       if (cls == String.class) {
/*  306 */         ret = getJavaLangString().type();
/*  307 */       } else if (cls == Object.class) {
/*  308 */         ret = getJavaLang_Object().type();
/*  309 */       } else if (cls == Class.class) {
/*  310 */         ret = getJavaxRmiCORBAClassDesc().type();
/*  311 */       } else if (cls == Serializable.class) {
/*  312 */         ret = getJavaIoSerializable().type();
/*  313 */       } else if (cls == Externalizable.class) {
/*  314 */         ret = getJavaIoExternalizable().type();
/*      */       }
/*      */       else {
/*  317 */         addClass(cls);
/*      */ 
/*  320 */         ret = (TypeCode)this.typeCodeMap.get(cls);
/*      */ 
/*  322 */         if (ret == null) {
/*  323 */           throw new IRConstructionException("TypeCode for class " + cls.getName() + " unknown.");
/*      */         }
/*      */ 
/*  326 */         return ret;
/*      */       }
/*      */ 
/*  329 */       this.typeCodeMap.put(cls, ret);
/*      */     }
/*      */ 
/*  332 */     return ret;
/*      */   }
/*      */ 
/*      */   private void addTypeCode(Class cls, TypeCode typeCode)
/*      */     throws IRConstructionException
/*      */   {
/*  344 */     if (cls == null) {
/*  345 */       throw new IllegalArgumentException("Null class");
/*      */     }
/*  347 */     TypeCode tc = (TypeCode)this.typeCodeMap.get(cls);
/*      */ 
/*  349 */     if (tc != null) {
/*  350 */       throw new IllegalArgumentException("Class " + cls.getName() + " already has TypeCode.");
/*      */     }
/*      */ 
/*  353 */     logger.trace("InterfaceRepository: added typecode for " + cls.getName());
/*  354 */     this.typeCodeMap.put(cls, typeCode);
/*      */   }
/*      */ 
/*      */   private AliasDefImpl getJavaIoSerializable()
/*      */     throws IRConstructionException
/*      */   {
/*  365 */     if (this.javaIoSerializable == null) {
/*  366 */       String id = "IDL:java/io/Serializable:1.0";
/*  367 */       String name = "Serializable";
/*  368 */       String version = "1.0";
/*      */ 
/*  371 */       ModuleDefImpl m = ensurePackageExists("java.io");
/*      */ 
/*  373 */       TypeCode typeCode = this.orb.create_alias_tc("IDL:java/io/Serializable:1.0", "Serializable", this.orb.get_primitive_tc(TCKind.tk_any));
/*      */ 
/*  378 */       this.javaIoSerializable = new AliasDefImpl("IDL:java/io/Serializable:1.0", "Serializable", "1.0", m, typeCode, this.impl);
/*      */ 
/*  380 */       m.add("Serializable", this.javaIoSerializable);
/*      */     }
/*      */ 
/*  383 */     return this.javaIoSerializable;
/*      */   }
/*      */ 
/*      */   private AliasDefImpl getJavaIoExternalizable()
/*      */     throws IRConstructionException
/*      */   {
/*  394 */     if (this.javaIoExternalizable == null) {
/*  395 */       String id = "IDL:java/io/Externalizable:1.0";
/*  396 */       String name = "Externalizable";
/*  397 */       String version = "1.0";
/*      */ 
/*  400 */       ModuleDefImpl m = ensurePackageExists("java.io");
/*      */ 
/*  402 */       TypeCode typeCode = this.orb.create_alias_tc("IDL:java/io/Externalizable:1.0", "Externalizable", this.orb.get_primitive_tc(TCKind.tk_any));
/*      */ 
/*  407 */       this.javaIoExternalizable = new AliasDefImpl("IDL:java/io/Externalizable:1.0", "Externalizable", "1.0", m, typeCode, this.impl);
/*      */ 
/*  409 */       m.add("Externalizable", this.javaIoExternalizable);
/*      */     }
/*      */ 
/*  412 */     return this.javaIoExternalizable;
/*      */   }
/*      */ 
/*      */   private AliasDefImpl getJavaLang_Object()
/*      */     throws IRConstructionException
/*      */   {
/*  423 */     if (this.javaLang_Object == null) {
/*  424 */       String id = "IDL:java/lang/_Object:1.0";
/*  425 */       String name = "_Object";
/*  426 */       String version = "1.0";
/*      */ 
/*  429 */       ModuleDefImpl m = ensurePackageExists("java.lang");
/*      */ 
/*  431 */       TypeCode typeCode = this.orb.create_alias_tc("IDL:java/lang/_Object:1.0", "_Object", this.orb.get_primitive_tc(TCKind.tk_any));
/*      */ 
/*  436 */       this.javaLang_Object = new AliasDefImpl("IDL:java/lang/_Object:1.0", "_Object", "1.0", m, typeCode, this.impl);
/*      */ 
/*  438 */       m.add("_Object", this.javaLang_Object);
/*      */     }
/*      */ 
/*  441 */     return this.javaLang_Object;
/*      */   }
/*      */ 
/*      */   private ValueDefImpl getJavaLangString()
/*      */     throws IRConstructionException
/*      */   {
/*  452 */     if (this.javaLangString == null) {
/*  453 */       ModuleDefImpl m = ensurePackageExists("org.omg.CORBA");
/*  454 */       ValueDefImpl val = new ValueDefImpl("IDL:omg.org/CORBA/WStringValue:1.0", "WStringValue", "1.0", m, false, false, new String[0], new String[0], this.orb.get_primitive_tc(TCKind.tk_null), this.impl);
/*      */ 
/*  461 */       ValueMemberDefImpl vmdi = new ValueMemberDefImpl("IDL:omg.org/CORBA/WStringValue.data:1.0", "data", "1.0", this.orb.create_wstring_tc(0), true, val, this.impl);
/*      */ 
/*  465 */       val.add("data", vmdi);
/*  466 */       m.add("WStringValue", val);
/*      */ 
/*  468 */       this.javaLangString = val;
/*      */     }
/*      */ 
/*  471 */     return this.javaLangString;
/*      */   }
/*      */ 
/*      */   private ValueDefImpl getJavaxRmiCORBAClassDesc()
/*      */     throws IRConstructionException, RMIIIOPViolationException
/*      */   {
/*  482 */     if (this.javaxRmiCORBAClassDesc == null)
/*      */     {
/*  484 */       ValueAnalysis va = ValueAnalysis.getValueAnalysis(ClassDesc.class);
/*  485 */       ValueDefImpl val = addValue(va);
/*      */ 
/*  488 */       if (!"RMI:javax.rmi.CORBA.ClassDesc:B7C4E3FC9EBDC311:CFBF02CF5294176B".equals(val.id())) {
/*  489 */         logger.debug("Compatibility problem: Class javax.rmi.CORBA.ClassDesc does not conform to the Java(TM) Language to IDL Mapping Specification (01-06-07), section 1.3.5.11.");
/*      */       }
/*      */ 
/*  494 */       this.javaxRmiCORBAClassDesc = val;
/*      */     }
/*      */ 
/*  497 */     return this.javaxRmiCORBAClassDesc;
/*      */   }
/*      */ 
/*      */   private ModuleDefImpl ensurePackageExists(String pkgName)
/*      */     throws IRConstructionException
/*      */   {
/*  513 */     return ensurePackageExists(this.impl, "", pkgName);
/*      */   }
/*      */ 
/*      */   private ModuleDefImpl ensurePackageExists(LocalContainer c, String previous, String remainder)
/*      */     throws IRConstructionException
/*      */   {
/*  534 */     if ("".equals(remainder)) {
/*  535 */       return (ModuleDefImpl)c;
/*      */     }
/*  537 */     int idx = remainder.indexOf('.');
/*      */     String base;
/*  540 */     if (idx == -1)
/*  541 */       base = remainder;
/*      */     else
/*  543 */       base = remainder.substring(0, idx);
/*  544 */     String base = Util.javaToIDLName(base);
/*      */ 
/*  546 */     if (previous.equals(""))
/*  547 */       previous = base;
/*      */     else
/*  549 */       previous = previous + "/" + base;
/*  550 */     if (idx == -1)
/*  551 */       remainder = "";
/*      */     else {
/*  553 */       remainder = remainder.substring(idx + 1);
/*      */     }
/*  555 */     LocalContainer next = null;
/*  556 */     LocalContained contained = c._lookup(base);
/*      */ 
/*  558 */     if ((contained instanceof LocalContainer))
/*  559 */       next = (LocalContainer)contained;
/*  560 */     else if (contained != null) {
/*  561 */       throw new IRConstructionException("Name collision while creating package.");
/*      */     }
/*  563 */     if (next == null) {
/*  564 */       String id = "IDL:" + previous + ":1.0";
/*      */ 
/*  567 */       ModuleDefImpl m = new ModuleDefImpl(id, base, "1.0", c, this.impl);
/*  568 */       logger.trace("Created module \"" + id + "\".");
/*      */ 
/*  570 */       c.add(base, m);
/*      */ 
/*  572 */       if (idx == -1) {
/*  573 */         return m;
/*      */       }
/*  575 */       next = (LocalContainer)c._lookup(base);
/*      */     }
/*  577 */     else if (next.def_kind() != DefinitionKind.dk_Module) {
/*  578 */       throw new IRConstructionException("Name collision while creating package.");
/*      */     }
/*  580 */     return ensurePackageExists(next, previous, remainder);
/*      */   }
/*      */ 
/*      */   private void addConstants(LocalContainer container, ContainerAnalysis ca)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  590 */     ConstantAnalysis[] consts = ca.getConstants();
/*  591 */     for (int i = 0; i < consts.length; i++)
/*      */     {
/*  593 */       String cid = ca.getMemberRepositoryId(consts[i].getJavaName());
/*  594 */       String cName = consts[i].getIDLName();
/*      */ 
/*  596 */       Class cls = consts[i].getType();
/*  597 */       logger.trace("Constant[" + i + "] class: " + cls.getName());
/*  598 */       TypeCode typeCode = getConstantTypeCode(cls);
/*      */ 
/*  600 */       Any value = this.orb.create_any();
/*  601 */       consts[i].insertValue(value);
/*      */ 
/*  603 */       logger.trace("Adding constant: " + cid);
/*  604 */       ConstantDefImpl cDef = new ConstantDefImpl(cid, cName, "1.0", typeCode, value, container, this.impl);
/*      */ 
/*  606 */       container.add(cName, cDef);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addAttributes(LocalContainer container, ContainerAnalysis ca)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  617 */     AttributeAnalysis[] attrs = ca.getAttributes();
/*  618 */     logger.trace("Attribute count: " + attrs.length);
/*  619 */     for (int i = 0; i < attrs.length; i++)
/*      */     {
/*  621 */       String aid = ca.getMemberRepositoryId(attrs[i].getJavaName());
/*  622 */       String aName = attrs[i].getIDLName();
/*      */ 
/*  624 */       Class cls = attrs[i].getCls();
/*  625 */       logger.trace("Attribute[" + i + "] class: " + cls.getName());
/*      */ 
/*  627 */       TypeCode typeCode = getTypeCode(cls);
/*      */ 
/*  629 */       logger.trace("Adding: " + aid);
/*  630 */       AttributeDefImpl aDef = new AttributeDefImpl(aid, aName, "1.0", attrs[i].getMode(), typeCode, container, this.impl);
/*      */ 
/*  632 */       container.add(aName, aDef);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void addOperations(LocalContainer container, ContainerAnalysis ca)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  643 */     OperationAnalysis[] ops = ca.getOperations();
/*  644 */     logger.debug("Operation count: " + ops.length);
/*  645 */     for (int i = 0; i < ops.length; i++)
/*      */     {
/*  647 */       String oName = ops[i].getIDLName();
/*  648 */       String oid = ca.getMemberRepositoryId(oName);
/*      */ 
/*  650 */       Class cls = ops[i].getReturnType();
/*  651 */       logger.debug("Operation[" + i + "] return type class: " + cls.getName());
/*  652 */       TypeCode typeCode = getTypeCode(cls);
/*      */ 
/*  654 */       ParameterAnalysis[] ps = ops[i].getParameters();
/*  655 */       ParameterDescription[] params = new ParameterDescription[ps.length];
/*  656 */       for (int j = 0; j < ps.length; j++) {
/*  657 */         params[j] = new ParameterDescription(ps[j].getIDLName(), getTypeCode(ps[j].getCls()), null, ParameterMode.PARAM_IN);
/*      */       }
/*      */ 
/*  663 */       ExceptionAnalysis[] exc = ops[i].getMappedExceptions();
/*  664 */       ExceptionDef[] exceptions = new ExceptionDef[exc.length];
/*  665 */       for (int j = 0; j < exc.length; j++) {
/*  666 */         ExceptionDefImpl e = addException(exc[j]);
/*  667 */         exceptions[j] = ExceptionDefHelper.narrow(e.getReference());
/*      */       }
/*      */ 
/*  670 */       logger.debug("Adding: " + oid);
/*  671 */       OperationDefImpl oDef = new OperationDefImpl(oid, oName, "1.0", container, typeCode, params, exceptions, this.impl);
/*      */ 
/*  673 */       container.add(oName, oDef);
/*      */     }
/*      */   }
/*      */ 
/*      */   private String[] addInterfaces(ContainerAnalysis ca)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  685 */     logger.trace("Adding interfaces: ");
/*  686 */     InterfaceAnalysis[] interfaces = ca.getInterfaces();
/*  687 */     List base_interfaces = new ArrayList();
/*  688 */     for (int i = 0; i < interfaces.length; i++) {
/*  689 */       InterfaceDefImpl idi = addInterface(interfaces[i]);
/*  690 */       base_interfaces.add(idi.id());
/*  691 */       logger.trace("                   " + idi.id());
/*      */     }
/*  693 */     String[] strArr = new String[base_interfaces.size()];
/*  694 */     return (String[])(String[])base_interfaces.toArray(strArr);
/*      */   }
/*      */ 
/*      */   private String[] addAbstractBaseValuetypes(ContainerAnalysis ca)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  705 */     logger.trace("Adding abstract valuetypes: ");
/*  706 */     ValueAnalysis[] abstractValuetypes = ca.getAbstractBaseValuetypes();
/*  707 */     List abstract_base_valuetypes = new ArrayList();
/*  708 */     for (int i = 0; i < abstractValuetypes.length; i++) {
/*  709 */       ValueDefImpl vdi = addValue(abstractValuetypes[i]);
/*  710 */       abstract_base_valuetypes.add(vdi.id());
/*  711 */       logger.trace("                   " + vdi.id());
/*      */     }
/*  713 */     String[] strArr = new String[abstract_base_valuetypes.size()];
/*  714 */     return (String[])(String[])abstract_base_valuetypes.toArray(strArr);
/*      */   }
/*      */ 
/*      */   private void addClass(Class cls)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  723 */     if (cls.isPrimitive()) {
/*  724 */       return;
/*      */     }
/*  726 */     if (cls.isArray())
/*      */     {
/*  728 */       addArray(cls);
/*  729 */     } else if (cls.isInterface()) {
/*  730 */       if (!RmiIdlUtil.isAbstractValueType(cls))
/*      */       {
/*  732 */         InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
/*      */ 
/*  735 */         addInterface(ia);
/*      */       }
/*      */       else
/*      */       {
/*  739 */         ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
/*      */ 
/*  742 */         addValue(va);
/*      */       }
/*  744 */     } else if (Exception.class.isAssignableFrom(cls))
/*      */     {
/*  746 */       ExceptionAnalysis ea = ExceptionAnalysis.getExceptionAnalysis(cls);
/*      */ 
/*  749 */       addException(ea);
/*      */     }
/*      */     else {
/*  752 */       ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
/*      */ 
/*  755 */       addValue(va);
/*      */     }
/*      */   }
/*      */ 
/*      */   private ValueBoxDefImpl addArray(Class cls)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  765 */     if (!cls.isArray()) {
/*  766 */       throw new IllegalArgumentException("Not an array class.");
/*      */     }
/*      */ 
/*  771 */     ValueBoxDefImpl vbDef = (ValueBoxDefImpl)this.arrayMap.get(cls);
/*  772 */     if (vbDef != null) {
/*  773 */       return vbDef;
/*      */     }
/*  775 */     int dimensions = 0;
/*  776 */     Class compType = cls;
/*      */     do
/*      */     {
/*  779 */       compType = compType.getComponentType();
/*  780 */       dimensions++;
/*  781 */     }while (compType.isArray());
/*      */     String moduleName;
/*      */     TypeCode typeCode;
/*      */     String typeName;
/*      */     String moduleName;
/*  787 */     if (compType.isPrimitive())
/*      */     {
/*      */       TypeCode typeCode;
/*  788 */       if (compType == Boolean.TYPE) {
/*  789 */         String typeName = "boolean";
/*  790 */         typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
/*      */       }
/*      */       else
/*      */       {
/*      */         TypeCode typeCode;
/*  791 */         if (compType == Character.TYPE) {
/*  792 */           String typeName = "wchar";
/*  793 */           typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
/*      */         }
/*      */         else
/*      */         {
/*      */           TypeCode typeCode;
/*  794 */           if (compType == Byte.TYPE) {
/*  795 */             String typeName = "octet";
/*  796 */             typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
/*      */           }
/*      */           else
/*      */           {
/*      */             TypeCode typeCode;
/*  797 */             if (compType == Short.TYPE) {
/*  798 */               String typeName = "short";
/*  799 */               typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
/*      */             }
/*      */             else
/*      */             {
/*      */               TypeCode typeCode;
/*  800 */               if (compType == Integer.TYPE) {
/*  801 */                 String typeName = "long";
/*  802 */                 typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
/*      */               }
/*      */               else
/*      */               {
/*      */                 TypeCode typeCode;
/*  803 */                 if (compType == Long.TYPE) {
/*  804 */                   String typeName = "long_long";
/*  805 */                   typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   TypeCode typeCode;
/*  806 */                   if (compType == Float.TYPE) {
/*  807 */                     String typeName = "float";
/*  808 */                     typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
/*      */                   }
/*      */                   else
/*      */                   {
/*      */                     TypeCode typeCode;
/*  809 */                     if (compType == Double.TYPE) {
/*  810 */                       String typeName = "double";
/*  811 */                       typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
/*      */                     } else {
/*  813 */                       throw new IRConstructionException("Unknown primitive type for array type: " + cls.getName());
/*      */                     }
/*      */                   }
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       TypeCode typeCode;
/*      */       String typeName;
/*  817 */       moduleName = "org.omg.boxedRMI";
/*      */     } else {
/*  819 */       typeCode = getTypeCode(compType);
/*      */       String typeName;
/*  821 */       if (compType == String.class) {
/*  822 */         typeName = getJavaLangString().name();
/*      */       }
/*      */       else
/*      */       {
/*      */         String typeName;
/*  823 */         if (compType == Object.class) {
/*  824 */           typeName = getJavaLang_Object().name();
/*      */         }
/*      */         else
/*      */         {
/*      */           String typeName;
/*  825 */           if (compType == Class.class) {
/*  826 */             typeName = getJavaxRmiCORBAClassDesc().name();
/*      */           }
/*      */           else
/*      */           {
/*      */             String typeName;
/*  827 */             if (compType == Serializable.class) {
/*  828 */               typeName = getJavaIoSerializable().name();
/*      */             }
/*      */             else
/*      */             {
/*      */               String typeName;
/*  829 */               if (compType == Externalizable.class) {
/*  830 */                 typeName = getJavaIoExternalizable().name();
/*      */               }
/*      */               else
/*      */               {
/*      */                 String typeName;
/*  831 */                 if ((compType.isInterface()) && (!RmiIdlUtil.isAbstractValueType(compType)))
/*      */                 {
/*  833 */                   typeName = ((InterfaceDefImpl)this.interfaceMap.get(compType)).name();
/*      */                 }
/*      */                 else
/*      */                 {
/*      */                   String typeName;
/*  834 */                   if (Exception.class.isAssignableFrom(compType))
/*  835 */                     typeName = ((ExceptionDefImpl)this.exceptionMap.get(compType)).name();
/*      */                   else
/*  837 */                     typeName = ((ValueDefImpl)this.valueMap.get(compType)).name(); 
/*      */                 }
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*  839 */       moduleName = "org.omg.boxedRMI." + compType.getPackage().getName();
/*      */     }
/*      */ 
/*  843 */     ModuleDefImpl m = ensurePackageExists(moduleName);
/*      */ 
/*  846 */     Class[] types = new Class[dimensions];
/*  847 */     types[(dimensions - 1)] = cls;
/*  848 */     for (int i = dimensions - 2; i >= 0; i--) {
/*  849 */       types[i] = types[(i + 1)].getComponentType();
/*      */     }
/*      */ 
/*  852 */     for (int i = 0; i < dimensions; i++) {
/*  853 */       Class type = types[i];
/*      */ 
/*  855 */       typeCode = this.orb.create_sequence_tc(0, typeCode);
/*  856 */       vbDef = (ValueBoxDefImpl)this.arrayMap.get(type);
/*  857 */       if (vbDef == null) {
/*  858 */         String id = Util.getIRIdentifierOfClass(type);
/*      */ 
/*  860 */         SequenceDefImpl sdi = new SequenceDefImpl(typeCode, this.impl);
/*      */ 
/*  862 */         String name = "seq" + (i + 1) + "_" + typeName;
/*      */ 
/*  865 */         TypeCode boxTypeCode = this.orb.create_value_box_tc(id, name, typeCode);
/*  866 */         vbDef = new ValueBoxDefImpl(id, name, "1.0", m, boxTypeCode, this.impl);
/*      */ 
/*  868 */         addTypeCode(type, vbDef.type());
/*  869 */         m.add(name, vbDef);
/*  870 */         this.impl.putSequenceImpl(id, typeCode, sdi, vbDef);
/*      */ 
/*  872 */         this.arrayMap.put(type, vbDef);
/*      */ 
/*  874 */         typeCode = boxTypeCode;
/*      */       } else {
/*  876 */         typeCode = vbDef.type();
/*      */       }
/*      */     }
/*      */ 
/*  880 */     return vbDef;
/*      */   }
/*      */ 
/*      */   private InterfaceDefImpl addInterface(InterfaceAnalysis ia)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  890 */     Class cls = ia.getCls();
/*      */ 
/*  893 */     InterfaceDefImpl iDef = (InterfaceDefImpl)this.interfaceMap.get(cls);
/*  894 */     if (iDef != null) {
/*  895 */       return iDef;
/*      */     }
/*  897 */     if (ia.isAbstractInterface()) {
/*  898 */       logger.trace("Adding abstract interface: " + ia.getRepositoryId());
/*      */     }
/*      */ 
/*  901 */     ModuleDefImpl m = ensurePackageExists(cls.getPackage().getName());
/*      */ 
/*  904 */     String[] base_interfaces = addInterfaces(ia);
/*      */ 
/*  907 */     String base = cls.getName();
/*  908 */     base = base.substring(base.lastIndexOf('.') + 1);
/*  909 */     base = Util.javaToIDLName(base);
/*      */ 
/*  911 */     iDef = new InterfaceDefImpl(ia.getRepositoryId(), base, "1.0", m, base_interfaces, this.impl);
/*      */ 
/*  914 */     addTypeCode(cls, iDef.type());
/*  915 */     m.add(base, iDef);
/*  916 */     this.interfaceMap.put(cls, iDef);
/*      */ 
/*  919 */     addConstants(iDef, ia);
/*      */ 
/*  922 */     addAttributes(iDef, ia);
/*      */ 
/*  925 */     addOperations(iDef, ia);
/*      */ 
/*  927 */     logger.trace("Added interface: " + ia.getRepositoryId());
/*  928 */     return iDef;
/*      */   }
/*      */ 
/*      */   private ValueDefImpl addValue(ValueAnalysis va)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/*  938 */     Class cls = va.getCls();
/*      */ 
/*  941 */     ValueDefImpl vDef = (ValueDefImpl)this.valueMap.get(cls);
/*  942 */     if (vDef != null) {
/*  943 */       return vDef;
/*      */     }
/*      */ 
/*  946 */     ModuleDefImpl m = ensurePackageExists(cls.getPackage().getName());
/*      */ 
/*  949 */     String[] supported_interfaces = addInterfaces(va);
/*      */ 
/*  952 */     String[] abstract_base_valuetypes = addAbstractBaseValuetypes(va);
/*      */ 
/*  955 */     ValueDefImpl superValue = null;
/*  956 */     ValueAnalysis superAnalysis = va.getSuperAnalysis();
/*  957 */     if (superAnalysis != null) {
/*  958 */       superValue = addValue(superAnalysis);
/*      */     }
/*      */ 
/*  961 */     String base = cls.getName();
/*  962 */     base = base.substring(base.lastIndexOf('.') + 1);
/*  963 */     base = Util.javaToIDLName(base);
/*      */     TypeCode baseTypeCode;
/*      */     TypeCode baseTypeCode;
/*  966 */     if (superValue == null)
/*  967 */       baseTypeCode = this.orb.get_primitive_tc(TCKind.tk_null);
/*      */     else {
/*  969 */       baseTypeCode = superValue.type();
/*      */     }
/*  971 */     vDef = new ValueDefImpl(va.getRepositoryId(), base, "1.0", m, va.isAbstractValue(), va.isCustom(), supported_interfaces, abstract_base_valuetypes, baseTypeCode, this.impl);
/*      */ 
/*  979 */     addTypeCode(cls, vDef.type());
/*  980 */     logger.debug("Value: base=" + base);
/*  981 */     m.add(base, vDef);
/*  982 */     this.valueMap.put(cls, vDef);
/*      */ 
/*  985 */     addConstants(vDef, va);
/*      */ 
/*  988 */     ValueMemberAnalysis[] vmas = va.getMembers();
/*  989 */     logger.debug("Value member count: " + vmas.length);
/*  990 */     for (int i = 0; i < vmas.length; i++)
/*      */     {
/*  992 */       String vmid = va.getMemberRepositoryId(vmas[i].getJavaName());
/*  993 */       String vmName = vmas[i].getIDLName();
/*      */ 
/*  995 */       Class vmCls = vmas[i].getCls();
/*  996 */       logger.debug("ValueMembers[" + i + "] class: " + vmCls.getName());
/*  997 */       TypeCode typeCode = getTypeCode(vmCls);
/*      */ 
/*  999 */       boolean vmPublic = vmas[i].isPublic();
/*      */ 
/* 1001 */       logger.debug("Adding value member: " + vmid);
/* 1002 */       ValueMemberDefImpl vmDef = new ValueMemberDefImpl(vmid, vmName, "1.0", typeCode, vmPublic, vDef, this.impl);
/*      */ 
/* 1004 */       vDef.add(vmName, vmDef);
/*      */     }
/*      */ 
/* 1008 */     addAttributes(vDef, va);
/*      */ 
/* 1012 */     return vDef;
/*      */   }
/*      */ 
/*      */   private ExceptionDefImpl addException(ExceptionAnalysis ea)
/*      */     throws RMIIIOPViolationException, IRConstructionException
/*      */   {
/* 1022 */     Class cls = ea.getCls();
/*      */ 
/* 1025 */     ExceptionDefImpl eDef = (ExceptionDefImpl)this.exceptionMap.get(cls);
/* 1026 */     if (eDef != null) {
/* 1027 */       return eDef;
/*      */     }
/*      */ 
/* 1030 */     ValueDefImpl vDef = addValue(ea);
/*      */ 
/* 1033 */     ModuleDefImpl m = ensurePackageExists(cls.getPackage().getName());
/* 1034 */     String base = cls.getName();
/* 1035 */     base = base.substring(base.lastIndexOf('.') + 1);
/* 1036 */     if (base.endsWith("Exception"))
/* 1037 */       base = base.substring(0, base.length() - 9);
/* 1038 */     base = Util.javaToIDLName(base + "Ex");
/*      */ 
/* 1040 */     StructMember[] members = new StructMember[1];
/* 1041 */     members[0] = new StructMember("value", vDef.type(), null);
/* 1042 */     TypeCode typeCode = this.orb.create_exception_tc(ea.getExceptionRepositoryId(), base, members);
/*      */ 
/* 1046 */     eDef = new ExceptionDefImpl(ea.getExceptionRepositoryId(), base, "1.0", typeCode, vDef, m, this.impl);
/*      */ 
/* 1048 */     logger.debug("Exception: base=" + base);
/* 1049 */     m.add(base, eDef);
/* 1050 */     this.exceptionMap.put(cls, eDef);
/*      */ 
/* 1052 */     return eDef;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     ORB orb;
/*      */     try
/*      */     {
/*   87 */       orb = (ORB)new InitialContext().lookup("java:/JBossCorbaORB");
/*      */     } catch (NamingException ex) {
/*   89 */       throw new RuntimeException("Cannot lookup java:/JBossCorbaORB: " + ex);
/*      */     }
/*      */ 
/*   93 */     primitiveTypeCodeMap = new HashMap();
/*   94 */     primitiveTypeCodeMap.put(Void.TYPE, orb.get_primitive_tc(TCKind.tk_void));
/*      */ 
/*   96 */     primitiveTypeCodeMap.put(Boolean.TYPE, orb.get_primitive_tc(TCKind.tk_boolean));
/*      */ 
/*   98 */     primitiveTypeCodeMap.put(Character.TYPE, orb.get_primitive_tc(TCKind.tk_wchar));
/*      */ 
/*  100 */     primitiveTypeCodeMap.put(Byte.TYPE, orb.get_primitive_tc(TCKind.tk_octet));
/*      */ 
/*  102 */     primitiveTypeCodeMap.put(Short.TYPE, orb.get_primitive_tc(TCKind.tk_short));
/*      */ 
/*  104 */     primitiveTypeCodeMap.put(Integer.TYPE, orb.get_primitive_tc(TCKind.tk_long));
/*      */ 
/*  106 */     primitiveTypeCodeMap.put(Long.TYPE, orb.get_primitive_tc(TCKind.tk_longlong));
/*      */ 
/*  108 */     primitiveTypeCodeMap.put(Float.TYPE, orb.get_primitive_tc(TCKind.tk_float));
/*      */ 
/*  110 */     primitiveTypeCodeMap.put(Double.TYPE, orb.get_primitive_tc(TCKind.tk_double));
/*      */ 
/*  114 */     constantTypeCodeMap = new HashMap(primitiveTypeCodeMap);
/*  115 */     constantTypeCodeMap.put(String.class, orb.create_wstring_tc(0));
/*      */ 
/*  121 */     logger = Logger.getLogger(InterfaceRepository.class);
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ir.InterfaceRepository
 * JD-Core Version:    0.6.0
 */