/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.io.Externalizable;
/*     */ import java.io.ObjectStreamField;
/*     */ import java.io.OutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.rmi.Remote;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Comparator;
/*     */ import java.util.SortedSet;
/*     */ import java.util.TreeSet;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ import org.omg.CORBA.portable.ValueBase;
/*     */ 
/*     */ public class ValueAnalysis extends ContainerAnalysis
/*     */ {
/*  60 */   private static final Logger logger = Logger.getLogger(ValueAnalysis.class);
/*     */ 
/*  63 */   private static WorkCacheManager cache = new WorkCacheManager(ValueAnalysis.class);
/*     */   ValueAnalysis superAnalysis;
/* 341 */   private boolean abstractValue = false;
/*     */ 
/* 346 */   private boolean externalizable = false;
/*     */ 
/* 351 */   private boolean hasWriteObjectMethod = false;
/*     */   private ObjectStreamField[] serialPersistentFields;
/*     */   private ValueMemberAnalysis[] members;
/*     */ 
/*     */   public static ValueAnalysis getValueAnalysis(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  69 */     return (ValueAnalysis)cache.getAnalysis(cls);
/*     */   }
/*     */ 
/*     */   protected ValueAnalysis(Class cls)
/*     */   {
/*  76 */     super(cls);
/*  77 */     logger.debug("ValueAnalysis(\"" + cls.getName() + "\") entered.");
/*     */   }
/*     */ 
/*     */   public String getIDLModuleName()
/*     */   {
/*  82 */     String result = super.getIDLModuleName();
/*     */ 
/*  85 */     Class clazz = getCls();
/*  86 */     if ((IDLEntity.class.isAssignableFrom(clazz)) && (!ValueBase.class.isAssignableFrom(clazz)))
/*  87 */       result = "::org::omg::boxedIDL" + result;
/*  88 */     return result;
/*     */   }
/*     */ 
/*     */   protected void doAnalyze()
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  94 */     super.doAnalyze();
/*     */ 
/*  96 */     if (this.cls == String.class) {
/*  97 */       throw new IllegalArgumentException("Cannot analyze java.lang.String here: It is a special case.");
/*     */     }
/*     */ 
/* 101 */     if (this.cls == Class.class) {
/* 102 */       throw new IllegalArgumentException("Cannot analyze java.lang.Class here: It is a special case.");
/*     */     }
/*     */ 
/* 106 */     if (Remote.class.isAssignableFrom(this.cls)) {
/* 107 */       throw new RMIIIOPViolationException("Value type " + this.cls.getName() + " cannot implement java.rmi.Remote.", "1.2.4");
/*     */     }
/*     */ 
/* 111 */     if (this.cls.getName().indexOf('$') != -1) {
/* 112 */       throw new RMIIIOPNotImplementedException("Class " + this.cls.getName() + " has a '$', like " + "proxies or inner classes.");
/*     */     }
/*     */ 
/* 116 */     this.externalizable = Externalizable.class.isAssignableFrom(this.cls);
/*     */ 
/* 118 */     if (!this.externalizable)
/*     */     {
/* 120 */       Field spf = null;
/*     */       try {
/* 122 */         spf = this.cls.getField("serialPersistentFields");
/*     */       }
/*     */       catch (NoSuchFieldException ex) {
/*     */       }
/* 126 */       if (spf != null) {
/* 127 */         int mods = spf.getModifiers();
/* 128 */         if ((!Modifier.isFinal(mods)) || (!Modifier.isStatic(mods)) || (!Modifier.isPrivate(mods)))
/*     */         {
/* 130 */           spf = null;
/*     */         }
/*     */       }
/* 132 */       if (spf != null) {
/* 133 */         Class type = spf.getType();
/* 134 */         if (type.isArray()) {
/* 135 */           type = type.getComponentType();
/* 136 */           if (type != ObjectStreamField.class)
/* 137 */             spf = null;
/*     */         } else {
/* 139 */           spf = null;
/*     */         }
/*     */       }
/* 141 */       if (spf != null)
/*     */       {
/*     */         try
/*     */         {
/* 146 */           this.serialPersistentFields = ((ObjectStreamField[])(ObjectStreamField[])spf.get(null));
/*     */         } catch (IllegalAccessException ex) {
/* 148 */           throw new RuntimeException("Unexpected IllegalException: " + ex.toString());
/*     */         }
/*     */ 
/* 153 */         for (int i = 0; i < this.fields.length; i++) {
/* 154 */           if (this.fields[i] == spf)
/*     */           {
/*     */             int tmp339_338 = i;
/*     */             byte[] tmp339_335 = this.f_flags; tmp339_335[tmp339_338] = (byte)(tmp339_335[tmp339_338] | 0x2);
/* 156 */             break;
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 162 */       Method wo = null;
/*     */       try {
/* 164 */         wo = this.cls.getMethod("writeObject", new Class[] { [Ljava.io.OutputStream.class });
/*     */       }
/*     */       catch (NoSuchMethodException ex)
/*     */       {
/*     */       }
/* 169 */       if ((wo != null) && 
/* 170 */         (wo.getReturnType() != Void.TYPE)) {
/* 171 */         wo = null;
/*     */       }
/* 173 */       if (wo != null) {
/* 174 */         int mods = spf.getModifiers();
/* 175 */         if (!Modifier.isPrivate(mods))
/* 176 */           wo = null;
/*     */       }
/* 178 */       if (wo != null) {
/* 179 */         Class[] paramTypes = wo.getParameterTypes();
/* 180 */         if (paramTypes.length != 1)
/* 181 */           wo = null;
/* 182 */         else if (paramTypes[0] != OutputStream.class)
/* 183 */           wo = null;
/*     */       }
/* 185 */       if (wo != null)
/*     */       {
/* 187 */         this.hasWriteObjectMethod = true;
/*     */ 
/* 190 */         for (int i = 0; i < this.methods.length; i++) {
/* 191 */           if (this.methods[i] == wo)
/*     */           {
/*     */             int tmp480_479 = i;
/*     */             byte[] tmp480_476 = this.m_flags; tmp480_476[tmp480_479] = (byte)(tmp480_476[tmp480_479] | 0x20);
/* 193 */             break;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 200 */     SortedSet m = new TreeSet(new ValueMemberComparator(null));
/*     */ 
/* 202 */     logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "fields.length=" + this.fields.length);
/*     */ 
/* 204 */     for (int i = 0; i < this.fields.length; i++) {
/* 205 */       logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\"): " + "Considering field[" + i + "] \"" + this.fields[i].getName() + "\"" + " f_flags=" + this.f_flags[i]);
/*     */ 
/* 208 */       if (this.f_flags[i] != 0) {
/*     */         continue;
/*     */       }
/* 211 */       int mods = this.fields[i].getModifiers();
/* 212 */       logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\"): mods=" + mods);
/* 213 */       if ((Modifier.isStatic(mods)) || (Modifier.isTransient(mods)))
/*     */       {
/*     */         continue;
/*     */       }
/* 217 */       ValueMemberAnalysis vma = new ValueMemberAnalysis(this.fields[i].getName(), this.fields[i].getType(), Modifier.isPublic(mods));
/*     */ 
/* 220 */       m.add(vma);
/*     */     }
/*     */ 
/* 223 */     this.members = new ValueMemberAnalysis[m.size()];
/* 224 */     this.members = ((ValueMemberAnalysis[])(ValueMemberAnalysis[])m.toArray(this.members));
/* 225 */     logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\") value member count: " + this.members.length);
/*     */ 
/* 229 */     Class superClass = this.cls.getSuperclass();
/* 230 */     if (superClass == Object.class)
/* 231 */       superClass = null;
/* 232 */     if (superClass == null) {
/* 233 */       this.superAnalysis = null;
/*     */     } else {
/* 235 */       logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\"): superclass: " + superClass.getName());
/*     */ 
/* 237 */       this.superAnalysis = getValueAnalysis(superClass);
/*     */     }
/*     */ 
/* 240 */     if (!Serializable.class.isAssignableFrom(this.cls)) {
/* 241 */       this.abstractValue = true;
/*     */     }
/* 243 */     fixupCaseNames();
/*     */ 
/* 245 */     logger.debug("ValueAnalysis(\"" + this.cls.getName() + "\") done.");
/*     */   }
/*     */ 
/*     */   public ValueAnalysis getSuperAnalysis()
/*     */   {
/* 256 */     return this.superAnalysis;
/*     */   }
/*     */ 
/*     */   public boolean isAbstractValue()
/*     */   {
/* 264 */     return this.abstractValue;
/*     */   }
/*     */ 
/*     */   public boolean isCustom()
/*     */   {
/* 272 */     return (this.externalizable) || (this.hasWriteObjectMethod);
/*     */   }
/*     */ 
/*     */   public boolean isExternalizable()
/*     */   {
/* 280 */     return this.externalizable;
/*     */   }
/*     */ 
/*     */   public ValueMemberAnalysis[] getMembers()
/*     */   {
/* 288 */     return (ValueMemberAnalysis[])(ValueMemberAnalysis[])this.members.clone();
/*     */   }
/*     */ 
/*     */   protected void analyzeAttributes()
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 304 */     this.attributes = new AttributeAnalysis[0];
/*     */   }
/*     */ 
/*     */   protected ArrayList getContainedEntries()
/*     */   {
/* 315 */     ArrayList ret = new ArrayList(this.constants.length + this.attributes.length + this.members.length);
/*     */ 
/* 319 */     for (int i = 0; i < this.constants.length; i++)
/* 320 */       ret.add(this.constants[i]);
/* 321 */     for (int i = 0; i < this.attributes.length; i++)
/* 322 */       ret.add(this.attributes[i]);
/* 323 */     for (int i = 0; i < this.members.length; i++) {
/* 324 */       ret.add(this.members[i]);
/*     */     }
/* 326 */     return ret;
/*     */   }
/*     */ 
/*     */   private static class ValueMemberComparator
/*     */     implements Comparator
/*     */   {
/*     */     public int compare(Object o1, Object o2)
/*     */     {
/* 376 */       if (o1 == o2) {
/* 377 */         return 0;
/*     */       }
/* 379 */       ValueMemberAnalysis m1 = (ValueMemberAnalysis)o1;
/* 380 */       ValueMemberAnalysis m2 = (ValueMemberAnalysis)o2;
/*     */ 
/* 382 */       boolean p1 = m1.getCls().isPrimitive();
/* 383 */       boolean p2 = m2.getCls().isPrimitive();
/*     */ 
/* 385 */       if ((p1) && (!p2))
/* 386 */         return -1;
/* 387 */       if ((!p1) && (p2)) {
/* 388 */         return 1;
/*     */       }
/* 390 */       return m1.getJavaName().compareTo(m2.getJavaName());
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.ValueAnalysis
 * JD-Core Version:    0.6.0
 */