/*     */ package org.jboss.iiop.rmi;
/*     */ 
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.Externalizable;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.ObjectStreamClass;
/*     */ import java.io.Serializable;
/*     */ import java.lang.reflect.Field;
/*     */ import java.lang.reflect.Method;
/*     */ import java.lang.reflect.Modifier;
/*     */ import java.rmi.Remote;
/*     */ import java.security.MessageDigest;
/*     */ import java.security.NoSuchAlgorithmException;
/*     */ import java.util.Collections;
/*     */ import java.util.Comparator;
/*     */ import java.util.Iterator;
/*     */ import java.util.Map;
/*     */ import java.util.SortedSet;
/*     */ import java.util.TreeSet;
/*     */ import java.util.WeakHashMap;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.omg.CORBA.Any;
/*     */ import org.omg.CORBA.portable.IDLEntity;
/*     */ 
/*     */ public class Util
/*     */ {
/*  63 */   private static final Logger logger = Logger.getLogger(Util.class);
/*     */ 
/* 313 */   private static Map classHashCodeCache = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/* 319 */   private static Map classIRIdentifierCache = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/* 328 */   private static final String[] reservedIDLKeywords = { "abstract", "any", "attribute", "boolean", "case", "char", "const", "context", "custom", "default", "double", "exception", "enum", "factory", "FALSE", "fixed", "float", "in", "inout", "interface", "local", "long", "module", "native", "Object", "octet", "oneway", "out", "private", "public", "raises", "readonly", "sequence", "short", "string", "struct", "supports", "switch", "TRUE", "truncatable", "typedef", "unsigned", "union", "ValueBase", "valuetype", "void", "wchar", "wstring" };
/*     */ 
/*     */   public static String getTypeIDLName(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/*  73 */     logger.debug("getTypeIDLName " + cls);
/*     */ 
/*  75 */     if (cls.isPrimitive()) {
/*  76 */       return PrimitiveAnalysis.getPrimitiveAnalysis(cls).getIDLName();
/*     */     }
/*  78 */     if (cls.isArray())
/*     */     {
/*  81 */       Class componentClass = cls;
/*  82 */       int sequence = 0;
/*  83 */       while (componentClass.isArray())
/*     */       {
/*  85 */         componentClass = componentClass.getComponentType();
/*  86 */         sequence++;
/*     */       }
/*     */ 
/*  89 */       String idlName = getTypeIDLName(componentClass);
/*  90 */       int idx = idlName.lastIndexOf("::");
/*  91 */       String idlModule = idlName.substring(0, idx + 2);
/*  92 */       String baseName = idlName.substring(idx + 2);
/*  93 */       return "::org::omg::boxedRMI" + idlModule + "seq" + sequence + "_" + baseName;
/*     */     }
/*     */ 
/*  97 */     if (cls == String.class)
/*  98 */       return "::CORBA::WStringValue";
/*  99 */     if (cls == java.lang.Object.class)
/* 100 */       return "::java::lang::_Object";
/* 101 */     if (cls == Class.class)
/* 102 */       return "::javax::rmi::CORBA::ClassDesc";
/* 103 */     if (cls == Serializable.class)
/* 104 */       return "::java::io::Serializable";
/* 105 */     if (cls == Externalizable.class)
/* 106 */       return "::java::io::Externalizable";
/* 107 */     if (cls == Remote.class)
/* 108 */       return "::java::rmi::Remote";
/* 109 */     if (cls == org.omg.CORBA.Object.class) {
/* 110 */       return "::CORBA::Object";
/*     */     }
/*     */ 
/* 114 */     if ((cls.isInterface()) && (Remote.class.isAssignableFrom(cls))) {
/* 115 */       InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
/*     */ 
/* 117 */       return ia.getIDLModuleName() + "::" + ia.getIDLName();
/*     */     }
/*     */ 
/* 121 */     if ((cls.isInterface()) && (org.omg.CORBA.Object.class.isAssignableFrom(cls)) && (IDLEntity.class.isAssignableFrom(cls)))
/*     */     {
/* 124 */       InterfaceAnalysis ia = InterfaceAnalysis.getInterfaceAnalysis(cls);
/*     */ 
/* 126 */       return ia.getIDLModuleName() + "::" + ia.getIDLName();
/*     */     }
/*     */ 
/* 130 */     if ((Throwable.class.isAssignableFrom(cls)) && 
/* 131 */       (Exception.class.isAssignableFrom(cls)) && (!RuntimeException.class.isAssignableFrom(cls)))
/*     */     {
/* 133 */       ExceptionAnalysis ea = ExceptionAnalysis.getExceptionAnalysis(cls);
/*     */ 
/* 135 */       return ea.getIDLModuleName() + "::" + ea.getIDLName();
/*     */     }
/*     */ 
/* 140 */     ValueAnalysis va = ValueAnalysis.getValueAnalysis(cls);
/*     */ 
/* 142 */     return va.getIDLModuleName() + "::" + va.getIDLName();
/*     */   }
/*     */ 
/*     */   public static boolean isValidRMIIIOP(Class cls)
/*     */     throws RMIIIOPViolationException
/*     */   {
/* 152 */     if (cls.isPrimitive()) {
/* 153 */       return true;
/*     */     }
/* 155 */     if (cls.isArray()) {
/* 156 */       return isValidRMIIIOP(cls.getComponentType());
/*     */     }
/*     */ 
/* 159 */     if ((cls == Serializable.class) || (cls == Externalizable.class)) {
/* 160 */       return true;
/*     */     }
/*     */ 
/* 163 */     if ((cls.isInterface()) && (Remote.class.isAssignableFrom(cls))) {
/* 164 */       logger.debug("Util.isValidRMIIIOP(): doing interface analysis on " + cls.getName());
/*     */ 
/* 166 */       InterfaceAnalysis.getInterfaceAnalysis(cls);
/* 167 */       return true;
/*     */     }
/*     */ 
/* 171 */     if (Throwable.class.isAssignableFrom(cls)) {
/* 172 */       if ((Exception.class.isAssignableFrom(cls)) && (!RuntimeException.class.isAssignableFrom(cls)))
/*     */       {
/* 174 */         logger.debug("Util.isValidRMIIIOP(): doing exception analysis on " + cls.getName());
/*     */ 
/* 176 */         ExceptionAnalysis.getExceptionAnalysis(cls);
/*     */       }
/* 178 */       return true;
/*     */     }
/*     */ 
/* 182 */     if ((cls == java.lang.Object.class) || (cls == String.class) || (cls == Class.class)) {
/* 183 */       return true;
/*     */     }
/*     */ 
/* 186 */     logger.debug("Util.isValidRMIIIOP(): doing value analysis on " + cls.getName());
/*     */ 
/* 188 */     ValueAnalysis.getValueAnalysis(cls);
/* 189 */     return true;
/*     */   }
/*     */ 
/*     */   public static void insertAnyPrimitive(Any any, java.lang.Object primitive)
/*     */   {
/* 199 */     Class type = primitive.getClass();
/*     */ 
/* 201 */     if (type == Boolean.class)
/* 202 */       any.insert_boolean(((Boolean)primitive).booleanValue());
/* 203 */     else if (type == Character.class)
/* 204 */       any.insert_wchar(((Character)primitive).charValue());
/* 205 */     else if (type == Byte.class)
/* 206 */       any.insert_octet(((Byte)primitive).byteValue());
/* 207 */     else if (type == Short.class)
/* 208 */       any.insert_short(((Short)primitive).shortValue());
/* 209 */     else if (type == Integer.class)
/* 210 */       any.insert_long(((Integer)primitive).intValue());
/* 211 */     else if (type == Long.class)
/* 212 */       any.insert_longlong(((Long)primitive).longValue());
/* 213 */     else if (type == Float.class)
/* 214 */       any.insert_float(((Float)primitive).floatValue());
/* 215 */     else if (type == Double.class)
/* 216 */       any.insert_double(((Double)primitive).doubleValue());
/*     */     else
/* 218 */       throw new IllegalArgumentException("Not a primitive type: " + type.getName());
/*     */   }
/*     */ 
/*     */   public static String javaToIDLName(String name)
/*     */   {
/* 230 */     if (name == null) {
/* 231 */       throw new IllegalArgumentException("Null name.");
/*     */     }
/* 233 */     if ("".equals(name)) {
/* 234 */       throw new IllegalArgumentException("Empty name.");
/*     */     }
/* 236 */     if (name.indexOf('.') != -1) {
/* 237 */       throw new IllegalArgumentException("No qualified name allowed here.");
/*     */     }
/* 239 */     StringBuffer res = new StringBuffer(name.length());
/*     */ 
/* 241 */     if (name.charAt(0) == '_') {
/* 242 */       res.append('J');
/*     */     }
/* 244 */     for (int i = 0; i < name.length(); i++) {
/* 245 */       char c = name.charAt(i);
/*     */ 
/* 247 */       if (isLegalIDLIdentifierChar(c))
/* 248 */         res.append(c);
/*     */       else {
/* 250 */         res.append('U').append(toHexString(c));
/*     */       }
/*     */     }
/* 253 */     String s = res.toString();
/*     */ 
/* 255 */     if (isReservedIDLKeyword(s)) {
/* 256 */       return "_" + s;
/*     */     }
/* 258 */     return s;
/*     */   }
/*     */ 
/*     */   public static String getIRIdentifierOfClass(Class cls)
/*     */   {
/* 269 */     if (cls.isPrimitive()) {
/* 270 */       throw new IllegalArgumentException("Primitives have no IR IDs.");
/*     */     }
/* 272 */     String result = (String)classIRIdentifierCache.get(cls);
/* 273 */     if (result != null) {
/* 274 */       return result;
/*     */     }
/* 276 */     String name = cls.getName();
/* 277 */     StringBuffer b = new StringBuffer("RMI:");
/*     */ 
/* 279 */     for (int i = 0; i < name.length(); i++) {
/* 280 */       char c = name.charAt(i);
/*     */ 
/* 282 */       if (c < 'Ā')
/* 283 */         b.append(c);
/*     */       else {
/* 285 */         b.append("\\U").append(toHexString(c));
/*     */       }
/*     */     }
/* 288 */     long clsHash = getClassHashCode(cls);
/*     */ 
/* 290 */     b.append(':').append(toHexString(clsHash));
/*     */ 
/* 292 */     ObjectStreamClass osClass = ObjectStreamClass.lookup(cls);
/* 293 */     if (osClass != null) {
/* 294 */       long serialVersionUID = osClass.getSerialVersionUID();
/*     */ 
/* 296 */       if (clsHash != serialVersionUID) {
/* 297 */         b.append(':').append(toHexString(serialVersionUID));
/*     */       }
/*     */     }
/* 300 */     result = b.toString();
/*     */ 
/* 302 */     classIRIdentifierCache.put(cls, result);
/*     */ 
/* 304 */     return result;
/*     */   }
/*     */ 
/*     */   private static String toHexString(int i)
/*     */   {
/* 391 */     String s = Integer.toHexString(i).toUpperCase();
/*     */ 
/* 393 */     if (s.length() < 8) {
/* 394 */       return "00000000".substring(8 - s.length()) + s;
/*     */     }
/* 396 */     return s;
/*     */   }
/*     */ 
/*     */   private static String toHexString(long l)
/*     */   {
/* 403 */     String s = Long.toHexString(l).toUpperCase();
/*     */ 
/* 405 */     if (s.length() < 16) {
/* 406 */       return "0000000000000000".substring(16 - s.length()) + s;
/*     */     }
/* 408 */     return s;
/*     */   }
/*     */ 
/*     */   private static boolean isReservedIDLKeyword(String s)
/*     */   {
/* 417 */     for (int i = 0; i < reservedIDLKeywords.length; i++)
/* 418 */       if (reservedIDLKeywords[i].equals(s))
/* 419 */         return true;
/* 420 */     return false;
/*     */   }
/*     */ 
/*     */   private static boolean isLegalIDLIdentifierChar(char c)
/*     */   {
/* 428 */     if ((c >= 'a') && (c <= 'z')) {
/* 429 */       return true;
/*     */     }
/* 431 */     if ((c >= '0') && (c <= '9')) {
/* 432 */       return true;
/*     */     }
/* 434 */     if ((c >= 'A') && (c <= 'Z')) {
/* 435 */       return true;
/*     */     }
/*     */ 
/* 438 */     return c == '_';
/*     */   }
/*     */ 
/*     */   private static boolean isLegalIDLStartIdentifierChar(char c)
/*     */   {
/* 448 */     if ((c >= 'a') && (c <= 'z')) {
/* 449 */       return true;
/*     */     }
/*     */ 
/* 452 */     return (c >= 'A') && (c <= 'Z');
/*     */   }
/*     */ 
/*     */   static long getClassHashCode(Class cls)
/*     */   {
/* 465 */     if (cls.isInterface())
/* 466 */       return 0L;
/* 467 */     if (!Serializable.class.isAssignableFrom(cls))
/* 468 */       return 0L;
/* 469 */     if (Externalizable.class.isAssignableFrom(cls)) {
/* 470 */       return 1L;
/*     */     }
/*     */ 
/* 473 */     Long l = (Long)classHashCodeCache.get(cls);
/* 474 */     if (l != null) {
/* 475 */       return l.longValue();
/*     */     }
/*     */ 
/* 479 */     ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
/* 480 */     DataOutputStream dos = new DataOutputStream(baos);
/*     */ 
/* 483 */     Class superClass = cls.getSuperclass();
/* 484 */     if ((superClass != null) && (superClass != java.lang.Object.class)) {
/*     */       try {
/* 486 */         dos.writeLong(getClassHashCode(superClass));
/*     */       } catch (IOException ex) {
/* 488 */         throw new RuntimeException("Unexpected IOException: " + ex);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 493 */     boolean hasWriteObject = false;
/*     */     try
/*     */     {
/* 498 */       Method m = cls.getDeclaredMethod("writeObject", new Class[] { ObjectOutputStream.class });
/*     */ 
/* 500 */       int mods = m.getModifiers();
/*     */ 
/* 502 */       if ((!Modifier.isPrivate(mods)) && (!Modifier.isStatic(mods)))
/* 503 */         hasWriteObject = true;
/*     */     }
/*     */     catch (NoSuchMethodException ex) {
/*     */     }
/*     */     try {
/* 508 */       dos.writeInt(hasWriteObject ? 2 : 1);
/*     */     } catch (IOException ex) {
/* 510 */       throw new RuntimeException("Unexpected IOException: " + ex);
/*     */     }
/*     */ 
/* 514 */     Field[] fields = cls.getDeclaredFields();
/* 515 */     SortedSet set = new TreeSet(new FieldComparator(null));
/*     */ 
/* 517 */     for (int i = 0; i < fields.length; i++) {
/* 518 */       int mods = fields[i].getModifiers();
/*     */ 
/* 520 */       if ((!Modifier.isStatic(mods)) && (!Modifier.isTransient(mods)))
/* 521 */         set.add(fields[i]);
/*     */     }
/* 523 */     Iterator iter = set.iterator();
/*     */     try {
/* 525 */       while (iter.hasNext()) {
/* 526 */         Field f = (Field)iter.next();
/*     */ 
/* 528 */         dos.writeUTF(f.getName());
/* 529 */         dos.writeUTF(getSignature(f.getType()));
/*     */       }
/*     */     } catch (IOException ex) {
/* 532 */       throw new RuntimeException("Unexpected IOException: " + ex);
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 537 */       dos.flush();
/*     */     } catch (IOException ex) {
/* 539 */       throw new RuntimeException("Unexpected IOException: " + ex);
/*     */     }
/* 541 */     byte[] bytes = baos.toByteArray();
/*     */     MessageDigest digest;
/*     */     try {
/* 546 */       digest = MessageDigest.getInstance("SHA");
/*     */     } catch (NoSuchAlgorithmException ex) {
/* 548 */       throw new RuntimeException("No SHA MEssageDigest: " + ex);
/*     */     }
/* 550 */     digest.update(bytes);
/* 551 */     byte[] sha = digest.digest();
/*     */ 
/* 554 */     long hash = 0L;
/* 555 */     for (int i = 0; i < Math.min(8, sha.length); i++) {
/* 556 */       hash += ((sha[i] & 0xFF) << i * 8);
/*     */     }
/*     */ 
/* 560 */     classHashCodeCache.put(cls, new Long(hash));
/*     */ 
/* 562 */     return hash;
/*     */   }
/*     */ 
/*     */   private static String getSignature(Class cls)
/*     */   {
/* 571 */     if (cls.isArray()) {
/* 572 */       return "[" + cls.getComponentType();
/*     */     }
/* 574 */     if (cls.isPrimitive()) {
/* 575 */       if (cls == Byte.TYPE)
/* 576 */         return "B";
/* 577 */       if (cls == Character.TYPE)
/* 578 */         return "C";
/* 579 */       if (cls == Double.TYPE)
/* 580 */         return "D";
/* 581 */       if (cls == Float.TYPE)
/* 582 */         return "F";
/* 583 */       if (cls == Integer.TYPE)
/* 584 */         return "I";
/* 585 */       if (cls == Long.TYPE)
/* 586 */         return "J";
/* 587 */       if (cls == Short.TYPE)
/* 588 */         return "S";
/* 589 */       if (cls == Boolean.TYPE)
/* 590 */         return "Z";
/* 591 */       throw new RuntimeException("Unknown primitive class.");
/*     */     }
/*     */ 
/* 594 */     return "L" + cls.getName().replace('.', '/') + ";";
/*     */   }
/*     */ 
/*     */   private static String getSignature(Method method)
/*     */   {
/* 603 */     StringBuffer b = new StringBuffer("(");
/* 604 */     Class[] parameterTypes = method.getParameterTypes();
/*     */ 
/* 606 */     for (int i = 0; i < parameterTypes.length; i++) {
/* 607 */       b.append(getSignature(parameterTypes[i]));
/*     */     }
/* 609 */     b.append(')').append(getSignature(method.getReturnType()));
/*     */ 
/* 611 */     return b.toString();
/*     */   }
/*     */ 
/*     */   static String primitiveTypeIDLName(Class type)
/*     */   {
/* 619 */     if (type == Void.TYPE)
/* 620 */       return "void";
/* 621 */     if (type == Boolean.TYPE)
/* 622 */       return "boolean";
/* 623 */     if (type == Character.TYPE)
/* 624 */       return "wchar";
/* 625 */     if (type == Byte.TYPE)
/* 626 */       return "octet";
/* 627 */     if (type == Short.TYPE)
/* 628 */       return "short";
/* 629 */     if (type == Integer.TYPE)
/* 630 */       return "long";
/* 631 */     if (type == Long.TYPE)
/* 632 */       return "long long";
/* 633 */     if (type == Float.TYPE)
/* 634 */       return "float";
/* 635 */     if (type == Double.TYPE)
/* 636 */       return "double";
/* 637 */     throw new IllegalArgumentException("Not a primitive type.");
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 381 */     classHashCodeCache = Collections.synchronizedMap(new WeakHashMap());
/*     */ 
/* 383 */     classIRIdentifierCache = Collections.synchronizedMap(new WeakHashMap());
/*     */   }
/*     */ 
/*     */   private static class FieldComparator
/*     */     implements Comparator
/*     */   {
/*     */     public int compare(java.lang.Object o1, java.lang.Object o2)
/*     */     {
/* 652 */       if (o1 == o2) {
/* 653 */         return 0;
/*     */       }
/* 655 */       String n1 = ((Field)o1).getName();
/* 656 */       String n2 = ((Field)o2).getName();
/*     */ 
/* 658 */       return n1.compareTo(n2);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     org.jboss.iiop.rmi.Util
 * JD-Core Version:    0.6.0
 */